/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.update;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class ConfigUpdater {
    private final JavaPlugin plugin;

    public ConfigUpdater(@NotNull JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void updateConfig() {
        String configVersion;
        FileConfiguration config = this.plugin.getConfig();
        String pluginVersion = this.plugin.getPluginMeta().getVersion();
        if (pluginVersion.equals(configVersion = config.getString("config.version", "0.0.0"))) {
            return;
        }
        Configuration configuration = config.getDefaults();
        if (!(configuration instanceof FileConfiguration)) {
            return;
        }
        FileConfiguration updatedConfig = (FileConfiguration)configuration;
        for (String key : config.getKeys(true)) {
            Object value;
            if (key.startsWith("config") || (value = config.get(key)) == null || value instanceof ConfigurationSection || !updatedConfig.contains(key) || updatedConfig.isConfigurationSection(key)) continue;
            updatedConfig.set(key, value);
        }
        Path dataPath = this.plugin.getDataPath();
        Path configPath = dataPath.resolve("config.yml");
        Path backupPath = dataPath.resolve("backups").resolve("config.yml");
        try {
            Files.createDirectories(backupPath.getParent(), new FileAttribute[0]);
            Files.move(configPath, backupPath, StandardCopyOption.REPLACE_EXISTING);
            updatedConfig.save(configPath.toFile());
            this.plugin.getComponentLogger().info("successfully updated config.yml");
        }
        catch (IOException exception) {
            this.plugin.getComponentLogger().warn("failed to update config.yml: {}", (Object)exception.getMessage());
        }
    }
}

