/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.module;

import com.uravgcode.modernessentials.annotation.ConfigModule;
import com.uravgcode.modernessentials.annotation.ConfigValue;
import com.uravgcode.modernessentials.module.PluginModule;
import com.uravgcode.modernessentials.placeholder.Placeholders;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Server;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@ConfigModule(path="tab-list")
public final class TabListModule
extends PluginModule {
    private final MiniMessage miniMessage = MiniMessage.builder().tags(TagResolver.resolver((TagResolver[])new TagResolver[]{TagResolver.standard(), Placeholders.globalPlaceholders(), Placeholders.audiencePlaceholders()})).build();
    private ScheduledTask task = null;
    @ConfigValue(path="tab-list.format")
    private String format = "<player>";
    @ConfigValue(path="tab-list.header")
    private String headerString = "";
    @ConfigValue(path="tab-list.footer")
    private String footerString = "";
    @ConfigValue(path="tab-list.refresh-interval")
    private long refreshInterval = 20L;

    public TabListModule(@NotNull JavaPlugin plugin) {
        super(plugin);
    }

    @Override
    public void enable() {
        if (this.task != null) {
            return;
        }
        this.enabled = true;
        GlobalRegionScheduler scheduler = this.plugin.getServer().getGlobalRegionScheduler();
        this.task = scheduler.runAtFixedRate((Plugin)this.plugin, this::updatePlayerList, 1L, this.refreshInterval);
    }

    @Override
    public void disable() {
        if (this.task == null) {
            return;
        }
        this.enabled = false;
        this.task.cancel();
        this.task = null;
    }

    private void updatePlayerList(ScheduledTask ignored) {
        Server server = this.plugin.getServer();
        for (Player player : server.getOnlinePlayers()) {
            Component name = this.miniMessage.deserialize(this.format, (Pointered)player);
            Component header = this.miniMessage.deserialize(this.headerString, (Pointered)player);
            Component footer = this.miniMessage.deserialize(this.footerString, (Pointered)player);
            player.playerListName(name);
            player.sendPlayerListHeaderAndFooter(header, footer);
        }
    }
}

