/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.module;

import com.uravgcode.modernessentials.annotation.CommandModule;
import com.uravgcode.modernessentials.event.FlyEvent;
import com.uravgcode.modernessentials.module.PluginModule;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.GameMode;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@CommandModule(name="fly")
public final class FlyModule
extends PluginModule {
    public final NamespacedKey flyKey;

    public FlyModule(@NotNull JavaPlugin plugin) {
        super(plugin);
        this.flyKey = new NamespacedKey((Plugin)plugin, "fly");
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onFly(FlyEvent event) {
        Player player = event.getPlayer();
        PersistentDataContainer dataContainer = player.getPersistentDataContainer();
        if (dataContainer.has(this.flyKey)) {
            this.disableFlight(player);
            dataContainer.remove(this.flyKey);
            player.sendMessage((Component)Component.text((String)"Fly mode disabled", (TextColor)NamedTextColor.RED));
        } else {
            this.enableFlight(player);
            dataContainer.set(this.flyKey, PersistentDataType.BYTE, (Object)1);
            player.sendMessage((Component)Component.text((String)"Fly mode enabled", (TextColor)NamedTextColor.GREEN));
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.shouldEnableFlight(player)) {
            this.enableFlight(player);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onGameModeChange(PlayerGameModeChangeEvent event) {
        Player player = event.getPlayer();
        if (this.shouldEnableFlight(player)) {
            this.enableFlight(player);
        }
    }

    private void enableFlight(@NotNull Player player) {
        player.getScheduler().run((Plugin)this.plugin, task -> {
            player.setAllowFlight(true);
            if (player.isOnGround()) {
                return;
            }
            player.setFlying(true);
        }, null);
    }

    private void disableFlight(@NotNull Player player) {
        GameMode gameMode = player.getGameMode();
        if (gameMode == GameMode.SURVIVAL || gameMode == GameMode.ADVENTURE) {
            player.setAllowFlight(false);
        }
    }

    private boolean shouldEnableFlight(Player player) {
        return player.getPersistentDataContainer().has(this.flyKey) && player.hasPermission("essentials.fly");
    }
}

