/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.module;

import com.uravgcode.modernessentials.annotation.ConfigModule;
import com.uravgcode.modernessentials.annotation.ConfigValue;
import com.uravgcode.modernessentials.module.PluginModule;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerCommandSendEvent;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@ConfigModule(path="command-filter")
public final class CommandFilterModule
extends PluginModule {
    @ConfigValue(path="command-filter.mode")
    private Mode mode = Mode.BLACKLIST;
    @ConfigValue(path="command-filter.commands")
    private Set<String> commands = Set.of();

    public CommandFilterModule(@NotNull JavaPlugin plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerCommandSend(PlayerCommandSendEvent event) {
        if (event.getPlayer().hasPermission("essentials.commandfilter.bypass")) {
            return;
        }
        event.getCommands().removeIf(command -> this.mode == Mode.WHITELIST != this.commands.contains(this.getLiteral((String)command)));
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        String message;
        String literal;
        Player player = event.getPlayer();
        if (player.hasPermission("essentials.commandfilter.bypass")) {
            return;
        }
        if (this.mode == Mode.WHITELIST == this.commands.contains(literal = this.getLiteral(message = event.getMessage()))) {
            return;
        }
        event.setCancelled(true);
        player.sendMessage(Component.textOfChildren((ComponentLike[])new ComponentLike[]{Component.translatable((String)"command.unknown.command"), Component.newline(), Component.textOfChildren((ComponentLike[])new ComponentLike[]{Component.text((String)message.substring(1)).decorate(TextDecoration.UNDERLINED), Component.translatable((String)"command.context.here")}).clickEvent(ClickEvent.suggestCommand((String)message))}).color((TextColor)NamedTextColor.RED));
    }

    @NotNull
    private String getLiteral(@NotNull String command) {
        int spaceIndex = command.indexOf(32);
        int end = spaceIndex != -1 ? spaceIndex : command.length();
        int colonIndex = command.indexOf(58);
        int start = colonIndex != -1 && colonIndex < end ? colonIndex + 1 : (command.startsWith("/") ? 1 : 0);
        return command.substring(start, end);
    }

    private static enum Mode {
        WHITELIST,
        BLACKLIST;

    }
}

