/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.manager;

import com.google.common.reflect.ClassPath;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.uravgcode.modernessentials.command.CommandBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.plugin.lifecycle.event.registrar.ReloadableRegistrarEvent;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public final class CommandManager {
    private final ComponentLogger logger;
    private final File configFile;

    public CommandManager(@NotNull BootstrapContext context) {
        this.logger = context.getLogger();
        this.configFile = context.getDataDirectory().resolve("config.yml").toFile();
    }

    public void registerCommands(ReloadableRegistrarEvent<@NotNull Commands> commands) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.configFile);
        Set disabledCommands = Set.copyOf(config.getStringList("commands.disabled"));
        int count = 0;
        for (Class<? extends CommandBuilder> clazz : this.discoverCommands()) {
            try {
                Constructor<? extends CommandBuilder> constructor = clazz.getDeclaredConstructor(new Class[0]);
                CommandBuilder pluginCommand = constructor.newInstance(new Object[0]);
                LiteralCommandNode<CommandSourceStack> command = pluginCommand.build();
                String literal = command.getLiteral();
                if (disabledCommands.contains(literal)) continue;
                ((Commands)commands.registrar()).register(command);
                ++count;
            }
            catch (Exception exception) {
                this.logger.warn("Failed to register {}: {}", (Object)clazz.getSimpleName(), (Object)exception.getMessage());
            }
        }
        this.logger.info("Registered {} commands", (Object)count);
    }

    private List<@NotNull Class<? extends CommandBuilder>> discoverCommands() {
        ArrayList<Class<? extends CommandBuilder>> commandClasses = new ArrayList<Class<? extends CommandBuilder>>();
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            ClassPath classPath = ClassPath.from((ClassLoader)classLoader);
            String packageName = "com.uravgcode.modernessentials.command";
            for (ClassPath.ClassInfo classInfo : classPath.getTopLevelClassesRecursive("com.uravgcode.modernessentials.command")) {
                Class clazz = classInfo.load();
                if (!CommandBuilder.class.isAssignableFrom(clazz) || Modifier.isAbstract(clazz.getModifiers()) || clazz.isInterface()) continue;
                Class<CommandBuilder> commandClass = clazz.asSubclass(CommandBuilder.class);
                commandClasses.add(commandClass);
            }
        }
        catch (Exception exception) {
            this.logger.error("Failed to load command classes", (Throwable)exception);
        }
        return commandClasses;
    }
}

