/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.command.weather;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.uravgcode.modernessentials.ModernEssentials;
import com.uravgcode.modernessentials.command.CommandBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.text.Component;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public abstract class WeatherCommand
implements CommandBuilder {
    protected final String name;
    protected final boolean storm;
    protected final boolean thunder;
    protected final String key;

    protected WeatherCommand(@NotNull String name, boolean storm, boolean thunder, @NotNull String key) {
        this.name = name;
        this.storm = storm;
        this.thunder = thunder;
        this.key = key;
    }

    @Override
    public LiteralCommandNode<CommandSourceStack> build() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.name).requires(this.permission("essentials.weather"))).executes(this::setWeather)).build();
    }

    private int setWeather(CommandContext<CommandSourceStack> context) {
        ModernEssentials plugin = ModernEssentials.instance();
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Server server = sender.getServer();
        Entity executor = ((CommandSourceStack)context.getSource()).getExecutor();
        World world = executor != null ? executor.getWorld() : server.getRespawnWorld();
        sender.sendMessage((Component)Component.translatable((String)this.key));
        server.getGlobalRegionScheduler().execute((Plugin)plugin, () -> {
            world.setStorm(this.storm);
            world.setThundering(this.thunder);
        });
        return 1;
    }
}

