/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.command.time;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.uravgcode.modernessentials.ModernEssentials;
import com.uravgcode.modernessentials.command.CommandBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public abstract class TimeCommand
implements CommandBuilder {
    protected final String name;
    protected final long time;

    protected TimeCommand(@NotNull String name, long time) {
        this.name = name;
        this.time = time;
    }

    @Override
    public LiteralCommandNode<CommandSourceStack> build() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.name).requires(this.permission("essentials.time"))).executes(this::setTime)).build();
    }

    private int setTime(CommandContext<CommandSourceStack> context) {
        ModernEssentials plugin = ModernEssentials.instance();
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        Server server = sender.getServer();
        Entity executor = ((CommandSourceStack)context.getSource()).getExecutor();
        World world = executor != null ? executor.getWorld() : server.getRespawnWorld();
        sender.sendMessage((Component)Component.translatable((String)"commands.time.set", (ComponentLike[])new ComponentLike[]{Component.text((long)this.time)}));
        server.getGlobalRegionScheduler().execute((Plugin)plugin, () -> world.setTime(this.time));
        return 1;
    }
}

