/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.uravgcode.modernessentials.command.CommandBuilder;
import com.uravgcode.modernessentials.event.NicknameEvent;
import com.uravgcode.modernessentials.exception.RequiresPlayerException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public final class NicknameCommand
implements CommandBuilder {
    @Override
    public LiteralCommandNode<CommandSourceStack> build() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"nickname").requires(this.permission("essentials.nickname"))).then(Commands.argument((String)"nickname", (ArgumentType)StringArgumentType.word()).executes(this::nicknameSelf))).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)ArgumentTypes.player()).requires(this.permission("essentials.nickname.others"))).then(Commands.argument((String)"nickname", (ArgumentType)StringArgumentType.word()).executes(this::nicknameOther)))).build();
    }

    private int nicknameSelf(CommandContext<CommandSourceStack> context) throws RequiresPlayerException {
        Player player = this.player(context);
        String nicknameArgument = (String)context.getArgument("nickname", String.class);
        String nickname = nicknameArgument.equals(player.getName()) ? null : nicknameArgument;
        player.getServer().getPluginManager().callEvent((Event)new NicknameEvent(player, nickname));
        if (nickname == null) {
            player.sendMessage("Nickname removed");
        } else {
            player.sendMessage("Nickname changed");
        }
        return 1;
    }

    private int nicknameOther(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        PlayerSelectorArgumentResolver targetResolver = (PlayerSelectorArgumentResolver)context.getArgument("target", PlayerSelectorArgumentResolver.class);
        Player target = (Player)((List)targetResolver.resolve((CommandSourceStack)context.getSource())).getFirst();
        String nicknameArgument = (String)context.getArgument("nickname", String.class);
        String nickname = nicknameArgument.equals(target.getName()) ? null : nicknameArgument;
        target.getServer().getPluginManager().callEvent((Event)new NicknameEvent(target, nickname));
        if (nickname == null) {
            ((CommandSourceStack)context.getSource()).getSender().sendMessage("Nickname removed");
        } else {
            ((CommandSourceStack)context.getSource()).getSender().sendMessage("Nickname changed");
        }
        return 1;
    }
}

