/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.argument;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.uravgcode.modernessentials.exception.BadSourceException;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class OtherPlayerArgument
implements CustomArgumentType<Player, PlayerSelectorArgumentResolver> {
    private static final SimpleCommandExceptionType INVALID_TARGET = new SimpleCommandExceptionType(() -> "You cannot target yourself");

    public Player parse(StringReader reader) {
        throw new UnsupportedOperationException();
    }

    public <S> Player parse(StringReader reader, S source) throws CommandSyntaxException {
        if (!(source instanceof CommandSourceStack)) {
            throw new BadSourceException();
        }
        CommandSourceStack stack = (CommandSourceStack)source;
        CommandSender sender = stack.getSender();
        Player player = (Player)((List)((PlayerSelectorArgumentResolver)this.getNativeType().parse(reader)).resolve(stack)).getFirst();
        if (player.equals((Object)sender)) {
            throw INVALID_TARGET.create();
        }
        return player;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Object object = context.getSource();
        if (!(object instanceof CommandSourceStack)) {
            return Suggestions.empty();
        }
        CommandSourceStack stack = (CommandSourceStack)object;
        String senderName = stack.getSender().getName();
        return ArgumentTypes.player().listSuggestions(context, builder).thenApply(suggestions -> {
            suggestions.getList().removeIf(suggestion -> suggestion.getText().equalsIgnoreCase(senderName));
            return suggestions;
        });
    }

    public ArgumentType<PlayerSelectorArgumentResolver> getNativeType() {
        return ArgumentTypes.player();
    }
}

