/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.module;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.uravgcode.modernessentials.annotation.CommandModule;
import com.uravgcode.modernessentials.event.warp.DelWarpEvent;
import com.uravgcode.modernessentials.event.warp.SetWarpEvent;
import com.uravgcode.modernessentials.event.warp.WarpEvent;
import com.uravgcode.modernessentials.module.PluginModule;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@CommandModule(name="warp")
public final class WarpModule
extends PluginModule {
    private static final TreeMap<String, Location> warps = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private final File file;

    public WarpModule(@NotNull JavaPlugin plugin) {
        super(plugin);
        this.file = plugin.getDataPath().resolve("warps.yml").toFile();
    }

    public static CompletableFuture<Suggestions> suggestions(CommandContext<CommandSourceStack> ignored, SuggestionsBuilder builder) {
        String remaining = builder.getRemainingLowerCase();
        for (String warp : warps.tailMap(remaining).keySet()) {
            if (!warp.toLowerCase().startsWith(remaining)) break;
            builder.suggest(warp);
        }
        return builder.buildFuture();
    }

    @Override
    public void reload() {
        super.reload();
        warps.clear();
        ComponentLogger logger = this.plugin.getComponentLogger();
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.file);
        for (String name : config.getKeys(false)) {
            Location location = config.getLocation(name);
            if (location != null) {
                warps.put(name, location);
                continue;
            }
            logger.warn("Warp '{}' does not contain a valid location", (Object)name);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onWarp(WarpEvent event) {
        String name = event.getName();
        Player player = event.getPlayer();
        Location location = warps.get(name);
        if (location != null) {
            player.teleportAsync(location);
        } else {
            player.sendMessage((Component)Component.text((String)"Warp not found", (TextColor)NamedTextColor.RED));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onSetWarp(SetWarpEvent event) {
        Player player;
        Location location;
        String name = event.getName();
        if (warps.put(name, location = (player = event.getPlayer()).getLocation()) == null) {
            player.sendMessage("Warp created");
        } else {
            player.sendMessage("Warp set");
        }
        this.saveWarps();
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onDelWarp(DelWarpEvent event) {
        String name = event.getName();
        CommandSender sender = event.getSender();
        if (warps.remove(name) != null) {
            sender.sendMessage("Warp deleted");
            this.saveWarps();
        } else {
            sender.sendMessage((Component)Component.text((String)"Warp not found", (TextColor)NamedTextColor.RED));
        }
    }

    private void saveWarps() {
        Map<String, Location> snapshot = Map.copyOf(warps);
        CompletableFuture.runAsync(() -> {
            try {
                YamlConfiguration config = new YamlConfiguration();
                snapshot.forEach((arg_0, arg_1) -> ((YamlConfiguration)config).set(arg_0, arg_1));
                config.save(this.file);
            }
            catch (IOException exception) {
                this.plugin.getComponentLogger().error("Could not save warps.yml", (Throwable)exception);
            }
        });
    }
}

