/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials.manager;

import com.google.common.reflect.ClassPath;
import com.uravgcode.modernessentials.module.PluginModule;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class ModuleManager {
    private static final List<@NotNull PluginModule> modules = new ArrayList<PluginModule>();

    private ModuleManager() {
    }

    public static List<@NotNull Class<? extends PluginModule>> discoverModules() {
        try {
            ArrayList<Class<? extends PluginModule>> moduleClasses = new ArrayList<Class<? extends PluginModule>>();
            ClassLoader classLoader = ModuleManager.class.getClassLoader();
            ClassPath classPath = ClassPath.from((ClassLoader)classLoader);
            String packageName = "com.uravgcode.modernessentials.module";
            for (ClassPath.ClassInfo classInfo : classPath.getTopLevelClassesRecursive("com.uravgcode.modernessentials.module")) {
                Class clazz = classInfo.load();
                if (!PluginModule.class.isAssignableFrom(clazz) || Modifier.isAbstract(clazz.getModifiers()) || clazz.isInterface()) continue;
                Class<PluginModule> moduleClass = clazz.asSubclass(PluginModule.class);
                moduleClasses.add(moduleClass);
            }
            return moduleClasses;
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void initializeModules(@NotNull JavaPlugin plugin) {
        ComponentLogger logger = plugin.getComponentLogger();
        modules.clear();
        for (Class<? extends PluginModule> clazz : ModuleManager.discoverModules()) {
            try {
                Constructor<? extends PluginModule> constructor = clazz.getConstructor(JavaPlugin.class);
                PluginModule module = constructor.newInstance(plugin);
                modules.add(module);
            }
            catch (Exception exception) {
                logger.warn("Failed to initialize {}: {}", (Object)clazz.getSimpleName(), (Object)exception.getMessage());
            }
        }
        logger.info("Initialized {} modules", (Object)modules.size());
    }

    public static void reloadModules() {
        modules.forEach(PluginModule::reload);
    }
}

