/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.modernessentials;

import com.uravgcode.modernessentials.manager.ModuleManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class ModernEssentials
extends JavaPlugin {
    private static ModernEssentials instance = null;

    @NotNull
    public static ModernEssentials instance() {
        return Objects.requireNonNull(instance, "plugin not initialized");
    }

    public void onLoad() {
        instance = this;
    }

    public void onEnable() {
        String configVersion;
        String pluginVersion = this.getPluginMeta().getVersion();
        if (!pluginVersion.equals(configVersion = this.getConfig().getString("config.version", "0.0.0"))) {
            this.updateConfig();
        }
        ModuleManager.initializeModules(this);
        this.reload();
    }

    public void reload() {
        this.saveDefaultConfig();
        this.reloadConfig();
        ModuleManager.reloadModules();
    }

    private void updateConfig() {
        ComponentLogger logger = this.getComponentLogger();
        Path configPath = this.getDataPath().resolve("config.yml");
        Path backupPath = this.getDataPath().resolve("backups").resolve("config.yml");
        try {
            FileConfiguration config = this.getConfig();
            Configuration configuration = config.getDefaults();
            if (!(configuration instanceof FileConfiguration)) {
                return;
            }
            FileConfiguration updatedConfig = (FileConfiguration)configuration;
            for (String key : config.getKeys(true)) {
                Object value;
                if (key.startsWith("config") || (value = config.get(key)) == null || value instanceof ConfigurationSection || !updatedConfig.contains(key) || updatedConfig.isConfigurationSection(key)) continue;
                updatedConfig.set(key, value);
            }
            Files.createDirectories(backupPath.getParent(), new FileAttribute[0]);
            Files.move(configPath, backupPath, StandardCopyOption.REPLACE_EXISTING);
            updatedConfig.save(configPath.toFile());
            logger.info("successfully updated config.yml");
        }
        catch (IOException exception) {
            logger.warn("failed to update config.yml: {}", (Object)exception.getMessage());
        }
    }
}

