/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.chestsortplus.sorter;

import com.uravgcode.chestsortplus.comparator.ItemComparator;
import java.util.ArrayList;
import java.util.Comparator;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class InventorySorter {
    private final Comparator<ItemStack> comparator = new ItemComparator();

    public void sortInventory(@NotNull Inventory inventory) {
        this.sortInventory(inventory, 0, inventory.getSize() - 1);
    }

    public void sortInventory(@NotNull Inventory inventory, int startSlot, int endSlot) {
        ItemStack[] contents = inventory.getContents();
        Inventory combined = Bukkit.getServer().createInventory(null, 54);
        for (int i = startSlot; i <= endSlot; ++i) {
            if (contents[i] == null) continue;
            combined.addItem(new ItemStack[]{contents[i]});
            inventory.clear(i);
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack item : combined.getContents()) {
            if (item == null || item.getType() == Material.AIR) break;
            items.add(item);
        }
        try {
            items.sort(this.comparator);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int currentSlot = startSlot;
        for (ItemStack item : items) {
            if (currentSlot > endSlot) break;
            inventory.setItem(currentSlot++, item);
        }
    }
}

