/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.chestsortplus.comparator;

import com.uravgcode.chestsortplus.ChestSortPlus;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;

public class MaterialComparator
implements Comparator<Material> {
    private final Map<Material, Integer> order = new EnumMap<Material, Integer>(Material.class);

    public MaterialComparator() {
        ChestSortPlus plugin = ChestSortPlus.instance();
        ComponentLogger logger = plugin.getComponentLogger();
        List categories = plugin.getConfig().getStringList("categories");
        int weight = 0;
        for (String category : categories) {
            try {
                InputStream stream = plugin.getResource("categories/" + category + ".yml");
                try {
                    if (stream == null) {
                        logger.warn("{}.yml not found", (Object)category);
                        continue;
                    }
                    YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(stream));
                    for (String name : config.getStringList("materials")) {
                        Material material = Material.matchMaterial((String)name);
                        if (material == null) continue;
                        this.order.put(material, weight++);
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException ignored) {
                logger.warn("failed to load {}.yml", (Object)category);
            }
        }
    }

    @Override
    public int compare(Material o1, Material o2) {
        Integer order1 = this.order.getOrDefault(o1, Integer.MAX_VALUE);
        Integer order2 = this.order.getOrDefault(o2, Integer.MAX_VALUE);
        return Integer.compare(order1, order2);
    }
}

