/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.chestsortplus.comparator;

import com.uravgcode.chestsortplus.comparator.EnchantmentComparator;
import com.uravgcode.chestsortplus.comparator.InstrumentComparator;
import com.uravgcode.chestsortplus.comparator.MaterialComparator;
import com.uravgcode.chestsortplus.comparator.PotionComparator;
import java.util.Comparator;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MusicInstrumentMeta;
import org.bukkit.inventory.meta.OminousBottleMeta;
import org.bukkit.inventory.meta.PotionMeta;

public final class ItemComparator
implements Comparator<ItemStack> {
    private final MaterialComparator materialComparator = new MaterialComparator();
    private final EnchantmentComparator enchantmentComparator = new EnchantmentComparator();
    private final PotionComparator potionComparator;
    private final InstrumentComparator instrumentComparator = new InstrumentComparator();

    public ItemComparator() {
        this.potionComparator = new PotionComparator();
    }

    @Override
    public int compare(ItemStack o1, ItemStack o2) {
        ItemMeta amplifier12;
        ItemMeta potionOrder2;
        ItemMeta instrumentOrder2;
        ItemMeta enchantmentOrder2;
        EnchantmentStorageMeta meta2;
        EnchantmentStorageMeta meta1;
        int materialOrder = this.materialComparator.compare(o1.getType(), o2.getType());
        if (materialOrder != 0) {
            return materialOrder;
        }
        ItemMeta itemMeta = o1.getItemMeta();
        if (itemMeta instanceof EnchantmentStorageMeta) {
            int enchantmentOrder2;
            meta1 = (EnchantmentStorageMeta)itemMeta;
            itemMeta = o2.getItemMeta();
            if (itemMeta instanceof EnchantmentStorageMeta && (enchantmentOrder2 = this.enchantmentComparator.compare(meta1, meta2 = (EnchantmentStorageMeta)itemMeta)) != 0) {
                return enchantmentOrder2;
            }
        }
        if ((enchantmentOrder2 = o1.getItemMeta()) instanceof MusicInstrumentMeta) {
            meta1 = (MusicInstrumentMeta)enchantmentOrder2;
            enchantmentOrder2 = o2.getItemMeta();
            if (enchantmentOrder2 instanceof MusicInstrumentMeta) {
                meta2 = (MusicInstrumentMeta)enchantmentOrder2;
                int instrumentOrder2 = this.instrumentComparator.compare(meta1.getInstrument(), meta2.getInstrument());
                if (instrumentOrder2 != 0) {
                    return instrumentOrder2;
                }
            }
        }
        if ((instrumentOrder2 = o1.getItemMeta()) instanceof PotionMeta) {
            meta1 = (PotionMeta)instrumentOrder2;
            instrumentOrder2 = o2.getItemMeta();
            if (instrumentOrder2 instanceof PotionMeta) {
                meta2 = (PotionMeta)instrumentOrder2;
                int potionOrder2 = this.potionComparator.compare(meta1.getBasePotionType(), meta2.getBasePotionType());
                if (potionOrder2 != 0) {
                    return potionOrder2;
                }
            }
        }
        if ((potionOrder2 = o1.getItemMeta()) instanceof OminousBottleMeta) {
            meta1 = (OminousBottleMeta)potionOrder2;
            potionOrder2 = o2.getItemMeta();
            if (potionOrder2 instanceof OminousBottleMeta) {
                int amplifier2;
                meta2 = (OminousBottleMeta)potionOrder2;
                int amplifier12 = meta1.hasAmplifier() ? meta1.getAmplifier() : 0;
                int ominousOrder = Integer.compare(amplifier12, amplifier2 = meta2.hasAmplifier() ? meta2.getAmplifier() : 0);
                if (ominousOrder != 0) {
                    return ominousOrder;
                }
            }
        }
        if ((amplifier12 = o1.getItemMeta()) instanceof FireworkMeta) {
            meta1 = (FireworkMeta)amplifier12;
            amplifier12 = o2.getItemMeta();
            if (amplifier12 instanceof FireworkMeta) {
                int power2;
                meta2 = (FireworkMeta)amplifier12;
                int power1 = meta1.hasPower() ? meta1.getPower() : 0;
                int fireworkOrder = Integer.compare(power1, power2 = meta2.hasPower() ? meta2.getPower() : 0);
                if (fireworkOrder != 0) {
                    return fireworkOrder;
                }
            }
        }
        PlainTextComponentSerializer serializer = PlainTextComponentSerializer.plainText();
        String name1 = serializer.serialize(o1.displayName());
        String name2 = serializer.serialize(o2.displayName());
        return name1.compareToIgnoreCase(name2);
    }
}

