/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.chestsortplus.sorter;

import com.uravgcode.chestsortplus.category.BuildingBlocks;
import com.uravgcode.chestsortplus.category.Category;
import com.uravgcode.chestsortplus.category.ColoredBlocks;
import com.uravgcode.chestsortplus.category.Combat;
import com.uravgcode.chestsortplus.category.FoodAndDrinks;
import com.uravgcode.chestsortplus.category.FunctionalBlocks;
import com.uravgcode.chestsortplus.category.Ingredients;
import com.uravgcode.chestsortplus.category.NaturalBlocks;
import com.uravgcode.chestsortplus.category.OpBlocks;
import com.uravgcode.chestsortplus.category.RedstoneBlocks;
import com.uravgcode.chestsortplus.category.SpawnEggs;
import com.uravgcode.chestsortplus.category.ToolsAndUtilities;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public final class ItemComparator
implements Comparator<ItemStack> {
    private final Map<Material, Integer> order = new EnumMap<Material, Integer>(Material.class);

    public ItemComparator() {
        List<Category> categories = List.of(new Combat(), new ToolsAndUtilities(), new FoodAndDrinks(), new Ingredients(), new SpawnEggs(), new BuildingBlocks(), new ColoredBlocks(), new NaturalBlocks(), new FunctionalBlocks(), new RedstoneBlocks(), new OpBlocks());
        int weight = 0;
        for (Category category : categories) {
            for (Material material : category.materials()) {
                this.order.put(material, weight++);
            }
        }
    }

    @Override
    public int compare(ItemStack o1, ItemStack o2) {
        Integer order1 = this.order.getOrDefault(o1.getType(), Integer.MAX_VALUE);
        Integer order2 = this.order.getOrDefault(o2.getType(), Integer.MAX_VALUE);
        int compareOrder = Integer.compare(order1, order2);
        if (compareOrder != 0) {
            return compareOrder;
        }
        PlainTextComponentSerializer serializer = PlainTextComponentSerializer.plainText();
        String name1 = serializer.serialize(o1.displayName());
        String name2 = serializer.serialize(o2.displayName());
        return name1.compareToIgnoreCase(name2);
    }
}

