/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.chestsortplus.listener;

import com.uravgcode.chestsortplus.sorter.InventorySorter;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Llama;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public final class InventoryListener
implements Listener {
    private final InventorySorter inventorySorter = new InventorySorter();

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.getWhoClicked().hasPermission("chestsort.use")) {
            return;
        }
        if (event.getClick() != ClickType.SHIFT_LEFT) {
            return;
        }
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem != null && clickedItem.getType() != Material.AIR) {
            return;
        }
        Inventory inventory = event.getClickedInventory();
        if (inventory == null) {
            return;
        }
        InventoryHolder holder = inventory.getHolder();
        if (holder == null) {
            return;
        }
        switch (inventory.getType()) {
            case PLAYER: {
                if (event.getSlotType() == InventoryType.SlotType.QUICKBAR) {
                    this.inventorySorter.sortInventory(inventory, 0, 8);
                } else {
                    this.inventorySorter.sortInventory(inventory, 9, 35);
                }
                event.setCancelled(true);
                break;
            }
            case ENDER_CHEST: 
            case SHULKER_BOX: 
            case BARREL: 
            case DROPPER: 
            case DISPENSER: 
            case HOPPER: {
                this.inventorySorter.sortInventory(inventory);
                event.setCancelled(true);
                break;
            }
            case CHEST: {
                InventoryHolder inventoryHolder = holder;
                Objects.requireNonNull(inventoryHolder);
                InventoryHolder inventoryHolder2 = inventoryHolder;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Llama.class, ChestedHorse.class}, (Object)inventoryHolder2, n)) {
                    case 0: {
                        Llama llama = (Llama)inventoryHolder2;
                        this.inventorySorter.sortInventory(inventory, 2, llama.getStrength() * 3 + 1);
                        break;
                    }
                    case 1: {
                        ChestedHorse ignored = (ChestedHorse)inventoryHolder2;
                        this.inventorySorter.sortInventory(inventory, 2, 16);
                        break;
                    }
                    default: {
                        this.inventorySorter.sortInventory(inventory);
                    }
                }
                event.setCancelled(true);
            }
        }
    }
}

