/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.tport;

import com.spaceman.tport.Main;
import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.permissions.PermissionHandler;
import com.spaceman.tport.tpEvents.TPRequest;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.waypoint.WaypointManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class TPortManager {
    public static final int TPortSize = 24;
    public static final UUID defUUID = UUID.fromString("11111111-1111-1111-1111-111111111111");

    public static ArrayList<TPort> getTPortList(UUID owner) {
        return TPortManager.getTPortList(Files.tportData, owner);
    }

    public static ArrayList<TPort> getTPortList(Files tportData, UUID owner) {
        ArrayList<TPort> tportList = new ArrayList<TPort>();
        for (String tportID : tportData.getKeys("tport." + String.valueOf(owner) + ".tports")) {
            TPort tport = (TPort)tportData.getConfig().get("tport." + String.valueOf(owner) + ".tports." + tportID);
            if (tport == null) continue;
            tport.setOwner(owner);
            tport.setTportID(UUID.fromString(tportID));
            tportList.add(tport);
        }
        return tportList;
    }

    public static List<TPort> getSortedTPortList(Files tportData, UUID owner) {
        TPort[] tportList = new TPort[24];
        for (String tportID : tportData.getKeys("tport." + String.valueOf(owner) + ".tports")) {
            TPort tport = (TPort)tportData.getConfig().get("tport." + String.valueOf(owner) + ".tports." + tportID);
            if (tport == null) continue;
            tport.setOwner(owner);
            tport.setTportID(UUID.fromString(tportID));
            tportList[tport.getSlot()] = tport;
        }
        return Arrays.asList(tportList);
    }

    public static TPort addTPort(Player owner, TPort tport, boolean sendMessage) {
        int maxTPorts = 24;
        boolean hasPer = false;
        for (int i = 24; i > 0; --i) {
            if (!PermissionHandler.hasPermission(owner, "TPort.add." + i, false)) continue;
            hasPer = true;
            maxTPorts = i;
            break;
        }
        if (!hasPer && !PermissionHandler.hasPermission(owner, false, true, "TPort.add", "TPort.basic")) {
            if (sendMessage) {
                PermissionHandler.sendNoPermMessage(owner, "TPort.add.[X]", "TPort.basic");
            }
            return null;
        }
        try {
            Long.parseLong(tport.getName());
            ColorTheme.sendErrorTranslation(owner, "tport.tport.tportManager.addTPort.numberName", new Object[0]);
            return null;
        }
        catch (NumberFormatException i) {
            if (Main.containsSpecialCharacter(tport.getName())) {
                ColorTheme.sendErrorTranslation(owner, "tport.tport.tportManager.addTPort.specialChars", "A-Z", "0-9", "-", "_");
                return null;
            }
            for (TPort tmpTPort : TPortManager.getTPortList(owner.getUniqueId())) {
                if (!tmpTPort.getName().equalsIgnoreCase(tport.getName())) continue;
                if (sendMessage) {
                    ColorTheme.sendErrorTranslation(owner, "tport.tport.tportManager.addTPort.nameUsed", tmpTPort, tport.getName());
                }
                return null;
            }
            int slot = TPortManager.getNextSlot(owner.getUniqueId(), 0, maxTPorts);
            if (slot == -1) {
                if (sendMessage) {
                    ColorTheme.sendErrorTranslation(owner, "tport.tport.tportManager.addTPort.fullList", new Object[0]);
                }
                return null;
            }
            if (slot == -2) {
                if (sendMessage) {
                    ColorTheme.sendErrorTranslation(owner, "tport.tport.tportManager.addTPort.maxExceeded", "TPort.add." + maxTPorts);
                }
                return null;
            }
            tport.setSlot(slot);
            if (tport.getTportID() == null) {
                tport.setTportID(TPortManager.getNextUUID());
            }
            if (!tport.getOwner().equals(owner.getUniqueId())) {
                TPortManager.removeTPort(tport);
                tport.setOwner(owner.getUniqueId());
            }
            tport.setOfferedTo(null);
            TPortManager.saveTPort(tport);
            if (sendMessage) {
                ColorTheme.sendSuccessTranslation(owner, "tport.tport.tportManager.addTPort.succeeded", tport);
            }
            TPortAdvancement.Advancement_saved.grant(owner);
            WaypointManager.registerTPort(tport);
            return tport;
        }
    }

    private static int getNextSlot(UUID owner, int testSlot, int maxTPorts) {
        if (testSlot >= 24) {
            return -1;
        }
        if (testSlot >= maxTPorts) {
            return -2;
        }
        for (String tportID : Files.tportData.getKeys("tport." + String.valueOf(owner) + ".tports")) {
            TPort tmpTPort = (TPort)Files.tportData.getConfig().get("tport." + String.valueOf(owner) + ".tports." + tportID);
            if (tmpTPort == null || tmpTPort.getSlot() != testSlot) continue;
            return TPortManager.getNextSlot(owner, testSlot + 1, maxTPorts);
        }
        return testSlot;
    }

    public static void removeTPort(TPort tport) {
        Files.tportData.getConfig().set("tport." + tport.getOwner().toString() + ".tports." + String.valueOf(tport.getTportID()), null);
        Files.tportData.saveConfig();
        TPRequest.tportRemoved(tport);
    }

    public static TPort getTPort(UUID tportID) {
        for (String playerUUID : Files.tportData.getKeys("tport")) {
            TPort tport = TPortManager.getTPort(UUID.fromString(playerUUID), tportID);
            if (tport == null) continue;
            return tport;
        }
        return null;
    }

    public static TPort getTPort(UUID owner, int slot) {
        for (String tportID : Files.tportData.getKeys("tport." + String.valueOf(owner) + ".tports")) {
            TPort tport = (TPort)Files.tportData.getConfig().get("tport." + String.valueOf(owner) + ".tports." + tportID);
            if (tport == null || tport.getSlot() != slot) continue;
            tport.setOwner(owner);
            tport.setTportID(UUID.fromString(tportID));
            return tport;
        }
        return null;
    }

    public static TPort getTPort(UUID owner, UUID tportID) {
        if (tportID.equals(defUUID)) {
            return new TPort(owner, null, new Location((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0), new ItemStack(Material.AIR));
        }
        TPort tport = (TPort)Files.tportData.getConfig().get("tport." + String.valueOf(owner) + ".tports." + String.valueOf(tportID));
        if (tport != null) {
            tport.setOwner(owner);
            tport.setTportID(tportID);
        }
        return tport;
    }

    public static TPort getTPort(UUID owner, String name) {
        if (name == null) {
            return new TPort(owner, null, new Location((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0), new ItemStack(Material.AIR));
        }
        for (String tportID : Files.tportData.getKeys("tport." + owner.toString() + ".tports")) {
            TPort tport = (TPort)Files.tportData.getConfig().get("tport." + String.valueOf(owner) + ".tports." + tportID);
            if (tport == null || !name.equalsIgnoreCase(tport.getName())) continue;
            tport.setOwner(owner);
            tport.setTportID(UUID.fromString(tportID));
            return tport;
        }
        return null;
    }

    public static void saveTPort(TPort tport) {
        Files.tportData.getConfig().set("tport." + String.valueOf(tport.getOwner()) + ".tports." + String.valueOf(tport.getTportID()), (Object)tport);
        Files.tportData.saveConfig();
    }

    public static UUID getNextUUID() {
        UUID nextUUID = UUID.randomUUID();
        if (nextUUID.equals(defUUID)) {
            return TPortManager.getNextUUID();
        }
        if (Features.Feature.EnsureUniqueUUID.isEnabled()) {
            for (String uuid : Files.tportData.getKeys("tport")) {
                for (String tportID : Files.tportData.getKeys("tport." + uuid + ".tports")) {
                    if (!tportID.equals(nextUUID.toString())) continue;
                    return TPortManager.getNextUUID();
                }
            }
        }
        return nextUUID;
    }
}

