/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.tport;

import com.spaceman.tport.Main;
import com.spaceman.tport.Pair;
import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.commands.tport.SafetyCheck;
import com.spaceman.tport.commands.tport.log.LogSize;
import com.spaceman.tport.cooldown.CooldownManager;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.MessageUtils;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.colorTheme.MultiColor;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.fancyMessage.inventories.FancyInventory;
import com.spaceman.tport.fancyMessage.inventories.InventoryModel;
import com.spaceman.tport.inventories.QuickEditInventories;
import com.spaceman.tport.playerUUID.PlayerUUID;
import com.spaceman.tport.tpEvents.TPEManager;
import com.spaceman.tport.tpEvents.TPRequest;
import com.spaceman.tport.tport.TPortManager;
import com.spaceman.tport.waypoint.WaypointManager;
import com.spaceman.tport.waypoint.WaypointModels;
import com.spaceman.tport.webMaps.BlueMapHandler;
import com.spaceman.tport.webMaps.DynmapHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.NumberConversions;

public class TPort
implements ConfigurationSerializable {
    public static final FancyInventory.DataName<String> tportNameDataName = new FancyInventory.DataName<String>("tportName", String.class, "");
    public static final FancyInventory.DataName<TPort> tportDataName = new FancyInventory.DataName<TPort>("tport", TPort.class);
    public static final FancyInventory.DataName<UUID> tportUUIDDataName = new FancyInventory.DataName<UUID>("tportUUID", UUID.class);
    private UUID tportID = null;
    private UUID owner;
    private ItemStack item;
    private Location location;
    private String name;
    private int range = 0;
    private String description = "";
    private PrivateState privateState = PrivateState.OPEN;
    private WhitelistVisibility whitelistVisibility = WhitelistVisibility.ON;
    private ArrayList<UUID> whitelist = new ArrayList();
    private int slot = -1;
    private boolean publicTPort = false;
    private UUID offeredTo = null;
    private ArrayList<LogEntry> logBook = new ArrayList();
    private HashMap<UUID, LogMode> logged = new HashMap();
    private LogMode defaultLogMode = LogMode.NONE;
    private NotifyMode notifyMode = NotifyMode.NONE;
    private PreviewState previewState = PreviewState.ON;
    private ArrayList<String> tags = new ArrayList();
    private boolean showOnDynmap = true;
    private String dynmapIconID = "";
    private boolean showOnBlueMap = true;
    private String blueMapIcon = "";
    private boolean shouldReturnItem = true;
    private boolean showWaypoint = true;
    private Pair<String, String> waypointIcon = Pair.fromNamespacedKey(WaypointModels.tport_waypoint_model.getNamespacedKey());
    private MultiColor waypointColor = new MultiColor("#ffffff");
    private boolean active;
    private String inactiveWorldName = null;
    private boolean parseAsPublic = false;

    public TPort(UUID owner, String name, Location location, ItemStack item) {
        this.owner = owner;
        this.name = name;
        this.setLocation(location);
        this.item = new ItemStack(item);
        this.active = true;
    }

    public TPort(UUID owner, String name, Location location, ItemStack item, String description) {
        this(owner, name, location, item);
        this.description = description;
    }

    public static TPort deserialize(Map<String, Object> args) {
        ArrayList log;
        World world;
        boolean active = true;
        String inactiveWorldName = null;
        String name = (String)args.get("name");
        try {
            world = Bukkit.getWorld((String)((String)args.get("world")));
            if (world == null) {
                active = false;
                inactiveWorldName = (String)args.get("world");
                if (inactiveWorldName != null) {
                    Main.getInstance().getLogger().info(String.format("World '%s' was not found, TPort '%s' is now set to %s. When using this TPort it will recheck for the world, when found it will be set to active", inactiveWorldName, name, "inactive"));
                }
            }
        }
        catch (Exception e) {
            world = (World)Bukkit.getWorlds().get(0);
            active = false;
        }
        double x = NumberConversions.toDouble((Object)args.get("x"));
        double y = NumberConversions.toDouble((Object)args.get("y"));
        double z = NumberConversions.toDouble((Object)args.get("z"));
        float yaw = NumberConversions.toFloat((Object)args.get("yaw"));
        float pitch = NumberConversions.toFloat((Object)args.get("pitch"));
        Location location = new Location(world, x, y, z, yaw, pitch);
        TPort tport = new TPort(null, name, location, (ItemStack)args.get("item"));
        tport.active = active;
        tport.inactiveWorldName = inactiveWorldName;
        tport.setSlot((Integer)args.getOrDefault("slot", -1));
        tport.setPublicTPort((Boolean)args.getOrDefault("publicTPort", false));
        tport.setPrivateState(PrivateState.get((String)args.getOrDefault("ps", PrivateState.OPEN.name()), PrivateState.OPEN));
        tport.setWhitelistVisibility(WhitelistVisibility.get((String)args.getOrDefault("whitelistVisibility", PrivateState.OPEN.name())));
        tport.setDescription((String)args.getOrDefault("description", ""));
        tport.setWhitelist(args.getOrDefault("whitelist", new ArrayList()).stream().map(UUID::fromString).collect(Collectors.toCollection(ArrayList::new)));
        tport.setRange((Integer)args.getOrDefault("range", 0));
        if (args.containsKey("offeredTo")) {
            tport.offeredTo = UUID.fromString((String)args.get("offeredTo"));
        }
        if (args.containsKey("logBook")) {
            log = new ArrayList();
            for (Pair pair : (ArrayList)args.get("logBook")) {
                Calendar c = Calendar.getInstance();
                c.setTime(new Date((Long)pair.getLeft()));
                log.add(new LogEntry(UUID.fromString((String)pair.getRight()), c, null, null));
            }
            tport.setLogBook(log);
        }
        if (args.containsKey("logBook_v2")) {
            log = (ArrayList)args.get("logBook_v2");
            tport.setLogBook(log);
        }
        if (args.containsKey("logged")) {
            HashMap oldLogged = (HashMap)args.get("logged");
            for (String uuid : oldLogged.keySet()) {
                tport.addLogged(UUID.fromString(uuid), LogMode.valueOf((String)oldLogged.get(uuid)));
            }
        }
        tport.setDefaultLogMode(LogMode.get((String)args.get("defaultLogMode")));
        tport.setNotifyMode(NotifyMode.get((String)args.get("notifyMode")));
        tport.setPreviewState(PreviewState.get((String)args.get("previewState"), PreviewState.ON));
        if (args.containsKey("tags")) {
            for (String tag : (List)args.get("tags")) {
                tport.addTag(tag);
            }
        }
        tport.showOnDynmap((Boolean)args.getOrDefault("showOnDynmap", true));
        tport.setDynmapIconID((String)args.getOrDefault("dynmapIconID", ""));
        tport.showOnBlueMap((Boolean)args.getOrDefault("showOnBlueMap", true));
        tport.setBlueMapIcon((String)args.getOrDefault("blueMapIcon", ""));
        tport.setShouldReturnItem((Boolean)args.getOrDefault("shouldReturnItem", true));
        tport.setShowWaypoint((Boolean)args.getOrDefault("showWaypoint", true));
        tport.setWaypointIcon(args.getOrDefault("waypointIcon", new Pair<String, String>("tport", "tport")));
        tport.setWaypointColor((MultiColor)args.getOrDefault("waypointColor", new MultiColor("#ffffff")));
        return tport;
    }

    @Nonnull
    public Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", this.name);
        map.put("x", this.location.getX());
        map.put("y", this.location.getY());
        map.put("z", this.location.getZ());
        if (this.inactiveWorldName == null && this.location.getWorld() != null) {
            map.put("world", this.location.getWorld().getName());
        } else {
            map.put("world", this.inactiveWorldName);
        }
        map.put("pitch", Float.valueOf(this.location.getPitch()));
        map.put("yaw", Float.valueOf(this.location.getYaw()));
        map.put("item", this.item);
        map.put("slot", this.slot);
        if (this.isOffered()) {
            map.put("offeredTo", this.offeredTo.toString());
        }
        if (this.publicTPort) {
            map.put("publicTPort", true);
        }
        if (this.privateState != PrivateState.OPEN) {
            map.put("ps", this.privateState.name());
        }
        if (this.whitelistVisibility != WhitelistVisibility.ON) {
            map.put("whitelistVisibility", this.whitelistVisibility.name());
        }
        if (!this.whitelist.isEmpty()) {
            map.put("whitelist", this.whitelist.stream().map(UUID::toString).collect(Collectors.toList()));
        }
        if (!this.description.isEmpty()) {
            map.put("description", this.description);
        }
        if (this.range != 0) {
            map.put("range", this.range);
        }
        if (!this.logBook.isEmpty()) {
            map.put("logBook_v2", this.logBook);
        }
        if (!this.logged.isEmpty()) {
            HashMap<String, String> newLogged = new HashMap<String, String>();
            for (UUID uuid : this.logged.keySet()) {
                newLogged.put(uuid.toString(), this.logged.get(uuid).name());
            }
            map.put("logged", newLogged);
        }
        if (this.defaultLogMode != LogMode.NONE) {
            map.put("defaultLogMode", this.defaultLogMode.name());
        }
        if (this.notifyMode != NotifyMode.NONE) {
            map.put("notifyMode", this.notifyMode.name());
        }
        if (this.previewState != PreviewState.ON) {
            map.put("previewState", this.previewState.name());
        }
        map.put("tags", this.tags);
        map.put("showOnDynmap", this.showOnDynmap);
        map.put("dynmapIconID", this.dynmapIconID);
        map.put("showOnBlueMap", this.showOnBlueMap);
        map.put("blueMapIcon", this.blueMapIcon);
        map.put("shouldReturnItem", this.shouldReturnItem);
        map.put("showWaypoint", this.showWaypoint);
        map.put("waypointIcon", this.waypointIcon);
        map.put("waypointColor", this.waypointColor);
        return map;
    }

    public String toString() {
        return this.getName();
    }

    public ItemStack getItem() {
        return new ItemStack(this.item);
    }

    public ItemStack setItem(ItemStack newItem) {
        ItemStack is = this.item;
        this.item = new ItemStack(newItem);
        return is;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        if (this.location != null && !Objects.equals(location.getWorld(), this.location.getWorld())) {
            WaypointManager.removeFromWorld(this, this.location.getWorld());
            try {
                BlueMapHandler.forceRemoveTPort(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.location = location;
    }

    public Biome getBiome() {
        return this.location.getBlock().getBiome();
    }

    public World getWorld() {
        return Main.getOrDefault(this.location.getWorld(), (World)Bukkit.getWorlds().get(0));
    }

    public World.Environment getDimension() {
        return Main.getOrDefault(this.location.getWorld(), (World)Bukkit.getWorlds().get(0)).getEnvironment();
    }

    public PrivateState getPrivateState() {
        return this.privateState;
    }

    public void setPrivateState(PrivateState privateState) {
        this.privateState = privateState;
    }

    public WhitelistVisibility getWhitelistVisibility() {
        return this.whitelistVisibility;
    }

    public void setWhitelistVisibility(WhitelistVisibility whitelistVisibility) {
        this.whitelistVisibility = whitelistVisibility;
    }

    public Boolean hasAccess(Player player) {
        return this.hasAccess(player.getUniqueId());
    }

    public Boolean hasAccess(UUID uuid) {
        return this.getPrivateState().hasAccess(uuid, this);
    }

    public ArrayList<UUID> getWhitelist() {
        return this.whitelist;
    }

    public void setWhitelist(ArrayList<UUID> whitelist) {
        this.whitelist = whitelist;
    }

    public boolean addWhitelist(UUID uuid) {
        if (!this.whitelist.contains(uuid)) {
            return this.whitelist.add(uuid);
        }
        return false;
    }

    public boolean removeWhitelist(UUID uuid) {
        return this.whitelist.remove(uuid);
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public boolean hasClaimedOwner() {
        return this.owner != null;
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public Message getDescription() {
        Message d = new Message();
        ArrayList<Message> listedDescription = this.getListedDescription();
        for (int i = 0; i < listedDescription.size() - 1; ++i) {
            Message m = listedDescription.get(i);
            d.addMessage(m);
            d.addNewLine();
        }
        d.addMessage(listedDescription.get(listedDescription.size() - 1));
        return d;
    }

    public ArrayList<Message> getListedDescription() {
        return MessageUtils.transformColoredTextToMessage("&9" + this.description, "#5555ff");
    }

    public String getRawDescription() {
        return this.description;
    }

    public String getTextDescription() {
        return this.getDescription().getText().stream().map(TextComponent::getText).collect(Collectors.joining());
    }

    public void setDescription(@Nullable String description) {
        if (description == null) {
            description = "";
        }
        this.description = description.replace("\n", "\\n");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int range) {
        this.range = Math.max(range, 0);
    }

    public boolean hasRange() {
        return this.range != 0;
    }

    public UUID getTportID() {
        return this.tportID;
    }

    public void setTportID(UUID tportID) {
        this.tportID = tportID;
    }

    public int getSlot() {
        return this.slot;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }

    public boolean isPublicTPort() {
        return this.publicTPort;
    }

    public boolean isOffered() {
        return this.offeredTo != null;
    }

    public UUID getOfferedTo() {
        return this.offeredTo;
    }

    public void setOfferedTo(@Nullable UUID receiver) {
        this.offeredTo = receiver;
    }

    public void clearLogBook() {
        this.logBook = new ArrayList();
    }

    public ArrayList<LogEntry> getLogBook() {
        this.logBook.sort(Comparator.comparing(logEntry -> logEntry.timeOfTeleport().getTime()));
        return this.logBook;
    }

    public void setLogBook(ArrayList<LogEntry> log) {
        this.logBook = log;
    }

    public boolean isLogBookEmpty() {
        return this.logBook.isEmpty();
    }

    public void log(UUID consumer) {
        LogMode logMode = this.getLogMode(consumer);
        if (logMode.shouldLog(consumer, this)) {
            this.logBook.add(new LogEntry(consumer, Calendar.getInstance(), logMode, Bukkit.getPlayer((UUID)this.owner) != null));
            while (this.logBook.size() > LogSize.getLogSize()) {
                this.logBook.remove(this.logBook.size() - 1);
            }
        }
    }

    public List<UUID> getLogged() {
        return new ArrayList<UUID>(this.logged.keySet());
    }

    public LogMode getLogMode(@Nullable UUID uuid) {
        if (uuid == null) {
            return LogMode.NONE;
        }
        if (uuid.equals(this.owner)) {
            return this.logged.getOrDefault(this.owner, LogMode.NONE);
        }
        return this.logged.getOrDefault(uuid, this.defaultLogMode);
    }

    public LogMode getDefaultLogMode() {
        return this.defaultLogMode;
    }

    public void setDefaultLogMode(LogMode defaultLogMode) {
        this.defaultLogMode = defaultLogMode;
    }

    public void addLogged(UUID uuid, LogMode logMode) {
        this.logged.put(uuid, logMode);
    }

    public boolean removeLogged(UUID uuid) {
        return this.logged.remove(uuid) != null;
    }

    public boolean hasLoggedPlayers() {
        return !this.logged.isEmpty();
    }

    public boolean isLogged() {
        if (this.defaultLogMode != LogMode.NONE) {
            return true;
        }
        for (UUID uuid : this.getLogged()) {
            if (this.getLogMode(uuid) == LogMode.NONE) continue;
            return true;
        }
        return false;
    }

    public boolean isShowWaypoint() {
        return this.showWaypoint;
    }

    public void setShowWaypoint(boolean showWaypoint) {
        this.showWaypoint = showWaypoint;
    }

    public MultiColor getWaypointColor() {
        return this.waypointColor;
    }

    public void setWaypointColor(MultiColor waypointColor) {
        this.waypointColor = waypointColor;
    }

    public Pair<String, String> getWaypointIcon() {
        return this.waypointIcon;
    }

    public void setWaypointIcon(Pair<String, String> waypointIcon) {
        this.waypointIcon = waypointIcon;
    }

    public boolean setPublicTPort(boolean publicTPort) {
        return this.setPublicTPort(publicTPort, null);
    }

    public boolean setPublicTPort(boolean publicTPort, @Nullable Player player) {
        boolean b = this.publicTPort != publicTPort;
        this.publicTPort = publicTPort;
        if (publicTPort) {
            if (!this.privateState.canGoPublic()) {
                this.setPrivateState(PrivateState.OPEN);
                ColorTheme.sendInfoTranslation(player, "tport.tport.tport.setPublicTPort.incompatiblePrivateState", this, this.privateState);
            }
            if (!this.previewState.canGoPublic()) {
                this.setPreviewState(PreviewState.ON);
                ColorTheme.sendInfoTranslation(player, "tport.tport.tport.setPublicTPort.incompatiblePreviewState", this, this.previewState);
            }
        }
        return b;
    }

    public boolean isActive() {
        World testWorld;
        if (!this.active && this.inactiveWorldName != null && (testWorld = Bukkit.getWorld((String)this.inactiveWorldName)) != null) {
            this.active = true;
            this.location.setWorld(testWorld);
        }
        return this.active;
    }

    public boolean shouldNotify(UUID uuid) {
        return !uuid.equals(this.owner) && this.notifyMode.shouldNotify(uuid, this);
    }

    public NotifyMode getNotifyMode() {
        return this.notifyMode;
    }

    public void setNotifyMode(NotifyMode notifyMode) {
        this.notifyMode = notifyMode;
    }

    public void notifyOwner(Player teleporter) {
        Player player;
        if (this.shouldNotify(teleporter.getUniqueId()) && (player = Bukkit.getPlayer((UUID)this.owner)) != null) {
            ColorTheme.sendInfoTranslation(player, "tport.tport.tport.notifyOwner", teleporter, this);
        }
    }

    public PreviewState getPreviewState() {
        return this.previewState;
    }

    public void setPreviewState(PreviewState previewState) {
        this.previewState = previewState;
    }

    public boolean addTag(String tag) {
        if (!this.tags.contains(tag)) {
            this.tags.add(tag);
            return true;
        }
        return false;
    }

    public boolean removeTag(String tag) {
        if (this.tags.contains(tag)) {
            this.tags.remove(tag);
            return true;
        }
        return false;
    }

    public ArrayList<String> getTags() {
        return new ArrayList<String>(this.tags);
    }

    public boolean hasTags() {
        return !this.tags.isEmpty();
    }

    public boolean showOnDynmap() {
        return this.showOnDynmap;
    }

    public void showOnDynmap(boolean state) {
        this.showOnDynmap = state;
    }

    public String getDynmapIconID() {
        return this.dynmapIconID;
    }

    public void setDynmapIconID(String dynmapIconID) {
        this.dynmapIconID = dynmapIconID;
    }

    public boolean showOnBlueMap() {
        return this.showOnBlueMap;
    }

    public void showOnBlueMap(boolean state) {
        this.showOnBlueMap = state;
    }

    public String getBlueMapIcon() {
        return this.blueMapIcon;
    }

    public void setBlueMapIcon(String icon) {
        this.blueMapIcon = icon;
    }

    public boolean shouldReturnItem() {
        return this.shouldReturnItem;
    }

    public void setShouldReturnItem(boolean shouldReturnItem) {
        this.shouldReturnItem = shouldReturnItem;
    }

    public TPort parseAsPublic(boolean parseAsPublic) {
        this.parseAsPublic = parseAsPublic;
        return this;
    }

    public boolean parseAsPublic() {
        return this.parseAsPublic;
    }

    public void save() {
        TPortManager.saveTPort(this);
        DynmapHandler.updateTPort(this);
        try {
            BlueMapHandler.updateTPort(this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        WaypointManager.updateTPort(this);
    }

    public void setInactiveWorldName(String inactiveWorldName) {
        this.inactiveWorldName = inactiveWorldName;
    }

    public boolean canTeleport(Player player, boolean sendError, boolean askConsent, boolean safetyCheck) {
        if (!this.isActive()) {
            if (sendError) {
                ColorTheme.sendErrorTranslation(player, "tport.tport.tport.canTeleport.notActive", this);
            }
            return false;
        }
        if (this.getLocation() == null) {
            if (sendError) {
                ColorTheme.sendErrorTranslation(player, "tport.tport.tport.canTeleport.worldNotFound", new Object[0]);
            }
            return false;
        }
        if (safetyCheck && !SafetyCheck.isSafe(this.getLocation())) {
            if (sendError) {
                ColorTheme.sendErrorTranslation(player, "tport.tport.tport.canTeleport.safetyCheck", this);
            }
            return false;
        }
        if (!this.owner.equals(player.getUniqueId())) {
            Boolean access = this.getPrivateState().hasAccess(player, this);
            if (access == null && askConsent) {
                Player ownerPlayer = Bukkit.getPlayer((UUID)this.owner);
                if (ownerPlayer == null) {
                    return false;
                }
                if (TPRequest.hasRequest(player, true)) {
                    return false;
                }
                TPRequest.createTPortRequest(player.getUniqueId(), this, safetyCheck);
                Message accept = ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.requests.here", new Object[0]);
                accept.addTextEvent(ClickEvent.runCommand("/tport requests accept " + player.getName()));
                accept.addTextEvent(new HoverEvent(TextComponent.textComponent("/tport requests accept " + player.getName(), ColorTheme.ColorType.infoColor)));
                Message reject = ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.requests.here", new Object[0]);
                reject.addTextEvent(ClickEvent.runCommand("/tport requests reject " + player.getName()));
                reject.addTextEvent(new HoverEvent(TextComponent.textComponent("/tport requests reject " + player.getName(), ColorTheme.ColorType.infoColor)));
                Message revoke = ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.requests.here", new Object[0]);
                revoke.addTextEvent(ClickEvent.runCommand("/tport requests revoke"));
                revoke.addTextEvent(new HoverEvent(TextComponent.textComponent("/tport requests revoke", ColorTheme.ColorType.infoColor)));
                ColorTheme.sendInfoTranslation(ownerPlayer, "tport.tport.tport.consent.consent.askConsent", player, this, accept, reject);
                ColorTheme.sendInfoTranslation(player, "tport.tport.tport.consent.consent.consentAsked", ownerPlayer, this, this.getPrivateState(), revoke);
                return false;
            }
            if (access != null && !access.booleanValue()) {
                if (sendError) {
                    this.getPrivateState().sendErrorMessage(player, this);
                }
                return false;
            }
            if (this.hasRange()) {
                Player ownerPlayer = Bukkit.getPlayer((UUID)this.owner);
                if (ownerPlayer == null) {
                    if (sendError) {
                        ColorTheme.sendErrorTranslation(player, "tport.tport.tport.canTeleport.ownerOutOfRange", PlayerUUID.getPlayerName(this.owner), this);
                    }
                    return false;
                }
                Location location = ownerPlayer.getLocation();
                if (!Objects.equals(location.getWorld(), this.getLocation().getWorld()) || location.distance(this.getLocation()) > (double)this.getRange()) {
                    if (sendError) {
                        ColorTheme.sendErrorTranslation(player, "tport.tport.tport.canTeleport.ownerOutOfRange", ownerPlayer, this);
                    }
                    return false;
                }
            }
        }
        return true;
    }

    public boolean teleport(Player player, boolean safetyCheck) {
        return this.teleport(player, safetyCheck, true, null, null, null);
    }

    public boolean teleport(Player player, boolean safetyCheck, @Nullable TPortAdvancement advancement) {
        return this.teleport(player, safetyCheck, true, advancement, null, null);
    }

    public boolean teleport(Player player, boolean safetyCheck, boolean askConsent, @Nullable TPortAdvancement advancement, @Nullable String successMessage, @Nullable String requestMessage) {
        if (!CooldownManager.TPortTP.hasCooled(player, true)) {
            return false;
        }
        if (!this.canTeleport(player, true, askConsent, safetyCheck)) {
            return false;
        }
        player.closeInventory();
        TPEManager.tpPlayerToTPort(player, this, () -> {
            TPort lambdaTPort = TPortManager.getTPort(this.getOwner(), this.getTportID());
            ColorTheme.sendSuccessTranslation(player, successMessage == null ? "tport.tport.tport.teleport.succeeded" : successMessage, TPortEncapsulation.asTPort(lambdaTPort, this.getName()));
            if (advancement != null) {
                advancement.grant(player);
            }
            if (lambdaTPort != null) {
                lambdaTPort.notifyOwner(player);
                lambdaTPort.log(player.getUniqueId());
                lambdaTPort.save();
            }
        }, (p, delay, tickMessage, seconds, secondMessage) -> ColorTheme.sendSuccessTranslation(p, requestMessage == null ? "tport.tport.tport.teleport.tpRequested" : requestMessage, this, delay, tickMessage, seconds, secondMessage));
        CooldownManager.TPortTP.update(player);
        return true;
    }

    public List<Message> getHoverData(boolean addOwner) {
        ArrayList<Message> hoverData = new ArrayList<Message>(15);
        if (addOwner) {
            hoverData.add(ColorTheme.formatInfoTranslation("tport.tport.tport.hoverData.tportOwner", PlayerUUID.getPlayerName(this.getOwner())));
            hoverData.add(new Message());
        }
        if (this.hasDescription()) {
            hoverData.addAll(this.getListedDescription());
            hoverData.add(new Message());
        }
        hoverData.add(ColorTheme.formatInfoTranslation("tport.tport.tport.hoverData.privateState", this.getPrivateState().getDisplayName()));
        hoverData.add(ColorTheme.formatInfoTranslation("tport.tport.tport.hoverData.previewState", this.getPreviewState().getDisplayName()));
        if (this.getPrivateState().usesWhitelist() && this.getWhitelistVisibility() == WhitelistVisibility.ON) {
            Message whitelistMessage = new Message();
            for (int i = 0; i < this.getWhitelist().size(); ++i) {
                if (i == 3) {
                    whitelistMessage.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.infoColor, ColorTheme.ColorType.infoColor, "tport.tport.tport.hoverData.whitelist.shorten", new Object[0]));
                    whitelistMessage.addWhiteSpace();
                    break;
                }
                UUID uuid = this.getWhitelist().get(i);
                whitelistMessage.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfoColor, "tport.tport.tport.hoverData.whitelist.element", PlayerUUID.getPlayerName(uuid)));
                whitelistMessage.addMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.infoColor, ColorTheme.ColorType.infoColor, "tport.tport.tport.hoverData.whitelist.delimiter", new Object[0]));
            }
            whitelistMessage.removeLast();
            if (whitelistMessage.getText().isEmpty()) {
                hoverData.add(ColorTheme.formatInfoTranslation("tport.tport.tport.hoverData.whitelist.list", ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfoColor, "tport.tport.tport.hoverData.whitelist.empty", new Object[0])));
            } else {
                hoverData.add(ColorTheme.formatInfoTranslation("tport.tport.tport.hoverData.whitelist.list", whitelistMessage));
            }
        }
        if (this.hasRange()) {
            hoverData.add(ColorTheme.formatInfoTranslation("tport.tport.tport.hoverData.range", this.getRange()));
        }
        if (Features.Feature.PublicTP.isEnabled()) {
            hoverData.add(ColorTheme.formatInfoTranslation("tport.tport.tport.hoverData.publicTPort", this.isPublicTPort()));
        }
        hoverData.add(ColorTheme.formatInfoTranslation("tport.tport.tport.hoverData.defaultLogMode", this.getDefaultLogMode()));
        hoverData.add(ColorTheme.formatInfoTranslation("tport.tport.tport.hoverData.notifyMode", this.getNotifyMode()));
        if (DynmapHandler.isEnabled()) {
            hoverData.add(ColorTheme.formatInfoTranslation("tport.tport.tport.hoverData.dynmapShow", this.showOnDynmap()));
            hoverData.add(ColorTheme.formatInfoTranslation("tport.tport.tport.hoverData.dynmapIcon", DynmapHandler.getTPortIconName(this)));
        }
        if (this.hasTags()) {
            Message tagsMessage = new Message();
            boolean color = true;
            for (String tag : this.getTags()) {
                tagsMessage.addText(TextComponent.textComponent(tag, color ? ColorTheme.ColorType.varInfoColor : ColorTheme.ColorType.varInfo2Color));
                tagsMessage.addText(TextComponent.textComponent(", ", ColorTheme.ColorType.infoColor));
                color = !color;
            }
            tagsMessage.removeLast();
            if (this.getTags().size() == 1) {
                hoverData.add(ColorTheme.formatInfoTranslation("tport.tport.tport.hoverData.tag", tagsMessage));
            } else {
                hoverData.add(ColorTheme.formatInfoTranslation("tport.tport.tport.hoverData.tags", tagsMessage));
            }
        }
        if (this.isOffered()) {
            hoverData.add(new Message());
            hoverData.add(ColorTheme.formatInfoTranslation("tport.tport.tport.hoverData.isOffered", PlayerUUID.getPlayerName(this.getOfferedTo())));
        }
        return hoverData;
    }

    public static enum PrivateState implements MessageUtils.MessageDescription
    {
        OPEN(new TextComponent("open", ChatColor.RED), true, false, QuickEditInventories.quick_edit_private_open_model, (player, tport) -> true),
        PRIVATE(new TextComponent("private", ChatColor.GREEN), false, true, QuickEditInventories.quick_edit_private_private_model, (player, tport) -> tport.getWhitelist().contains(player)),
        ONLINE(new TextComponent("online", ChatColor.YELLOW), true, true, QuickEditInventories.quick_edit_private_online_model, (player, tport) -> Bukkit.getPlayer((UUID)tport.getOwner()) != null || PRIVATE.hasAccess(player, tport) != false),
        PRIVATE_ONLINE(new TextComponent("private online", ChatColor.GOLD), false, true, QuickEditInventories.quick_edit_private_private_online_model, (player, tport) -> Bukkit.getPlayer((UUID)tport.getOwner()) != null && PRIVATE.hasAccess(player, tport) != false),
        CONSENT_PRIVATE(new TextComponent("consent private", ChatColor.DARK_AQUA), false, true, QuickEditInventories.quick_edit_private_consent_private_model, (player, tport) -> Bukkit.getPlayer((UUID)tport.getOwner()) != null ? null : PRIVATE.hasAccess(player, tport)),
        CONSENT_CLOSE(new TextComponent("consent close", ChatColor.BLUE), false, true, QuickEditInventories.quick_edit_private_consent_close_model, (player, tport) -> Bukkit.getPlayer((UUID)tport.getOwner()) != null && tport.getWhitelist().contains(player) ? null : Boolean.valueOf(false));

        private final AccessTester tester;
        private final TextComponent displayName;
        private final boolean canGoPublic;
        private final boolean usesWhitelist;
        private final InventoryModel inventoryModel;

        private PrivateState(TextComponent displayName, boolean canGoPublic, boolean usesWhitelist, InventoryModel inventoryModel, AccessTester tester) {
            this.displayName = displayName;
            this.canGoPublic = canGoPublic;
            this.tester = tester;
            this.inventoryModel = inventoryModel;
            this.usesWhitelist = usesWhitelist;
        }

        @Nonnull
        public static PrivateState get(@Nullable String name, PrivateState def) {
            if (name == null) {
                return def;
            }
            if (name.equalsIgnoreCase("prion")) {
                return PRIVATE_ONLINE;
            }
            try {
                return PrivateState.valueOf(name.toUpperCase());
            }
            catch (IllegalArgumentException | NullPointerException iae) {
                if (name.equalsIgnoreCase("on")) {
                    return PRIVATE;
                }
                if (name.equalsIgnoreCase("off")) {
                    return OPEN;
                }
                return def;
            }
        }

        public InventoryModel getInventoryModel() {
            return this.inventoryModel;
        }

        public boolean canGoPublic() {
            return this.canGoPublic;
        }

        public boolean usesWhitelist() {
            return this.usesWhitelist;
        }

        public PrivateState getNext() {
            boolean next = false;
            for (PrivateState state : PrivateState.values()) {
                if (state.equals(this)) {
                    next = true;
                    continue;
                }
                if (!next) continue;
                return state;
            }
            return Arrays.asList(PrivateState.values()).get(0);
        }

        public void sendErrorMessage(Player player, TPort tport) {
            ColorTheme.sendErrorTranslation(player, "tport.tport.tport.privateState." + this.name() + ".errorMessage", PlayerEncapsulation.asPlayer(tport.getOwner()), this, tport);
        }

        public TextComponent getDisplayName() {
            return new TextComponent(this.displayName.getText(), this.displayName.getColor());
        }

        @Override
        public Message getDescription() {
            return ColorTheme.formatInfoTranslation("tport.tport.tport.privateState." + this.name() + ".description", this.getDisplayName());
        }

        @Override
        public Message getName(String ignore_color, String ignore_varColor) {
            return new Message(this.getDisplayName());
        }

        @Override
        public String getInsertion() {
            return this.name();
        }

        public Boolean hasAccess(Player player, TPort tport) {
            return this.hasAccess(player.getUniqueId(), tport);
        }

        public Boolean hasAccess(UUID uuid, TPort tport) {
            if (uuid.equals(tport.getOwner())) {
                return true;
            }
            return this.tester.hasAccess(uuid, tport);
        }

        @FunctionalInterface
        private static interface AccessTester {
            public Boolean hasAccess(UUID var1, TPort var2);
        }
    }

    public static enum WhitelistVisibility implements MessageUtils.MessageDescription
    {
        ON(new TextComponent("on", ChatColor.GREEN), QuickEditInventories.quick_edit_whitelist_visibility_on_model),
        OFF(new TextComponent("off", ChatColor.RED), QuickEditInventories.quick_edit_whitelist_visibility_off_model);

        private final TextComponent displayName;
        private final InventoryModel model;

        private WhitelistVisibility(TextComponent displayName, InventoryModel model) {
            this.displayName = displayName;
            this.model = model;
        }

        public InventoryModel getModel() {
            return this.model;
        }

        public static WhitelistVisibility get(@Nullable String name) {
            try {
                return WhitelistVisibility.valueOf(name != null ? name.toUpperCase() : ON.name());
            }
            catch (IllegalArgumentException | NullPointerException iae) {
                return ON;
            }
        }

        public WhitelistVisibility getNext() {
            if (this == ON) {
                return OFF;
            }
            return ON;
        }

        public TextComponent getDisplayName() {
            return new TextComponent(this.displayName.getText(), this.displayName.getColor());
        }

        @Override
        public Message getDescription() {
            return ColorTheme.formatInfoTranslation("tport.tport.tport.whitelistVisibility." + this.name() + ".description", this.getDisplayName());
        }

        @Override
        public Message getName(String ignore_color, String ignore_varColor) {
            return new Message(this.getDisplayName());
        }

        @Override
        public String getInsertion() {
            return this.name();
        }
    }

    public static enum LogMode implements MessageUtils.MessageDescription
    {
        ONLINE((uuid, tport) -> Bukkit.getPlayer((UUID)tport.getOwner()) != null, QuickEditInventories.quick_edit_log_mode_online_model),
        OFFLINE((uuid, tport) -> Bukkit.getPlayer((UUID)tport.getOwner()) == null, QuickEditInventories.quick_edit_log_mode_offline_model),
        ALL((uuid, tport) -> true, QuickEditInventories.quick_edit_log_mode_all_model),
        NONE((uuid, tport) -> false, QuickEditInventories.quick_edit_log_mode_none_model);

        private final LogTester tester;
        private final InventoryModel model;

        private LogMode(LogTester tester, InventoryModel model) {
            this.tester = tester;
            this.model = model;
        }

        public static LogMode get(@Nullable String name) {
            return LogMode.get(name, NONE);
        }

        public static LogMode get(@Nullable String name, LogMode def) {
            for (LogMode mode : LogMode.values()) {
                if (!mode.name().equalsIgnoreCase(name)) continue;
                return mode;
            }
            return def;
        }

        public boolean shouldLog(UUID uuid, TPort tport) {
            return this.tester.shouldLog(uuid, tport);
        }

        public LogMode getNext() {
            boolean next = false;
            for (LogMode state : LogMode.values()) {
                if (state.equals(this)) {
                    next = true;
                    continue;
                }
                if (!next) continue;
                return state;
            }
            return Arrays.asList(LogMode.values()).get(0);
        }

        public InventoryModel getModel() {
            return this.model;
        }

        @Override
        public Message getDescription() {
            return ColorTheme.formatInfoTranslation("tport.tport.tport.logMode." + this.name() + ".description", this.name());
        }

        @Override
        public Message getName(String color, String varColor) {
            return new Message(new TextComponent(this.name(), varColor));
        }

        @Override
        public String getInsertion() {
            return this.name();
        }

        @FunctionalInterface
        private static interface LogTester {
            public boolean shouldLog(UUID var1, TPort var2);
        }
    }

    public static enum NotifyMode implements MessageUtils.MessageDescription
    {
        ONLINE(new TextComponent("online", ChatColor.GREEN), QuickEditInventories.quick_edit_notify_online_model, (uuid, tport) -> Bukkit.getPlayer((UUID)tport.getOwner()) != null),
        LOG(new TextComponent("log", ChatColor.YELLOW), QuickEditInventories.quick_edit_notify_log_model, (uuid, tport) -> tport.getLogMode(uuid).shouldLog(uuid, tport)),
        NONE(new TextComponent("none", ChatColor.RED), QuickEditInventories.quick_edit_notify_none_model, (uuid, tport) -> false);

        private final NotifyTester tester;
        private final TextComponent displayName;
        private final InventoryModel model;

        private NotifyMode(TextComponent displayName, InventoryModel model, NotifyTester tester) {
            this.displayName = displayName;
            this.model = model;
            this.tester = tester;
        }

        public InventoryModel getModel() {
            return this.model;
        }

        public static NotifyMode get(@Nullable String name) {
            return NotifyMode.get(name, NONE);
        }

        public static NotifyMode get(@Nullable String name, NotifyMode def) {
            for (NotifyMode mode : NotifyMode.values()) {
                if (!mode.name().equalsIgnoreCase(name)) continue;
                return mode;
            }
            return def;
        }

        public boolean shouldNotify(UUID uuid, TPort tport) {
            return this.tester.shouldNotify(uuid, tport);
        }

        public TextComponent getDisplayName() {
            return new TextComponent(this.displayName.getText(), this.displayName.getColor());
        }

        @Override
        public Message getDescription() {
            return ColorTheme.formatInfoTranslation("tport.tport.tport.notifyMode." + this.name() + ".description", this.getDisplayName());
        }

        @Override
        public Message getName(String ignore_color, String ignore_varColor) {
            return new Message(this.getDisplayName());
        }

        @Override
        public String getInsertion() {
            return this.name();
        }

        public NotifyMode getNext() {
            boolean next = false;
            for (NotifyMode mode : NotifyMode.values()) {
                if (mode.equals(this)) {
                    next = true;
                    continue;
                }
                if (!next) continue;
                return mode;
            }
            return Arrays.asList(NotifyMode.values()).get(0);
        }

        @FunctionalInterface
        private static interface NotifyTester {
            public boolean shouldNotify(UUID var1, TPort var2);
        }
    }

    public static enum PreviewState implements MessageUtils.MessageDescription
    {
        ON(new TextComponent("on", ChatColor.GREEN), QuickEditInventories.quick_edit_preview_on_model, true),
        OFF(new TextComponent("off", ChatColor.RED), QuickEditInventories.quick_edit_preview_off_model, false),
        NOTIFIED(new TextComponent("notified", ChatColor.YELLOW), QuickEditInventories.quick_edit_preview_notified_model, true);

        private final boolean canGoPublic;
        private final TextComponent displayName;
        private final InventoryModel model;

        private PreviewState(TextComponent displayName, InventoryModel model, boolean canGoPublic) {
            this.displayName = displayName;
            this.model = model;
            this.canGoPublic = canGoPublic;
        }

        public InventoryModel getModel() {
            if (Features.Feature.Preview.isDisabled()) {
                return QuickEditInventories.quick_edit_preview_grayed_model;
            }
            return this.model;
        }

        public boolean canGoPublic() {
            return this.canGoPublic;
        }

        @Nullable
        public static PreviewState get(@Nullable String name, PreviewState def) {
            try {
                return PreviewState.valueOf(name != null ? name.toUpperCase() : ON.name());
            }
            catch (IllegalArgumentException | NullPointerException iae) {
                return def;
            }
        }

        public PreviewState getNext() {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> OFF;
                case 1 -> NOTIFIED;
                case 2 -> ON;
            };
        }

        public TextComponent getDisplayName() {
            return new TextComponent(this.displayName.getText(), this.displayName.getColor());
        }

        @Override
        public Message getDescription() {
            return ColorTheme.formatInfoTranslation("tport.tport.tport.previewState." + this.name() + ".description", this.getDisplayName());
        }

        @Override
        public Message getName(String ignore_color, String ignore_varColor) {
            return new Message(this.getDisplayName());
        }

        @Override
        public String getInsertion() {
            return this.name();
        }
    }

    public record LogEntry(UUID teleportedUUID, Calendar timeOfTeleport, LogMode loggedMode, Boolean ownerOnline) implements ConfigurationSerializable
    {
        public static LogEntry deserialize(Map<String, Object> args) {
            UUID teleportedUUID = UUID.fromString((String)args.get("teleportedUUID"));
            Calendar timeOfTeleport = Calendar.getInstance();
            timeOfTeleport.setTime(new Date((Long)args.get("timeOfTeleport")));
            String loggedModeName = args.getOrDefault("loggedMode", null);
            LogMode loggedMode = loggedModeName == null ? null : LogMode.get(loggedModeName);
            Boolean ownerOnline = args.getOrDefault("ownerOnline", null);
            return new LogEntry(teleportedUUID, timeOfTeleport, loggedMode, ownerOnline);
        }

        @Nonnull
        public Map<String, Object> serialize() {
            return Main.asMap(new Pair<String, String>("teleportedUUID", this.teleportedUUID.toString()), new Pair<String, Long>("timeOfTeleport", this.timeOfTeleport.getTime().getTime()), this.loggedMode == null ? null : new Pair<String, String>("loggedMode", this.loggedMode.name()), this.ownerOnline == null ? null : new Pair<String, Boolean>("ownerOnline", this.ownerOnline));
        }
    }
}

