/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.tpEvents.animations;

import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.keyValueHelper.ExtendedKey;
import com.spaceman.tport.keyValueHelper.KeyValueError;
import com.spaceman.tport.keyValueHelper.KeyValueHelper;
import com.spaceman.tport.keyValueHelper.KeyValueTabArgument;
import com.spaceman.tport.tpEvents.ParticleAnimation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class ExplosionAnimation
extends ParticleAnimation {
    private Particle particle = Particle.FLAME;
    private double radius = 5.0;
    private double resolution = 50.0;
    private boolean explosion = true;
    private double velocity = 0.25;

    @Override
    public String getAnimationName() {
        return "ExplosionAnimation";
    }

    public void setExplosion(boolean explosion) {
        this.explosion = explosion;
    }

    public void setParticle(Particle particle) {
        this.particle = particle;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public void setResolution(double resolution) {
        this.resolution = resolution;
    }

    public void setVelocity(double velocity) {
        this.velocity = velocity;
    }

    @Override
    public void show(Player player, Location location) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        location = location.add(0.0, 1.0, 0.0);
        double two_pi = Math.PI * 2;
        double increment = two_pi / this.resolution;
        for (double phi = 0.0; phi < Math.PI; phi += increment) {
            double sinPhi = Math.sin(phi);
            double cosPhi = Math.cos(phi);
            for (double theta = 0.0; theta < two_pi; theta += increment) {
                double xOffset = Math.cos(theta);
                double zOffset = Math.sin(theta);
                try {
                    if (this.explosion) {
                        world.spawnParticle(this.particle, location.getX(), location.getY(), location.getZ(), 0, (double)((float)xOffset) * sinPhi, (double)((float)cosPhi), (double)((float)zOffset) * sinPhi, this.velocity);
                        continue;
                    }
                    world.spawnParticle(this.particle, location.getX() + xOffset * sinPhi * this.radius, location.getY() + cosPhi * this.radius, location.getZ() + zOffset * sinPhi * this.radius, 0, (double)((float)(-xOffset)) * sinPhi, (double)((float)(-Math.cos(phi))), (double)((float)(-zOffset)) * sinPhi, this.velocity);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public boolean edit(Player player, String[] data) {
        try {
            KeyValueHelper.extendedConstructObject(data[0], (Object)this, (ExtendedKey)new ExtendedKey("particle", s -> Particle.valueOf((String)s.toUpperCase()), true, (o, value) -> ((ExplosionAnimation)o).setParticle((Particle)value)).setErrorMessageID("tport.tpEvents.animations.explosionAnimation.notAParticle"), (ExtendedKey)new ExtendedKey("explosion", Boolean::parseBoolean, true, (o, value) -> ((ExplosionAnimation)o).setExplosion((Boolean)value)).setErrorMessageID("tport.tpEvents.animations.explosionAnimation.notAState"), (ExtendedKey)new ExtendedKey("radius", Double::parseDouble, true, (o, value) -> ((ExplosionAnimation)o).setRadius((Double)value)).setErrorMessageID("tport.tpEvents.animations.explosionAnimation.notANumber"), (ExtendedKey)new ExtendedKey("velocity", Double::parseDouble, true, (o, value) -> ((ExplosionAnimation)o).setVelocity((Double)value)).setErrorMessageID("tport.tpEvents.animations.explosionAnimation.notANumber"), (ExtendedKey)new ExtendedKey("resolution", Double::parseDouble, true, (o, value) -> ((ExplosionAnimation)o).setResolution((Double)value)).setErrorMessageID("tport.tpEvents.animations.explosionAnimation.notANumber"));
            return true;
        }
        catch (KeyValueError keyValueError) {
            keyValueError.sendMessage(player);
            return false;
        }
    }

    @Override
    public void save(ConfigurationSection section) {
        section.set("p", (Object)this.particle.name());
        section.set("e", (Object)this.explosion);
        section.set("ra", (Object)this.radius);
        section.set("re", (Object)this.resolution);
        section.set("v", (Object)this.velocity);
    }

    @Override
    public void load(ConfigurationSection section) {
        this.particle = Particle.valueOf((String)section.getString("p", this.getDefaultParticle().name()).toUpperCase());
        this.explosion = section.getBoolean("e", true);
        this.radius = section.getDouble("ra", 5.0);
        this.resolution = section.getDouble("re", 50.0);
        this.velocity = section.getDouble("v", 0.3);
    }

    @Override
    public List<String> tabList(Player player, String[] args) {
        return KeyValueHelper.constructTab(args[args.length - 1], Arrays.asList(new KeyValueTabArgument("particle", Arrays.stream(Particle.values()).map(Enum::name).collect(Collectors.toList())), new KeyValueTabArgument("explosion", Arrays.asList("true", "false")), new KeyValueTabArgument("radius", Collections.singletonList("<X>")), new KeyValueTabArgument("velocity", Collections.singletonList("<X>")), new KeyValueTabArgument("resolution", Collections.singletonList("<X>"))));
    }

    @Override
    public Message getDescription() {
        return ColorTheme.formatInfoTranslation("tport.tpEvents.animations.explosionAnimation.description", "explosion");
    }
}

