/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.tpEvents;

import com.spaceman.tport.commands.tport.pltp.TP;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.Encapsulation;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class TPRequest {
    private static final HashMap<UUID, TPRequest> requests = new HashMap();
    private final UUID requesterUUID;
    private final boolean safetyCheck;
    private final UUID requestToUUID;
    private final UUID tportUUID;

    private TPRequest(UUID requesterUUID, UUID requestToUUID, boolean safetyCheck) {
        this.requesterUUID = requesterUUID;
        this.requestToUUID = requestToUUID;
        this.tportUUID = null;
        this.safetyCheck = safetyCheck;
    }

    private TPRequest(UUID requesterUUID, UUID tportOwner, UUID tportUUID, boolean safetyCheck) {
        this.requesterUUID = requesterUUID;
        this.requestToUUID = tportOwner;
        this.tportUUID = tportUUID;
        this.safetyCheck = safetyCheck;
    }

    public static TPRequest createPLTPRequest(UUID requester, UUID requestTo, boolean safetyCheck) {
        TPRequest request = new TPRequest(requester, requestTo, safetyCheck);
        requests.put(requester, request);
        return request;
    }

    public static TPRequest createTPortRequest(UUID requester, TPort tport, boolean safetyCheck) {
        return TPRequest.createTPortRequest(requester, tport.getOwner(), tport.getTportID(), safetyCheck);
    }

    public static TPRequest createTPortRequest(UUID requester, UUID tportOwner, UUID tportUUID, boolean safetyCheck) {
        TPRequest request = new TPRequest(requester, tportOwner, tportUUID, safetyCheck);
        requests.put(requester, request);
        return request;
    }

    public UUID getRequesterUUID() {
        return this.requesterUUID;
    }

    public UUID getRequestToUUID() {
        return this.requestToUUID;
    }

    public boolean isPLTPRequest() {
        return this.tportUUID == null;
    }

    public boolean isTPortRequest() {
        return this.tportUUID != null;
    }

    @Nullable
    public UUID getTPortUUID() {
        return this.tportUUID;
    }

    public void acceptRequest() {
        requests.remove(this.requesterUUID);
        Player requester = Bukkit.getPlayer((UUID)this.requesterUUID);
        Player requestTo = Bukkit.getPlayer((UUID)this.requestToUUID);
        if (this.isTPortRequest()) {
            TPort tport = TPortManager.getTPort(this.requestToUUID, this.tportUUID);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(requester, "tport.tpEvents.TPRequest.accept.tport.tportNotFound", new Object[0]);
                return;
            }
            ColorTheme.sendSuccessTranslation(requestTo, "tport.tpEvents.TPRequest.accept.tport.requestTo", PlayerEncapsulation.asPlayer(requester, this.requesterUUID), TPortEncapsulation.asTPort(tport));
            ColorTheme.sendInfoTranslation(requester, "tport.tpEvents.TPRequest.accept.tport.requester", PlayerEncapsulation.asPlayer(requestTo, this.requestToUUID), TPortEncapsulation.asTPort(tport));
            if (!tport.teleport(requester, this.safetyCheck, false, null, null, null)) {
                ColorTheme.sendErrorTranslation(requestTo, "tport.tpEvents.TPRequest.accept.tport.couldNotTP", PlayerEncapsulation.asPlayer(requester, this.requesterUUID));
            }
        } else {
            ColorTheme.sendSuccessTranslation(requestTo, "tport.tpEvents.TPRequest.accept.pltp.requestTo", PlayerEncapsulation.asPlayer(requester, this.requesterUUID));
            ColorTheme.sendInfoTranslation(requester, "tport.tpEvents.TPRequest.accept.pltp.requester", PlayerEncapsulation.asPlayer(requestTo, this.requestToUUID));
            TP.tp(requester, requestTo, this.safetyCheck, true);
        }
    }

    public void rejectRequest() {
        requests.remove(this.requesterUUID);
        Player requester = Bukkit.getPlayer((UUID)this.requesterUUID);
        Player requestTo = Bukkit.getPlayer((UUID)this.requestToUUID);
        if (this.isTPortRequest()) {
            ColorTheme.sendSuccessTranslation(requestTo, "tport.tpEvents.TPRequest.reject.tport.requestTo", PlayerEncapsulation.asPlayer(requester, this.requesterUUID), TPortEncapsulation.asTPort(this.tportUUID, this.requestToUUID));
            ColorTheme.sendInfoTranslation(requester, "tport.tpEvents.TPRequest.reject.tport.requester", PlayerEncapsulation.asPlayer(requestTo, this.requestToUUID), TPortEncapsulation.asTPort(this.tportUUID, this.requestToUUID));
        } else {
            ColorTheme.sendSuccessTranslation(requestTo, "tport.tpEvents.TPRequest.reject.pltp.requestTo", PlayerEncapsulation.asPlayer(requester, this.requesterUUID));
            ColorTheme.sendInfoTranslation(requester, "tport.tpEvents.TPRequest.reject.pltp.requester", PlayerEncapsulation.asPlayer(requestTo, this.requestToUUID));
        }
    }

    public void revokeRequest() {
        requests.remove(this.requesterUUID);
        Player requester = Bukkit.getPlayer((UUID)this.requesterUUID);
        Player requestTo = Bukkit.getPlayer((UUID)this.requestToUUID);
        if (this.isTPortRequest()) {
            ColorTheme.sendSuccessTranslation(requestTo, "tport.tpEvents.TPRequest.revoke.tport.requestTo", PlayerEncapsulation.asPlayer(requester, this.requesterUUID), TPortEncapsulation.asTPort(this.tportUUID, this.requestToUUID));
            ColorTheme.sendInfoTranslation(requester, "tport.tpEvents.TPRequest.revoke.tport.requester", PlayerEncapsulation.asPlayer(requestTo, this.requestToUUID), TPortEncapsulation.asTPort(this.tportUUID, this.requestToUUID));
        } else {
            ColorTheme.sendSuccessTranslation(requestTo, "tport.tpEvents.TPRequest.revoke.pltp.requestTo", PlayerEncapsulation.asPlayer(requester, this.requesterUUID));
            ColorTheme.sendInfoTranslation(requester, "tport.tpEvents.TPRequest.revoke.pltp.requester", PlayerEncapsulation.asPlayer(requestTo, this.requestToUUID));
        }
    }

    public static boolean hasRequest(Player player, boolean sendError) {
        TPRequest request = TPRequest.getRequest(player.getUniqueId());
        if (request == null) {
            return false;
        }
        if (sendError) {
            Message revoke = ColorTheme.formatTranslation(ColorTheme.ColorType.varErrorColor, ColorTheme.ColorType.varError2Color, "tport.command.requests.here", new Object[0]);
            revoke.getText().forEach(t -> t.addTextEvent(ClickEvent.runCommand("/tport requests revoke")).addTextEvent(new HoverEvent(TextComponent.textComponent("/tport requests revoke", ColorTheme.ColorType.infoColor))));
            ColorTheme.sendErrorTranslation(player, "tport.tpEvents.TPRequest.hasRequest.error", revoke, request.toError());
        }
        return true;
    }

    public static TPRequest getRequest(UUID uuid) {
        return requests.get(uuid);
    }

    public static ArrayList<TPRequest> getRequestsToYou(UUID uuid) {
        ArrayList<TPRequest> list = new ArrayList<TPRequest>();
        for (Map.Entry<UUID, TPRequest> entry : requests.entrySet()) {
            if (!entry.getValue().getRequestToUUID().equals(uuid)) continue;
            list.add(entry.getValue());
        }
        return list;
    }

    public static void playerLeft(Player player) {
        for (Map.Entry<UUID, TPRequest> entry : requests.entrySet()) {
            UUID requesterUUID = entry.getKey();
            TPRequest request = entry.getValue();
            if (requesterUUID.equals(player.getUniqueId())) {
                requests.remove(requesterUUID);
                Player requestTo = Bukkit.getPlayer((UUID)request.getRequestToUUID());
                if (request.isTPortRequest()) {
                    ColorTheme.sendInfoTranslation(requestTo, "tport.tpEvents.TPRequest.requesterLeft.tport", PlayerEncapsulation.asPlayer(player, player.getUniqueId()), TPortEncapsulation.asTPort(request.tportUUID, request.requestToUUID));
                    continue;
                }
                ColorTheme.sendInfoTranslation(requestTo, "tport.tpEvents.TPRequest.requesterLeft.pltp", PlayerEncapsulation.asPlayer(player, player.getUniqueId()));
                continue;
            }
            if (!request.getRequestToUUID().equals(player.getUniqueId())) continue;
            requests.remove(requesterUUID);
            Player requester = Bukkit.getPlayer((UUID)requesterUUID);
            if (request.isTPortRequest()) {
                ColorTheme.sendInfoTranslation(requester, "tport.tpEvents.TPRequest.requestToLeft.tport", TPortEncapsulation.asTPort(request.tportUUID, request.requestToUUID), PlayerEncapsulation.asPlayer(player, player.getUniqueId()));
                continue;
            }
            ColorTheme.sendInfoTranslation(requester, "tport.tpEvents.TPRequest.requestToLeft.pltp", PlayerEncapsulation.asPlayer(player, player.getUniqueId()));
        }
    }

    public static void tportRemoved(TPort tport) {
        for (Map.Entry<UUID, TPRequest> entry : requests.entrySet()) {
            UUID requesterUUID = entry.getKey();
            TPRequest request = entry.getValue();
            if (!request.isTPortRequest() || !tport.getTportID().equals(request.getTPortUUID())) continue;
            requests.remove(requesterUUID);
            Player requester = Bukkit.getPlayer((UUID)requesterUUID);
            Player requestTo = Bukkit.getPlayer((UUID)request.getRequestToUUID());
            ColorTheme.sendInfoTranslation(requester, "tport.tpEvents.TPRequest.tportRemoved.requester", tport);
            ColorTheme.sendInfoTranslation(requestTo, "tport.tpEvents.TPRequest.tportRemoved.requestTo", requester, tport);
        }
    }

    public Message toInfo() {
        Encapsulation requestTo;
        String type;
        if (this.isTPortRequest()) {
            type = "TPort";
            requestTo = TPortEncapsulation.asTPort(this.getTPortUUID(), this.getRequestToUUID());
        } else {
            type = "PLTP";
            requestTo = PlayerEncapsulation.asPlayer(this.getRequestToUUID());
        }
        return ColorTheme.formatInfoTranslation("tport.fancyMessage.MessageUtils.tpRequest.description", type, requestTo);
    }

    public Message toInfo2() {
        Encapsulation requestTo;
        String type;
        if (this.isTPortRequest()) {
            type = "TPort";
            requestTo = TPortEncapsulation.asTPort(this.getTPortUUID(), this.getRequestToUUID());
        } else {
            type = "PLTP";
            requestTo = PlayerEncapsulation.asPlayer(this.getRequestToUUID());
        }
        return ColorTheme.formatTranslation(ColorTheme.ColorType.infoColor, ColorTheme.ColorType.varInfo2Color, "tport.fancyMessage.MessageUtils.tpRequest.description", type, requestTo);
    }

    public Message toError() {
        Encapsulation requestTo;
        String type;
        if (this.isTPortRequest()) {
            type = "TPort";
            requestTo = TPortEncapsulation.asTPort(this.getTPortUUID(), this.getRequestToUUID());
        } else {
            type = "PLTP";
            requestTo = PlayerEncapsulation.asPlayer(this.getRequestToUUID());
        }
        return ColorTheme.formatErrorTranslation("tport.fancyMessage.MessageUtils.tpRequest.description", type, requestTo);
    }

    public Message toSuccess() {
        Encapsulation requestTo;
        String type;
        if (this.isTPortRequest()) {
            type = "TPort";
            requestTo = TPortEncapsulation.asTPort(this.getTPortUUID(), this.getRequestToUUID());
        } else {
            type = "PLTP";
            requestTo = PlayerEncapsulation.asPlayer(this.getRequestToUUID());
        }
        return ColorTheme.formatSuccessTranslation("tport.fancyMessage.MessageUtils.tpRequest.description", type, requestTo);
    }
}

