/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.search;

import com.spaceman.tport.Main;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commandHandler.customRunnables.TabRunnable;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.MessageUtils;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.inventories.InventoryModel;
import com.spaceman.tport.inventories.TPortInventories;
import com.spaceman.tport.permissions.PermissionHandler;
import com.spaceman.tport.search.SearchMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class SearchType
implements MessageUtils.MessageDescription {
    private final String searchTypeName;
    private TabRunnable tabQuery = null;
    private QueryInventory queryInventory = null;
    private String queryName = null;
    private boolean loopedQuery = false;
    private boolean intSearch = false;
    private SubCommand command = null;
    private boolean hasSearchMode = false;
    private InventoryModel inventoryModel = null;
    private Searcher searcher = null;

    public SearchType(String searchTypeName) {
        this.searchTypeName = searchTypeName;
    }

    public String getSearchTypeName() {
        return this.searchTypeName;
    }

    public void hasSearchMode(boolean hasSearchMode) {
        this.hasSearchMode = hasSearchMode;
    }

    public boolean hasSearchMode() {
        return this.hasSearchMode;
    }

    public void setInventoryModel(InventoryModel inventoryModel) {
        this.inventoryModel = inventoryModel;
    }

    public ItemStack getDisplayItem(Player player) {
        if (this.inventoryModel == null) {
            return new ItemStack(Material.DIAMOND_BLOCK);
        }
        return this.inventoryModel.getItem(player);
    }

    @Override
    public Message getDescription() {
        return ColorTheme.formatInfoTranslation("tport.search.SearchType." + this.searchTypeName + ".description", new Object[0]);
    }

    @Override
    public Message getName(String color, String varColor) {
        return new Message(new TextComponent(this.searchTypeName, varColor));
    }

    @Override
    public String getInsertion() {
        return this.searchTypeName;
    }

    public void setSearcher(Searcher searcher) {
        this.searcher = searcher;
    }

    public boolean hasSearcher() {
        return this.searcher != null;
    }

    public List<ItemStack> search(SearchMode searchMode, String query, Player player) {
        return this.searcher.search(searchMode, query, player);
    }

    public void removeQuery() {
        this.queryName = null;
        this.tabQuery = null;
        this.queryInventory = null;
        this.loopedQuery = false;
        this.intSearch = false;
    }

    public void setQuery(String name, boolean looped, boolean intSearch, @Nullable TabRunnable tabQuery, @Nullable QueryInventory queryInventory) {
        this.queryName = name;
        this.loopedQuery = looped;
        this.intSearch = intSearch;
        this.tabQuery = Objects.requireNonNullElseGet(tabQuery, () -> (args, player) -> List.of());
        this.queryInventory = queryInventory;
    }

    public boolean hasQuery() {
        return this.queryName != null;
    }

    public boolean keyboardQuery() {
        return this.queryInventory == null;
    }

    public ArrayList<ItemStack> queryItems(Player player) {
        return this.queryInventory.queryItems(player);
    }

    public boolean isLoopedQuery() {
        return this.loopedQuery;
    }

    public boolean isIntSearch() {
        return this.intSearch;
    }

    public boolean hasPermission(Player player, boolean sendMessage) {
        return PermissionHandler.hasPermission(player, sendMessage, "TPort.search." + this.searchTypeName);
    }

    public EmptyCommand buildCommand() {
        EmptyCommand emptyQuery = null;
        if (this.hasQuery()) {
            emptyQuery = new EmptyCommand();
            emptyQuery.setCommandName(this.queryName, ArgumentType.REQUIRED);
            emptyQuery.setPermissions("TPort.search." + this.searchTypeName);
            emptyQuery.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.search." + this.searchTypeName + ".commandDescription", new Object[0]));
            if (this.loopedQuery) {
                emptyQuery.setTabRunnable(this.tabQuery);
            }
            emptyQuery.setLooped(this.loopedQuery);
        }
        EmptyCommand emptyMode = null;
        if (this.hasSearchMode) {
            if (!this.hasQuery()) {
                throw new IllegalArgumentException("No query type is set up for " + this.searchTypeName + ", this is required for a search mode");
            }
            emptyMode = new EmptyCommand();
            emptyMode.setCommandName("mode", ArgumentType.REQUIRED);
            emptyMode.setPermissions("TPort.search." + this.searchTypeName);
            emptyMode.setTabRunnable(this.tabQuery);
            emptyMode.addAction(emptyQuery);
        }
        if (this.intSearch && this.isLoopedQuery()) {
            throw new IllegalArgumentException("Int search does not support looped query");
        }
        EmptyCommand searchCommand = new EmptyCommand(){

            @Override
            public String getName(String argument) {
                return this.getCommandName();
            }
        };
        searchCommand.setCommandName(this.searchTypeName, ArgumentType.FIXED);
        searchCommand.setPermissions("TPort.search." + this.searchTypeName);
        searchCommand.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.search." + this.searchTypeName + ".commandDescription", new Object[0]));
        if (emptyMode != null) {
            if (this.intSearch) {
                searchCommand.setTabRunnable((args, player) -> Arrays.stream(SearchMode.values()).filter(SearchMode::hasIntegerFitter).map(Enum::name).collect(Collectors.toList()));
            } else {
                searchCommand.setTabRunnable((args, player) -> Arrays.stream(SearchMode.values()).map(Enum::name).collect(Collectors.toList()));
            }
        } else {
            searchCommand.setTabRunnable(this.tabQuery);
        }
        searchCommand.setRunnable((args, player) -> {
            int completeCommandLength = 2;
            if (this.hasSearchMode) {
                ++completeCommandLength;
            }
            if (this.hasQuery()) {
                ++completeCommandLength;
            }
            if (this.loopedQuery && args.length >= completeCommandLength || args.length == completeCommandLength) {
                String searchedQuery;
                SearchMode searchMode = null;
                if (this.hasSearchMode) {
                    searchMode = SearchMode.get(args[2]);
                    if (searchMode == null) {
                        ColorTheme.sendErrorTranslation(player, "tport.command.search.modeNotExist", args[2]);
                        return;
                    }
                    if (this.intSearch && !searchMode.hasIntegerFitter()) {
                        ColorTheme.sendErrorTranslation(player, "tport.command.search.modeNotIntSearch", args[2]);
                        return;
                    }
                }
                if (this.loopedQuery) {
                    searchedQuery = StringUtils.join((Object[])args, (String)" ", (int)(completeCommandLength - 1), (int)args.length);
                } else {
                    searchedQuery = args[completeCommandLength - 1];
                    if (this.isIntSearch()) {
                        try {
                            Integer.parseInt(searchedQuery);
                        }
                        catch (NumberFormatException nfe) {
                            ColorTheme.sendErrorTranslation(player, "tport.command.search.inputIsNotInteger", this, searchedQuery);
                            return;
                        }
                    }
                }
                if (this.queryInventory != null) {
                    ArrayList accepted = this.queryInventory.queryItems(player).stream().map(is -> (String)is.getItemMeta().getPersistentDataContainer().get(new NamespacedKey((Plugin)Main.getInstance(), "query"), PersistentDataType.STRING)).collect(Collectors.toCollection(ArrayList::new));
                    for (int i = completeCommandLength - 1; i < args.length; ++i) {
                        String givenQuery = args[i];
                        if (!accepted.stream().noneMatch(tmpQuery -> tmpQuery.equalsIgnoreCase(givenQuery))) continue;
                        ColorTheme.sendErrorTranslation(player, "tport.command.search.queryNotExist", this, args[i]);
                        return;
                    }
                }
                TPortInventories.openSearchGUI(player, 0, searchMode, this.searchTypeName, searchedQuery);
            } else {
                String command = "/tport search " + this.searchTypeName;
                if (this.hasSearchMode) {
                    command = command + " <mode>";
                }
                if (this.hasQuery()) {
                    command = command + " <";
                    command = command + this.queryName;
                    if (this.loopedQuery) {
                        command = command + "...";
                    }
                    command = command + ">";
                }
                ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", command);
            }
        });
        if (emptyMode != null) {
            searchCommand.addAction(emptyMode);
        } else {
            searchCommand.addAction(emptyQuery);
        }
        this.command = searchCommand;
        return searchCommand;
    }

    public SubCommand getCommand() {
        if (this.command == null) {
            return this.buildCommand();
        }
        return this.command;
    }

    @FunctionalInterface
    public static interface QueryInventory {
        public ArrayList<ItemStack> queryItems(Player var1);
    }

    @FunctionalInterface
    public static interface Searcher {
        public List<ItemStack> search(SearchMode var1, String var2, Player var3);
    }
}

