/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.playerUUID;

import com.spaceman.tport.Pair;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fileHander.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class PlayerUUID {
    public static String getPlayerName(String uuid) {
        return PlayerUUID.getPlayerName(UUID.fromString(uuid));
    }

    public static String getPlayerName(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        try {
            OfflinePlayer op = Bukkit.getOfflinePlayer((UUID)uuid);
            if ((op.hasPlayedBefore() || op.isOnline()) && op.getName() != null && Files.tportData.getConfig().contains("tport." + String.valueOf(op.getUniqueId()))) {
                return op.getName();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    @Nonnull
    public static Pair<String, UUID> getProfile(String playerName, @Nullable Player sender) {
        for (OfflinePlayer op : Bukkit.getOfflinePlayers()) {
            if (!op.hasPlayedBefore() && !op.isOnline() || op.getName() == null || !op.getName().equalsIgnoreCase(playerName)) continue;
            if (Files.tportData.getConfig().contains("tport." + String.valueOf(op.getUniqueId()))) {
                return new Pair<String, UUID>(op.getName(), op.getUniqueId());
            }
            ColorTheme.sendErrorTranslation(sender, "tport.command.playerNotFound", playerName);
            return new Pair<Object, Object>(null, null);
        }
        ColorTheme.sendErrorTranslation(sender, "tport.command.playerNotFound", playerName);
        return new Pair<Object, Object>(null, null);
    }

    public static List<Pair<String, UUID>> getProfiles() {
        ArrayList<Pair<String, UUID>> profiles = new ArrayList<Pair<String, UUID>>();
        for (OfflinePlayer op : Bukkit.getOfflinePlayers()) {
            if (!op.hasPlayedBefore() && !op.isOnline() || op.getName() == null || !Files.tportData.getConfig().contains("tport." + String.valueOf(op.getUniqueId()))) continue;
            profiles.add(new Pair<String, UUID>(op.getName(), op.getUniqueId()));
        }
        return profiles;
    }

    @Nullable
    public static UUID getPlayerUUID(String playerName) {
        return PlayerUUID.getPlayerUUID(playerName, null);
    }

    @Nullable
    public static UUID getPlayerUUID(String playerName, @Nullable Player sender) {
        Pair<String, UUID> pair = PlayerUUID.getProfile(playerName, sender);
        return pair.getRight();
    }

    @Nullable
    public static UUID getPlayerUUID_OLD2(String playerName) {
        for (OfflinePlayer op : Bukkit.getOfflinePlayers()) {
            if (!op.hasPlayedBefore() && !op.isOnline() || op.getName() == null || !op.getName().equalsIgnoreCase(playerName)) continue;
            return op.getUniqueId();
        }
        return null;
    }

    public static ArrayList<String> getPlayerNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (OfflinePlayer op : Bukkit.getOfflinePlayers()) {
            if (!Files.tportData.getConfig().contains("tport." + String.valueOf(op.getUniqueId()))) continue;
            list.add(op.getName());
        }
        return list;
    }

    public static ArrayList<UUID> getPlayerUUIDs() {
        ArrayList<UUID> list = new ArrayList<UUID>();
        for (OfflinePlayer op : Bukkit.getOnlinePlayers()) {
            if (!Files.tportData.getConfig().contains("tport." + String.valueOf(op.getUniqueId()))) continue;
            list.add(op.getUniqueId());
        }
        return list;
    }
}

