/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.keyValueHelper;

import com.spaceman.tport.Pair;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.keyValueHelper.ExtendedKey;
import com.spaceman.tport.keyValueHelper.Key;
import com.spaceman.tport.keyValueHelper.KeyValueError;
import com.spaceman.tport.keyValueHelper.KeyValueTabArgument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class KeyValueHelper {
    public static List<String> constructTab(String arg, KeyValueTabArgument ... keyValueTabArguments) {
        return KeyValueHelper.constructTab(arg, Arrays.asList(keyValueTabArguments));
    }

    private static List<Pair<String, String>> getWrittenPairs(String arg) {
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
        String[] split = (arg + " ").split(",");
        for (int i = 0; i < split.length - 1; ++i) {
            String[] keyValue = split[i].split("=");
            if (keyValue.length != 2) continue;
            list.add(new Pair<String, String>(keyValue[0], keyValue[1]));
        }
        return list;
    }

    private static List<KeyValueTabArgument> filterNotContaining(String arg, List<KeyValueTabArgument> keyValueTabArguments) {
        List<String> keys = Arrays.stream(arg.split(",")).map(s -> s.split("=")[0]).toList();
        return keyValueTabArguments.stream().filter(tabArgument -> !keys.contains(tabArgument.getKey())).collect(Collectors.toList());
    }

    public static List<String> constructTab(String arg, List<KeyValueTabArgument> keyValueTabArguments) {
        String lastKeyValue = arg.endsWith(",") ? "" : arg.split(",")[arg.split(",").length - 1];
        String lastKey = lastKeyValue.split("=")[0];
        String object = arg.substring(0, arg.lastIndexOf(lastKeyValue));
        if (lastKeyValue.contains("=")) {
            KeyValueTabArgument tabArgument = keyValueTabArguments.stream().filter(s -> s.getKey().equalsIgnoreCase(lastKey)).findFirst().orElse(null);
            if (tabArgument != null) {
                if (lastKeyValue.split("=").length == 2 && tabArgument.getValues(new ArrayList<Pair<String, String>>()).stream().anyMatch(s -> s.equalsIgnoreCase(lastKeyValue.split("=")[1]))) {
                    return KeyValueHelper.filterNotContaining(arg, keyValueTabArguments).stream().map(KeyValueTabArgument::getKey).map(s -> object + lastKeyValue + "," + s).collect(Collectors.toList());
                }
                ArrayList<String> list = new ArrayList<String>();
                for (String s2 : tabArgument.getValues(KeyValueHelper.getWrittenPairs(arg))) {
                    list.add(object + lastKey + "=" + s2);
                }
                return list;
            }
            return Collections.singletonList("");
        }
        for (KeyValueTabArgument tabArgument : keyValueTabArguments) {
            if (!tabArgument.getKey().equalsIgnoreCase(lastKey)) continue;
            ArrayList<String> list = new ArrayList<String>();
            for (String s3 : tabArgument.getValues(KeyValueHelper.getWrittenPairs(arg))) {
                list.add(object + lastKey + "=" + s3);
            }
            return list;
        }
        return KeyValueHelper.filterNotContaining(arg, keyValueTabArguments).stream().map(KeyValueTabArgument::getKey).map(s -> object + s).collect(Collectors.toList());
    }

    public static HashMap<String, Object> constructObject(String obj, Key ... keys) throws KeyValueError {
        return KeyValueHelper.constructObject(obj, Arrays.asList(keys));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HashMap<String, Object> constructObject(String stringObj, List<? extends Key> keys) throws KeyValueError {
        List neededList = keys.stream().filter(key -> !key.isOptional()).map(Key::getKey).map(String::toLowerCase).collect(Collectors.toList());
        HashMap<String, Object> keysMap = new HashMap<String, Object>();
        for (String keyValue : stringObj.split(",")) {
            if (!keyValue.matches(".+=.+")) throw new KeyValueError(ColorTheme.formatErrorTranslation("tport.keyValueHelper.keyValueHelper.error", keyValue, KeyValueHelper.getFormat(keys)));
            String[] split = keyValue.split("=");
            Key newKey = Key.getKey(keys, split[0]);
            if (newKey == null) throw new KeyValueError(ColorTheme.formatErrorTranslation("tport.keyValueHelper.keyValueHelper.keyError", split[0], KeyValueHelper.getFormat(keys)));
            Object value = newKey.check(split[1]);
            if (value == null && !newKey.isAcceptNullValue()) {
                throw new KeyValueError(ColorTheme.formatErrorTranslation(newKey.getErrorMessageID(), split[1]));
            }
            keysMap.put(newKey.getKey(), split[1]);
            keysMap.put(split[0].toLowerCase(), value);
            neededList.remove(split[0].toLowerCase());
        }
        if (neededList.isEmpty()) return keysMap;
        throw new KeyValueError(ColorTheme.formatErrorTranslation("tport.keyValueHelper.keyValueHelper.notAllNeededKeysUsed", KeyValueHelper.getFormat(keys)));
    }

    private static Message getFormat(List<? extends Key> keys) {
        Message message = new Message(TextComponent.textComponent(""));
        for (Key key : keys) {
            if (key.getKey() != null && !key.getKey().equals("")) {
                if (key.isOptional()) {
                    message.addText(TextComponent.textComponent(key.getKey() + "=[value]", ColorTheme.ColorType.varErrorColor, new HoverEvent(ColorTheme.formatErrorTranslation("tport.keyValueHelper.keyValueHelper.format", new Object[0]))));
                } else {
                    message.addText(TextComponent.textComponent(key.getKey() + "=<value>", ColorTheme.ColorType.varErrorColor));
                }
            }
            message.addText(TextComponent.textComponent(",", ColorTheme.ColorType.varErrorColor));
        }
        message.removeLast();
        return message;
    }

    public static HashMap<String, Object> extendedConstructObject(String stringObj, Object obj, ExtendedKey ... keys) throws KeyValueError {
        return KeyValueHelper.extendedConstructObject(stringObj, obj, Arrays.asList(keys));
    }

    public static HashMap<String, Object> extendedConstructObject(String stringObj, Object obj, List<ExtendedKey> keys) throws KeyValueError {
        HashMap<String, Object> map = KeyValueHelper.constructObject(stringObj, keys);
        for (String keyName : map.keySet()) {
            Key key = Key.getKey(keys, keyName);
            if (key == null || !(key instanceof ExtendedKey)) continue;
            ((ExtendedKey)key).set(obj, map.get(key.getKey()));
        }
        map.put(null, obj);
        return map;
    }
}

