/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.keyValueHelper;

import java.util.List;

public class Key {
    private String errorMessageID = " is not valid";
    private boolean acceptNullValue = false;
    private final String key;
    private final ValueChecker checker;
    private final boolean optional;

    public Key(String key, ValueChecker checker, boolean optional) {
        this.key = key;
        this.checker = checker;
        this.optional = optional;
    }

    public static Key getKey(List<? extends Key> keyList, String key) {
        return keyList.stream().filter(k -> k.getKey().equalsIgnoreCase(key)).findFirst().orElse(null);
    }

    public String getKey() {
        return this.key;
    }

    public Object check(String value) {
        try {
            return this.checker.check(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Key setErrorMessageID(String errorMessageID) {
        this.errorMessageID = errorMessageID;
        return this;
    }

    public String getErrorMessageID() {
        return this.errorMessageID;
    }

    public boolean isAcceptNullValue() {
        return this.acceptNullValue;
    }

    public Key setAcceptNullValue(boolean acceptNullValue) {
        this.acceptNullValue = acceptNullValue;
        return this;
    }

    public boolean isOptional() {
        return this.optional;
    }

    @FunctionalInterface
    public static interface ValueChecker {
        public Object check(String var1);
    }
}

