/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.inventories;

import com.google.gson.JsonObject;
import com.spaceman.tport.Glow;
import com.spaceman.tport.Main;
import com.spaceman.tport.Pair;
import com.spaceman.tport.commands.TPortCommand;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.commands.tport.MainLayout;
import com.spaceman.tport.commands.tport.SafetyCheck;
import com.spaceman.tport.commands.tport.Sort;
import com.spaceman.tport.commands.tport.pltp.Whitelist;
import com.spaceman.tport.commands.tport.publc.Move;
import com.spaceman.tport.commands.tport.publc.Remove;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.MessageUtils;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.TextType;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.fancyMessage.inventories.FancyClickEvent;
import com.spaceman.tport.fancyMessage.inventories.FancyInventory;
import com.spaceman.tport.fancyMessage.language.Language;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.inventories.QuickEditInventories;
import com.spaceman.tport.inventories.SettingsInventories;
import com.spaceman.tport.inventories.TPortInventories;
import com.spaceman.tport.playerUUID.PlayerUUID;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import com.spaceman.tport.webMaps.DynmapHandler;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ItemFactory {
    public static ItemStack getHead(UUID head, Player player, List<HeadAttributes> attributes, @Nullable Object headData) {
        return ItemFactory.getHead(Bukkit.getOfflinePlayer((UUID)head), player, attributes, headData);
    }

    public static ItemStack getHead(OfflinePlayer headOwner, Player player, List<HeadAttributes> attributes, @Nullable Object headData) {
        TPort tport;
        if (headOwner == null) {
            return null;
        }
        ItemStack item = new ItemStack(Material.PLAYER_HEAD);
        ColorTheme theme = ColorTheme.getTheme(player);
        String displayTitle = headOwner.getName() == null ? headOwner.getUniqueId().toString() : headOwner.getName();
        Message title = ColorTheme.formatTranslation(ColorTheme.ColorType.titleColor, ColorTheme.ColorType.titleColor, "tport.inventories.itemFactory.getHead.title", displayTitle);
        List<Message> lore = attributes.contains((Object)HeadAttributes.TPORT_AMOUNT) ? PlayerEncapsulation.getPlayerData(headOwner.getUniqueId()) : new ArrayList<Message>();
        if (attributes.contains((Object)HeadAttributes.HOME_PLAYER_SELECTION)) {
            FancyClickEvent.addCommand(item, ClickType.LEFT, "tport open " + headOwner.getName());
            lore.add(new Message());
            lore.add(ColorTheme.formatInfoTranslation("tport.inventories.itemFactory.getHead.home_player_selection", ClickType.LEFT));
            FancyClickEvent.addCommand(item, ClickType.LEFT, "tport home set " + headOwner.getName());
        }
        if (attributes.contains((Object)HeadAttributes.CLICK_EVENTS)) {
            lore.add(new Message());
            lore.add(ColorTheme.formatInfoTranslation("tport.inventories.itemFactory.getHead.click_events.clickToOpen", ClickType.LEFT));
            FancyClickEvent.addCommand(item, ClickType.LEFT, "tport open " + headOwner.getName());
            if (headOwner.isOnline()) {
                lore.add(ColorTheme.formatInfoTranslation("tport.inventories.itemFactory.getHead.click_events.PLTP", ClickType.RIGHT, headOwner.getName()));
                FancyClickEvent.addCommand(item, ClickType.RIGHT, "tport pltp tp " + headOwner.getName());
                lore.add(ColorTheme.formatInfoTranslation("tport.inventories.itemFactory.getHead.click_events.preview", TextComponent.textComponent("key.drop", ColorTheme.ColorType.varInfoColor).setType(TextType.KEYBIND), headOwner.getName()));
                FancyClickEvent.addCommand(item, ClickType.DROP, "tport preview " + headOwner.getName());
                if (DynmapHandler.isEnabled()) {
                    lore.add(ColorTheme.formatInfoTranslation("tport.inventories.itemFactory.getHead.click_events.dynmapSearch", ClickType.CONTROL_DROP, headOwner.getName()));
                    FancyClickEvent.addCommand(item, ClickType.CONTROL_DROP, "tport dynmap search " + headOwner.getName());
                }
            }
        }
        if (attributes.contains((Object)HeadAttributes.SELECT_COLOR_THEME)) {
            FancyClickEvent.addCommand(item, ClickType.LEFT, "tport colorTheme copy " + displayTitle);
            FancyClickEvent.addFunction(item, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> SettingsInventories.openTPortColorThemeGUI(whoClicked));
            ColorTheme ownerTheme = ColorTheme.getTheme(headOwner.getUniqueId());
            Message infoMessage = ColorTheme.formatTranslation(ownerTheme.getVarInfoColor(), ownerTheme.getVarInfoColor(), "tport.settingsInventories.openTPortColorTheme_selectThemeFromPlayer.theme.info", new Object[0]);
            Message infoList = ColorTheme.formatTranslation(ownerTheme.getInfoColor(), ownerTheme.getVarInfoColor(), "tport.settingsInventories.openTPortColorTheme_selectThemeFromPlayer.theme.info.list", infoMessage);
            Message infoTheme = ColorTheme.formatTranslation(ownerTheme.getInfoColor(), ownerTheme.getVarInfoColor(), "tport.settingsInventories.openTPortColorTheme_selectThemeFromPlayer.theme.info.theme", infoMessage);
            Message infoArray = new Message();
            boolean color = true;
            for (String s : Arrays.asList("TPort", "BiomeTP", "FeatureTP", player.getName())) {
                infoArray.addMessage(ColorTheme.formatTranslation(ownerTheme.getInfoColor(), color ? ownerTheme.getVarInfoColor() : ownerTheme.getVarInfo2Color(), "%s", s));
                infoArray.addText(TextComponent.textComponent(", ", ownerTheme.getInfoColor()));
                color = !color;
            }
            infoArray.removeLast();
            Message successMessage = ColorTheme.formatTranslation(ownerTheme.getVarSuccessColor(), ownerTheme.getVarSuccessColor(), "tport.settingsInventories.openTPortColorTheme_selectThemeFromPlayer.theme.success", new Object[0]);
            Message successList = ColorTheme.formatTranslation(ownerTheme.getSuccessColor(), ownerTheme.getVarSuccessColor(), "tport.settingsInventories.openTPortColorTheme_selectThemeFromPlayer.theme.success.list", successMessage);
            Message successTheme = ColorTheme.formatTranslation(ownerTheme.getSuccessColor(), ownerTheme.getVarSuccessColor(), "tport.settingsInventories.openTPortColorTheme_selectThemeFromPlayer.theme.success.theme", successMessage);
            Message successArray = new Message();
            color = true;
            for (String s : Arrays.asList("TPort", "BiomeTP", "FeatureTP", player.getName())) {
                successArray.addMessage(ColorTheme.formatTranslation(ownerTheme.getSuccessColor(), color ? ownerTheme.getVarSuccessColor() : ownerTheme.getVarSuccess2Color(), "%s", s));
                successArray.addText(TextComponent.textComponent(", ", ownerTheme.getSuccessColor()));
                color = !color;
            }
            successArray.removeLast();
            Message errorMessage = ColorTheme.formatTranslation(ownerTheme.getVarErrorColor(), ownerTheme.getVarErrorColor(), "tport.settingsInventories.openTPortColorTheme_selectThemeFromPlayer.theme.error", new Object[0]);
            Message errorList = ColorTheme.formatTranslation(ownerTheme.getErrorColor(), ownerTheme.getVarErrorColor(), "tport.settingsInventories.openTPortColorTheme_selectThemeFromPlayer.theme.error.list", errorMessage);
            Message errorTheme = ColorTheme.formatTranslation(ownerTheme.getErrorColor(), ownerTheme.getVarErrorColor(), "tport.settingsInventories.openTPortColorTheme_selectThemeFromPlayer.theme.error.theme", errorMessage);
            Message errorArray = new Message();
            color = true;
            for (String s : Arrays.asList("TPort", "BiomeTP", "FeatureTP", player.getName())) {
                errorArray.addMessage(ColorTheme.formatTranslation(ownerTheme.getErrorColor(), color ? ownerTheme.getVarErrorColor() : ownerTheme.getVarError2Color(), "%s", s));
                errorArray.addText(TextComponent.textComponent(", ", ownerTheme.getErrorColor()));
                color = !color;
            }
            errorArray.removeLast();
            lore.add(new Message());
            lore.add(infoTheme);
            lore.add(infoList);
            lore.add(infoArray);
            lore.add(new Message());
            lore.add(successTheme);
            lore.add(successList);
            lore.add(successArray);
            lore.add(new Message());
            lore.add(errorTheme);
            lore.add(errorList);
            lore.add(errorArray);
        }
        if (attributes.contains((Object)HeadAttributes.OFFER_TO_PLAYER) && headData instanceof Pair) {
            Pair pair = (Pair)headData;
            TPort tport2 = (TPort)pair.getLeft();
            Boolean fromQuickEdit = (Boolean)pair.getRight();
            lore.add(new Message());
            lore.add(ColorTheme.formatInfoTranslation("tport.inventories.itemFactory.getHead.offer_to_player", ClickType.LEFT, TPortEncapsulation.asTPort(tport2), PlayerEncapsulation.asPlayer(headOwner)));
            FancyClickEvent.addCommand(item, ClickType.LEFT, "tport transfer offer " + headOwner.getName() + " " + tport2.getName());
            if (fromQuickEdit.booleanValue()) {
                FancyClickEvent.addFunction(item, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> QuickEditInventories.openQuickEditSelection(whoClicked, 0, fancyInventory.getData(TPort.tportUUIDDataName)));
            } else {
                FancyClickEvent.addFunction(item, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> TPortInventories.openTPortGUI(whoClicked.getUniqueId(), whoClicked));
            }
        }
        if (attributes.contains((Object)HeadAttributes.REMOVE_PLAYER)) {
            lore.add(new Message());
            lore.add(ColorTheme.formatInfoTranslation("tport.inventories.itemFactory.getHead.remove_player", ClickType.LEFT));
            FancyClickEvent.setStringData(item, new NamespacedKey((Plugin)Main.getInstance(), "toRemoveUUID"), headOwner.getUniqueId().toString());
            FancyClickEvent.addFunction(item, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> {
                NamespacedKey toRemoveUUIDKey = new NamespacedKey((Plugin)Main.getInstance(), "toRemoveUUID");
                if (pdc.has(toRemoveUUIDKey, PersistentDataType.STRING)) {
                    UUID toRemoveUUID = UUID.fromString((String)pdc.get(toRemoveUUIDKey, PersistentDataType.STRING));
                    SettingsInventories.openRemovePlayerConfirmationGUI(whoClicked, toRemoveUUID);
                }
            });
        }
        if (attributes.contains((Object)HeadAttributes.TPORT_WHITELIST) && headData instanceof TPort) {
            tport = (TPort)headData;
            lore.add(new Message());
            if (tport.getWhitelist().contains(headOwner.getUniqueId())) {
                FancyClickEvent.addFunction(item, ClickType.LEFT, (whoClicked, clickType, innerPDC, fancyInventory) -> {
                    NamespacedKey innerPlayerNameKey = new NamespacedKey((Plugin)Main.getInstance(), "playerName");
                    if (innerPDC.has(innerPlayerNameKey, PersistentDataType.STRING)) {
                        String innerPlayerName = (String)innerPDC.get(innerPlayerNameKey, PersistentDataType.STRING);
                        String tportName = fancyInventory.getData(TPort.tportDataName).getName();
                        TPortCommand.executeTPortCommand((CommandSender)whoClicked, "edit " + tportName + " whitelist remove " + innerPlayerName);
                        QuickEditInventories.openTPortWhitelistSelectorGUI(whoClicked, fancyInventory.getData(FancyInventory.pageDataName), fancyInventory);
                    }
                });
                lore.add(ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortWhitelistSelectionGUI.player.unselect", ClickType.LEFT, headOwner.getName()));
            } else {
                FancyClickEvent.addFunction(item, ClickType.LEFT, (whoClicked, clickType, innerPDC, fancyInventory) -> {
                    NamespacedKey innerPlayerNameKey = new NamespacedKey((Plugin)Main.getInstance(), "playerName");
                    if (innerPDC.has(innerPlayerNameKey, PersistentDataType.STRING)) {
                        String innerPlayerName = (String)innerPDC.get(innerPlayerNameKey, PersistentDataType.STRING);
                        String tportName = fancyInventory.getData(TPort.tportDataName).getName();
                        TPortCommand.executeTPortCommand((CommandSender)whoClicked, "edit " + tportName + " whitelist add " + innerPlayerName);
                        QuickEditInventories.openTPortWhitelistSelectorGUI(whoClicked, fancyInventory.getData(FancyInventory.pageDataName), fancyInventory);
                    }
                });
                lore.add(ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortWhitelistSelectionGUI.player.select", ClickType.LEFT, headOwner.getName()));
            }
        }
        if (attributes.contains((Object)HeadAttributes.TPORT_LOG_SELECTION) && headData instanceof TPort) {
            Message currentState;
            tport = (TPort)headData;
            boolean isPlayerLogged = tport.getLogged().contains(headOwner.getUniqueId());
            lore.add(new Message());
            if (isPlayerLogged) {
                currentState = ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortLogSelectionGUI.player.logState", tport.getLogMode(headOwner.getUniqueId()));
            } else {
                Message defaultState = ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortLogSelectionGUI.player.default", new Object[0]);
                currentState = ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortLogSelectionGUI.player.defaultState", tport.getLogMode(headOwner.getUniqueId()), defaultState);
            }
            Message nextState = ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortLogSelectionGUI.player.nextLogState", ClickType.LEFT, tport.getLogMode(headOwner.getUniqueId()).getNext());
            Message delete = !isPlayerLogged ? null : ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortLogSelectionGUI.player.remove", ClickType.RIGHT, headOwner.getName());
            lore.add(currentState);
            lore.add(nextState);
            lore.add(delete);
            FancyClickEvent.addFunction(item, ClickType.LEFT, (whoClicked, clickType, innerPDC, fancyInventory) -> {
                NamespacedKey innerPlayerNameKey = new NamespacedKey((Plugin)Main.getInstance(), "playerName");
                NamespacedKey innerPlayerUUIDKey = new NamespacedKey((Plugin)Main.getInstance(), "playerUUID");
                if (innerPDC.has(innerPlayerNameKey, PersistentDataType.STRING)) {
                    String innerPlayerName = (String)innerPDC.get(innerPlayerNameKey, PersistentDataType.STRING);
                    UUID innerPlayerUUID = UUID.fromString((String)innerPDC.get(innerPlayerUUIDKey, PersistentDataType.STRING));
                    TPort innerTPort = fancyInventory.getData(TPort.tportDataName);
                    TPortCommand.executeTPortCommand((CommandSender)whoClicked, new String[]{"log", "add", innerTPort.getName(), innerPlayerName + ":" + String.valueOf(innerTPort.getLogMode(innerPlayerUUID).getNext())});
                    QuickEditInventories.openTPortLogSelectorGUI(whoClicked, fancyInventory.getData(FancyInventory.pageDataName), fancyInventory);
                }
            });
            if (isPlayerLogged) {
                FancyClickEvent.addFunction(item, ClickType.RIGHT, (whoClicked, clickType, innerPDC, fancyInventory) -> {
                    NamespacedKey innerPlayerNameKey = new NamespacedKey((Plugin)Main.getInstance(), "playerName");
                    if (innerPDC.has(innerPlayerNameKey, PersistentDataType.STRING)) {
                        String innerPlayerName = (String)innerPDC.get(innerPlayerNameKey, PersistentDataType.STRING);
                        TPort innerTPort = fancyInventory.getData(TPort.tportDataName);
                        TPortCommand.executeTPortCommand((CommandSender)whoClicked, new String[]{"log", "remove", innerTPort.getName(), innerPlayerName});
                        QuickEditInventories.openTPortLogSelectorGUI(whoClicked, fancyInventory.getData(FancyInventory.pageDataName), fancyInventory);
                    }
                });
            }
        }
        if (attributes.contains((Object)HeadAttributes.TPORT_LOG_READ) && headData instanceof ImmutableTriple) {
            lore.add(new Message());
            ImmutableTriple triple = (ImmutableTriple)headData;
            Message timestamp = ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortLogReadGUI.log.time", triple.left, ((SimpleDateFormat)triple.right).format(((TPort.LogEntry)triple.middle).timeOfTeleport().getTime()));
            Message logMode = ((TPort.LogEntry)triple.middle).loggedMode() == null ? null : ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortLogReadGUI.log.logMode", ((TPort.LogEntry)triple.middle).loggedMode());
            Message ownerOnline = ((TPort.LogEntry)triple.middle).ownerOnline() == null ? null : ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortLogReadGUI.log.ownerOnline." + ((TPort.LogEntry)triple.middle).ownerOnline(), ((TPort.LogEntry)triple.middle).ownerOnline());
            lore.add(timestamp);
            lore.add(logMode);
            lore.add(ownerOnline);
        }
        if (attributes.contains((Object)HeadAttributes.TPORT_LOG_READ_FILTER)) {
            lore.add(new Message());
            lore.add(ColorTheme.formatInfoTranslation("tport.quickEditInventories.openTPortLogRead_filterGUI.selectForFiltering", ClickType.LEFT));
            FancyClickEvent.addFunction(item, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> QuickEditInventories.openTPortLogReadGUI(whoClicked, fancyInventory.getData(TPort.tportDataName), headOwner.getUniqueId()));
        }
        if (attributes.contains((Object)HeadAttributes.PLTP_WHITELIST)) {
            ArrayList<String> pltpWhitelist = Whitelist.getPLTPWhitelist(player);
            FancyClickEvent.setStringData(item, new NamespacedKey((Plugin)Main.getInstance(), "playerName"), headOwner.getName());
            lore.add(new Message());
            if (pltpWhitelist.contains(headOwner.getUniqueId().toString())) {
                FancyClickEvent.addFunction(item, ClickType.LEFT, (whoClicked, clickType, innerPDC, fancyInventory) -> {
                    NamespacedKey innerPlayerNameKey = new NamespacedKey((Plugin)Main.getInstance(), "playerName");
                    if (innerPDC.has(innerPlayerNameKey, PersistentDataType.STRING)) {
                        String innerPlayerName = (String)innerPDC.get(innerPlayerNameKey, PersistentDataType.STRING);
                        TPortCommand.executeTPortCommand((CommandSender)whoClicked, "pltp whitelist remove " + innerPlayerName);
                        SettingsInventories.openPLTPWhitelistSelectorGUI(whoClicked, fancyInventory.getData(FancyInventory.pageDataName), fancyInventory);
                    }
                });
                lore.add(ColorTheme.formatInfoTranslation("tport.tportInventories.openPLTPWhitelistSelectionGUI.player.unselect", ClickType.LEFT, headOwner.getName()));
            } else {
                FancyClickEvent.addFunction(item, ClickType.LEFT, (whoClicked, clickType, innerPDC, fancyInventory) -> {
                    NamespacedKey innerPlayerNameKey = new NamespacedKey((Plugin)Main.getInstance(), "playerName");
                    if (innerPDC.has(innerPlayerNameKey, PersistentDataType.STRING)) {
                        String innerPlayerName = (String)innerPDC.get(innerPlayerNameKey, PersistentDataType.STRING);
                        TPortCommand.executeTPortCommand((CommandSender)whoClicked, "pltp whitelist add " + innerPlayerName);
                        SettingsInventories.openPLTPWhitelistSelectorGUI(whoClicked, fancyInventory.getData(FancyInventory.pageDataName), fancyInventory);
                    }
                });
                lore.add(ColorTheme.formatInfoTranslation("tport.tportInventories.openPLTPWhitelistSelectionGUI.player.select", ClickType.LEFT, headOwner.getName()));
            }
        }
        JsonObject playerLang = Language.getPlayerLang(player.getUniqueId());
        title = MessageUtils.translateMessage(title, playerLang);
        lore = MessageUtils.translateMessage(lore, playerLang);
        MessageUtils.setCustomItemData(item, theme, title, lore);
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        if (meta != null) {
            meta.setOwningPlayer(headOwner);
            item.setItemMeta((ItemMeta)meta);
        }
        return item;
    }

    public static void onQuickEdit(Player whoClicked, PersistentDataContainer pdc, FancyInventory fancyInventory, QuickEditInventories.QuickEditType quickEditType) {
        boolean reopen;
        UUID tportUUID = null;
        boolean fromQuickEditSelection = false;
        NamespacedKey tportUUIDKey = new NamespacedKey((Plugin)Main.getInstance(), "tportUUID");
        if (pdc.has(tportUUIDKey, PersistentDataType.STRING)) {
            tportUUID = UUID.fromString((String)pdc.get(tportUUIDKey, PersistentDataType.STRING));
        }
        if (fancyInventory.hasData(TPort.tportUUIDDataName)) {
            tportUUID = fancyInventory.getData(TPort.tportUUIDDataName);
            fromQuickEditSelection = true;
        }
        if (tportUUID == null) {
            return;
        }
        TPort quickEditTPort = TPortManager.getTPort(whoClicked.getUniqueId(), tportUUID);
        if (quickEditTPort != null && (reopen = quickEditType.edit(quickEditTPort, whoClicked, fancyInventory))) {
            if (fromQuickEditSelection) {
                QuickEditInventories.openQuickEditSelection(whoClicked, 0, tportUUID);
            } else {
                TPortInventories.openTPortGUI(whoClicked.getUniqueId(), whoClicked, fancyInventory);
            }
        }
    }

    public static ItemStack toTPortItem(TPort tport, Player player, List<TPortItemAttributes> attributes) {
        return ItemFactory.toTPortItem(tport, player, attributes, null);
    }

    public static ItemStack toTPortItem(TPort tport, Player player, List<TPortItemAttributes> attributes, @Nullable Object extraData) {
        ItemStack is = tport.getItem();
        ItemMeta im = is.getItemMeta();
        if (im == null) {
            return is;
        }
        FancyClickEvent.removeAllFunctions(im);
        ColorTheme theme = ColorTheme.getTheme(player);
        im.getPersistentDataContainer().set(new NamespacedKey((Plugin)Main.getInstance(), "tportUUID"), PersistentDataType.STRING, (Object)tport.getTportID().toString());
        im.getPersistentDataContainer().set(new NamespacedKey((Plugin)Main.getInstance(), "tportName"), PersistentDataType.STRING, (Object)tport.getName());
        for (Enchantment e : im.getEnchants().keySet()) {
            im.removeEnchant(e);
        }
        for (ItemFlag itemFlag : ItemFlag.values()) {
            im.addItemFlags(new ItemFlag[]{itemFlag});
        }
        try {
            im.removeItemFlags(new ItemFlag[]{ItemFlag.HIDE_LORE});
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        Message title = ColorTheme.formatTranslation(ColorTheme.ColorType.infoColor, ColorTheme.ColorType.varInfoColor, "tport.inventories.itemFactory.toTPortItem.title", tport.getName());
        List<Message> lore = tport.getHoverData(attributes.contains((Object)TPortItemAttributes.ADD_OWNER));
        if (tport.getOwner().equals(player.getUniqueId()) && attributes.contains((Object)TPortItemAttributes.QUICK_EDITOR)) {
            FancyInventory prevWindow = null;
            if (extraData instanceof FancyInventory) {
                prevWindow = (FancyInventory)extraData;
            }
            lore.add(new Message());
            QuickEditInventories.QuickEditType type = QuickEditInventories.QuickEditType.getForPlayer(player.getUniqueId());
            lore.add(ColorTheme.formatInfoTranslation("tport.inventories.itemFactory.toTPortItem.editing", ClickType.RIGHT, type.getDisplayName()));
            lore.add(ColorTheme.formatInfoTranslation("tport.inventories.itemFactory.toTPortItem.buttons", ClickType.SHIFT_RIGHT));
            if (prevWindow != null && (tport.getTportID().equals(prevWindow.getData(QuickEditInventories.tportToMoveDataName)) || tport.getTportID().equals(prevWindow.getData(QuickEditInventories.whitelistCloneToDataName)))) {
                Glow.addGlow(im);
            }
            FancyClickEvent.addFunction(im, ClickType.RIGHT, (whoClicked, clickType, pdc, fancyInventory) -> {
                QuickEditInventories.QuickEditType quickEditType = QuickEditInventories.QuickEditType.getForPlayer(whoClicked.getUniqueId());
                ItemFactory.onQuickEdit(whoClicked, pdc, fancyInventory, quickEditType);
            });
            FancyClickEvent.addFunction(im, ClickType.SHIFT_RIGHT, (whoClicked, clickType, pdc, fancyInventory) -> {
                TPort quickEditTPort;
                NamespacedKey tportUUIDKey = new NamespacedKey((Plugin)Main.getInstance(), "tportUUID");
                if (pdc.has(tportUUIDKey, PersistentDataType.STRING) && (quickEditTPort = TPortManager.getTPort(whoClicked.getUniqueId(), UUID.fromString((String)pdc.get(tportUUIDKey, PersistentDataType.STRING)))) != null) {
                    QuickEditInventories.openQuickEditSelection(whoClicked, 0, quickEditTPort.getTportID());
                }
            });
        }
        if (attributes.contains((Object)TPortItemAttributes.CLICK_TO_OPEN)) {
            Boolean safetyState = null;
            if (tport.getOwner().equals(player.getUniqueId())) {
                if (SafetyCheck.SafetyCheckSource.TPORT_OWN.hasPermission(player, false)) {
                    safetyState = SafetyCheck.SafetyCheckSource.TPORT_OWN.getState(player);
                }
            } else if (SafetyCheck.SafetyCheckSource.TPORT_OPEN.hasPermission(player, false)) {
                safetyState = SafetyCheck.SafetyCheckSource.TPORT_OPEN.getState(player);
            }
            lore.add(new Message());
            lore.add(ColorTheme.formatInfoTranslation("tport.inventories.itemFactory.toTPortItem.teleportSelected", ClickType.LEFT));
            FancyClickEvent.addCommand(im, ClickType.LEFT, "tport open " + PlayerUUID.getPlayerName(tport.getOwner()) + " " + tport.getName());
            if (safetyState != null) {
                lore.add(ColorTheme.formatInfoTranslation("tport.inventories.itemFactory.toTPortItem.invertSafetyCheck", ClickType.SHIFT_LEFT, safetyState == false));
                FancyClickEvent.addCommand(im, ClickType.SHIFT_LEFT, "tport open " + PlayerUUID.getPlayerName(tport.getOwner()) + " " + tport.getName() + " " + (safetyState == false));
            }
            lore.add(ColorTheme.formatInfoTranslation("tport.inventories.itemFactory.toTPortItem.preview", ClickType.DROP));
            FancyClickEvent.addCommand(im, ClickType.DROP, "tport preview " + PlayerUUID.getPlayerName(tport.getOwner()) + " " + tport.getName());
            if (DynmapHandler.isEnabled()) {
                lore.add(ColorTheme.formatInfoTranslation("tport.inventories.itemFactory.toTPortItem.dynmapSearch", ClickType.CONTROL_DROP));
                FancyClickEvent.addCommand(im, ClickType.CONTROL_DROP, "tport dynmap search " + PlayerUUID.getPlayerName(tport.getOwner()) + " " + tport.getName());
            }
        }
        if (attributes.contains((Object)TPortItemAttributes.CLICK_TO_OPEN_PUBLIC)) {
            Boolean safetyState = null;
            if (SafetyCheck.SafetyCheckSource.TPORT_PUBLIC.hasPermission(player, false)) {
                safetyState = SafetyCheck.SafetyCheckSource.TPORT_PUBLIC.getState(player);
            }
            FancyClickEvent.addCommand(im, ClickType.LEFT, "tport public open " + tport.getName());
            FancyClickEvent.addCommand(im, ClickType.DROP, "tport preview " + PlayerUUID.getPlayerName(tport.getOwner()) + " " + tport.getName());
            if (safetyState != null) {
                FancyClickEvent.addCommand(im, ClickType.SHIFT_LEFT, "tport public open " + tport.getName() + " " + (safetyState == false));
            }
            lore.add(new Message());
            lore.add(ColorTheme.formatInfoTranslation("tport.inventories.itemFactory.toTPortItem.teleportSelected", ClickType.LEFT));
            if (safetyState != null) {
                lore.add(ColorTheme.formatInfoTranslation("tport.inventories.itemFactory.toTPortItem.invertSafetyCheck", ClickType.SHIFT_LEFT, safetyState == false));
            }
            lore.add(ColorTheme.formatInfoTranslation("tport.inventories.itemFactory.toTPortItem.preview", ClickType.DROP));
        }
        if (attributes.contains((Object)TPortItemAttributes.PUBLIC_MOVE_DELETE)) {
            FancyInventory prevWindow = null;
            if (extraData instanceof FancyInventory) {
                prevWindow = (FancyInventory)extraData;
            }
            FancyClickEvent.addFunction(im, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> {
                NamespacedKey keyUUID = new NamespacedKey((Plugin)Main.getInstance(), "tportUUID");
                if (pdc.has(keyUUID, PersistentDataType.STRING)) {
                    if (!Move.getInstance().emptySlot.hasPermissionToRun(whoClicked, false)) {
                        return;
                    }
                    TPort toMoveTPort = TPortManager.getTPort(UUID.fromString((String)pdc.get(keyUUID, PersistentDataType.STRING)));
                    if (toMoveTPort == null) {
                        return;
                    }
                    UUID moveToTPort = fancyInventory.getData(QuickEditInventories.tportToMoveDataName);
                    if (moveToTPort == null) {
                        fancyInventory.setData(QuickEditInventories.tportToMoveDataName, toMoveTPort.getTportID());
                        SettingsInventories.openPublicTPTPortsSettings(whoClicked, fancyInventory.getData(FancyInventory.pageDataName), fancyInventory);
                    } else {
                        TPort tmpTPort;
                        fancyInventory.setData(QuickEditInventories.tportToMoveDataName, null);
                        if (!moveToTPort.equals(toMoveTPort.getTportID()) && (tmpTPort = TPortManager.getTPort(moveToTPort)) != null) {
                            TPortCommand.executeTPortCommand((CommandSender)whoClicked, new String[]{"public", "move", tmpTPort.getName(), toMoveTPort.getName()});
                        }
                        SettingsInventories.openPublicTPTPortsSettings(whoClicked, fancyInventory.getData(FancyInventory.pageDataName), fancyInventory);
                    }
                }
            });
            lore.add(new Message());
            if (Move.getInstance().emptySlot.hasPermissionToRun(player, false)) {
                lore.add(ColorTheme.formatInfoTranslation("tport.inventories.itemFactory.toTPortItem.publicMove", ClickType.LEFT, tport));
                if (prevWindow != null && tport.getTportID().equals(prevWindow.getData(QuickEditInventories.tportToMoveDataName))) {
                    Glow.addGlow(im);
                }
            }
            if (Remove.getInstance().emptyAll.hasPermissionToRun(player, false)) {
                lore.add(ColorTheme.formatInfoTranslation("tport.inventories.itemFactory.toTPortItem.publicRemove", ClickType.SHIFT_RIGHT, tport));
                FancyClickEvent.addCommand(im, ClickType.SHIFT_RIGHT, "tport public remove " + tport.getName());
                FancyClickEvent.addFunction(im, ClickType.SHIFT_RIGHT, (whoClicked, clickType, pdc, fancyInventory) -> SettingsInventories.openPublicTPTPortsSettings(whoClicked, fancyInventory.getData(FancyInventory.pageDataName), fancyInventory));
            }
        }
        if (attributes.contains((Object)TPortItemAttributes.SELECT_HOME)) {
            lore.add(new Message());
            lore.add(ColorTheme.formatInfoTranslation("tport.inventories.itemFactory.toTPortItem.selectAsHome", ClickType.LEFT));
            FancyClickEvent.addCommand(im, ClickType.LEFT, "tport home set " + PlayerUUID.getPlayerName(tport.getOwner()) + " " + tport.getName(), "tport");
        }
        if (attributes.contains((Object)TPortItemAttributes.TRANSFER_OFFERS) && extraData instanceof PlayerEncapsulation) {
            PlayerEncapsulation pe = (PlayerEncapsulation)extraData;
            lore.add(new Message());
            lore.add(ColorTheme.formatInfoTranslation("tport.inventories.itemFactory.toTPortItem.transfer.accept", ClickType.LEFT, tport));
            lore.add(ColorTheme.formatInfoTranslation("tport.inventories.itemFactory.toTPortItem.transfer.reject", ClickType.RIGHT, tport));
            FancyClickEvent.addCommand(im, ClickType.LEFT, "tport transfer accept " + pe.getName() + " " + tport.getName());
            FancyClickEvent.addCommand(im, ClickType.RIGHT, "tport transfer reject " + pe.getName() + " " + tport.getName());
        }
        if (attributes.contains((Object)TPortItemAttributes.TRANSFER_OFFERED) && extraData instanceof PlayerEncapsulation) {
            PlayerEncapsulation pe = (PlayerEncapsulation)extraData;
            lore.add(new Message());
            lore.add(ColorTheme.formatInfoTranslation("tport.inventories.itemFactory.toTPortItem.transfer.revoke", ClickType.LEFT, tport));
            FancyClickEvent.addCommand(im, ClickType.LEFT, "tport transfer revoke " + tport.getName());
        }
        if (attributes.contains((Object)TPortItemAttributes.LOG_DATA)) {
            lore.add(new Message());
            lore.add(ColorTheme.formatInfoTranslation("tport.inventories.itemFactory.toTPortItem.logData.isLogged", new Object[0]));
            lore.add(ColorTheme.formatInfoTranslation("tport.inventories.itemFactory.toTPortItem.logData.quickEdit", ClickType.LEFT));
            FancyClickEvent.addFunction(im, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> {
                String innerTPortName = (String)pdc.get(new NamespacedKey((Plugin)Main.getInstance(), "tportName"), PersistentDataType.STRING);
                TPort innerTPort = TPortManager.getTPort(whoClicked.getUniqueId(), innerTPortName);
                if (innerTPort != null) {
                    QuickEditInventories.openTPortLogGUI(whoClicked, innerTPort);
                }
            });
        }
        JsonObject playerLang = Language.getPlayerLang(player.getUniqueId());
        title.translateMessage(playerLang);
        lore = MessageUtils.translateMessage(lore, playerLang);
        is.setItemMeta(im);
        MessageUtils.setCustomItemData(is, theme, title, lore);
        return is;
    }

    protected static ItemStack createBack(Player player, @Nullable BackType left, @Nullable BackType right, @Nullable BackType shiftRight) {
        return ItemFactory.createBack(player, left, right, shiftRight, null);
    }

    protected static ItemStack createBack(Player player, @Nullable BackType left, @Nullable BackType right, @Nullable BackType shiftRight, @Nullable BackType notAllowed) {
        ItemStack is = TPortInventories.back_model.getItem(player);
        if (!Features.Feature.PublicTP.isEnabled()) {
            if (BackType.PUBLIC.equals((Object)left)) {
                left = BackType.BIOME_TP;
            }
            if (BackType.PUBLIC.equals((Object)right)) {
                right = BackType.BIOME_TP;
            }
            if (BackType.PUBLIC.equals((Object)shiftRight)) {
                shiftRight = BackType.BIOME_TP;
            }
        }
        if (!Features.Feature.BiomeTP.isEnabled()) {
            if (BackType.BIOME_TP.equals((Object)left)) {
                left = BackType.FEATURE_TP;
            }
            if (BackType.BIOME_TP.equals((Object)right)) {
                right = BackType.FEATURE_TP;
            }
            if (BackType.BIOME_TP.equals((Object)shiftRight)) {
                shiftRight = BackType.FEATURE_TP;
            }
        }
        if (!Features.Feature.FeatureTP.isEnabled()) {
            if (BackType.FEATURE_TP.equals((Object)left)) {
                left = BackType.WORLD_TP;
            }
            if (BackType.FEATURE_TP.equals((Object)right)) {
                right = BackType.WORLD_TP;
            }
            if (BackType.FEATURE_TP.equals((Object)shiftRight)) {
                shiftRight = BackType.WORLD_TP;
            }
        }
        if (!Features.Feature.WorldTP.isEnabled()) {
            if (Features.Feature.PublicTP.isEnabled()) {
                if (BackType.WORLD_TP.equals((Object)left)) {
                    left = BackType.PUBLIC;
                }
                if (BackType.WORLD_TP.equals((Object)right)) {
                    right = BackType.PUBLIC;
                }
                if (BackType.WORLD_TP.equals((Object)shiftRight)) {
                    shiftRight = BackType.PUBLIC;
                }
            } else {
                if (BackType.WORLD_TP.equals((Object)left)) {
                    left = null;
                }
                if (BackType.WORLD_TP.equals((Object)right)) {
                    right = null;
                }
                if (BackType.WORLD_TP.equals((Object)shiftRight)) {
                    shiftRight = null;
                }
            }
        }
        if (left != null && left.equals((Object)notAllowed)) {
            left = null;
        }
        if (right != null && right.equals((Object)notAllowed)) {
            right = null;
        }
        if (shiftRight != null && shiftRight.equals((Object)notAllowed)) {
            shiftRight = null;
        }
        Message title = ColorTheme.formatTranslation(ColorTheme.ColorType.titleColor, ColorTheme.ColorType.titleColor, "tport.tportInventories.backButton.name", new Object[0]);
        ArrayList lore = new ArrayList();
        if (left != null) {
            lore.add(ColorTheme.formatInfoTranslation("tport.tportInventories.backButton.format.leftClick", ClickType.LEFT));
            lore.add(left.getName());
            lore.add(new Message());
        }
        if (right != null) {
            lore.add(ColorTheme.formatInfoTranslation("tport.tportInventories.backButton.format.rightClick", ClickType.RIGHT));
            lore.add(right.getName());
            lore.add(new Message());
        }
        if (shiftRight != null) {
            lore.add(ColorTheme.formatInfoTranslation("tport.tportInventories.backButton.format.shiftRightClick", ClickType.SHIFT_RIGHT));
            lore.add((Message)shiftRight.getName());
            lore.add(new Message());
        }
        if (!lore.isEmpty()) {
            lore.remove(lore.size() - 1);
        }
        JsonObject playerLang = Language.getPlayerLang(player.getUniqueId());
        title = MessageUtils.translateMessage(title, playerLang);
        lore = (ArrayList)MessageUtils.translateMessage(lore, playerLang);
        ColorTheme theme = ColorTheme.getTheme(player);
        MessageUtils.setCustomItemData(is, theme, title, lore);
        if (left != null) {
            FancyClickEvent.addFunction(is, ClickType.LEFT, left.getFunction());
        }
        if (right != null) {
            FancyClickEvent.addFunction(is, ClickType.RIGHT, right.getFunction());
        }
        if (shiftRight != null) {
            FancyClickEvent.addFunction(is, ClickType.SHIFT_RIGHT, shiftRight.getFunction());
        }
        return is;
    }

    public static List<ItemStack> getPlayerList(Player player, boolean hasOwn, boolean forceHeadsOnly, List<HeadAttributes> headAttributes, List<TPortItemAttributes> tportItemAttributes, @Nullable Object headData) {
        List<ItemStack> list = Sort.getSorter(player).sort(player, headAttributes, headData);
        ItemStack ownHead = null;
        for (ItemStack is : list) {
            SkullMeta skullMeta;
            OfflinePlayer offlinePlayer;
            ItemMeta itemMeta = is.getItemMeta();
            if (!(itemMeta instanceof SkullMeta) || (offlinePlayer = (skullMeta = (SkullMeta)itemMeta).getOwningPlayer()) == null) continue;
            skullMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)Main.getInstance(), "playerName"), PersistentDataType.STRING, (Object)offlinePlayer.getName());
            skullMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)Main.getInstance(), "playerUUID"), PersistentDataType.STRING, (Object)offlinePlayer.getUniqueId().toString());
            is.setItemMeta((ItemMeta)skullMeta);
            if (!skullMeta.getOwningPlayer().getUniqueId().equals(player.getUniqueId())) continue;
            ownHead = is;
        }
        if (ownHead != null) {
            list.remove(ownHead);
            if (hasOwn) {
                list.add(0, ownHead);
            }
        }
        ArrayList<ItemStack> newList = new ArrayList<ItemStack>();
        for (ItemStack is : list) {
            SkullMeta sm;
            ItemMeta itemMeta;
            if (MainLayout.showPlayers(player)) {
                newList.add(is);
            }
            if (forceHeadsOnly || !MainLayout.showTPorts(player) || !((itemMeta = is.getItemMeta()) instanceof SkullMeta) || (sm = (SkullMeta)itemMeta).getOwningPlayer() == null) continue;
            TPortManager.getSortedTPortList(Files.tportData, sm.getOwningPlayer().getUniqueId()).stream().filter(Objects::nonNull).map(tport -> ItemFactory.toTPortItem(tport, player, tportItemAttributes)).forEach(newList::add);
        }
        list = newList;
        return list;
    }

    public static ItemStack getSortingItem(Player player, JsonObject playerLang, ColorTheme theme, FancyClickEvent.FancyClickRunnable invCreator) {
        String nextSort = Sort.getNextSorterName(player);
        ItemStack sorting = (nextSort == null ? TPortInventories.sorting_grayed_model : TPortInventories.sorting_model).getItem(player);
        Message sortingTitle = ColorTheme.formatTranslation(ColorTheme.ColorType.titleColor, ColorTheme.ColorType.titleColor, "tport.tportInventories.openMainGUI.sorting.title", new Object[0]);
        sortingTitle.translateMessage(playerLang);
        Message sortingCurrent = ColorTheme.formatInfoTranslation(playerLang, "tport.tportInventories.openMainGUI.sorting.current", Sort.getSorterForPlayer(player));
        String previousSort = nextSort == null ? null : Sort.getPreviousSorterName(player);
        Message sortingNext = nextSort == null ? null : ColorTheme.formatInfoTranslation(playerLang, "tport.tportInventories.openMainGUI.sorting.next", ClickType.LEFT, nextSort);
        Message sortingPrevious = previousSort == null ? null : ColorTheme.formatInfoTranslation(playerLang, "tport.tportInventories.openMainGUI.sorting.previous", ClickType.RIGHT, previousSort);
        MessageUtils.setCustomItemData(sorting, theme, sortingTitle, Arrays.asList(sortingCurrent, new Message(), sortingNext, sortingPrevious));
        if (nextSort != null) {
            FancyClickEvent.addCommand(sorting, ClickType.LEFT, "tport sort " + nextSort);
            FancyClickEvent.addFunction(sorting, ClickType.LEFT, invCreator);
        }
        if (previousSort != null) {
            FancyClickEvent.addCommand(sorting, ClickType.RIGHT, "tport sort " + previousSort);
            FancyClickEvent.addFunction(sorting, ClickType.RIGHT, invCreator);
        }
        return sorting;
    }

    public static enum HeadAttributes {
        TPORT_AMOUNT,
        CLICK_EVENTS,
        HOME_PLAYER_SELECTION,
        OFFER_TO_PLAYER,
        TPORT_WHITELIST,
        PLTP_WHITELIST,
        TPORT_LOG_SELECTION,
        TPORT_LOG_READ,
        TPORT_LOG_READ_FILTER,
        SELECT_COLOR_THEME,
        REMOVE_PLAYER;

    }

    public static enum TPortItemAttributes {
        ADD_OWNER,
        QUICK_EDITOR,
        CLICK_TO_OPEN,
        CLICK_TO_OPEN_PUBLIC,
        TRANSFER_OFFERS,
        TRANSFER_OFFERED,
        PUBLIC_MOVE_DELETE,
        LOG_DATA,
        SELECT_HOME;

    }

    protected static enum BackType {
        MAIN((whoClicked, clickType, pdc, fancyInventory) -> TPortCommand.executeTPortCommand((CommandSender)whoClicked, "")),
        OWN((whoClicked, clickType, pdc, fancyInventory) -> TPortCommand.executeTPortCommand((CommandSender)whoClicked, "own")),
        PUBLIC((whoClicked, clickType, pdc, fancyInventory) -> TPortCommand.executeTPortCommand((CommandSender)whoClicked, "public")),
        BIOME_TP((whoClicked, clickType, pdc, fancyInventory) -> TPortInventories.openBiomeTP(whoClicked, 0, fancyInventory)),
        FEATURE_TP((whoClicked, clickType, pdc, fancyInventory) -> TPortCommand.executeTPortCommand((CommandSender)whoClicked, "featureTP")),
        WORLD_TP((whoClicked, clickType, pdc, fancyInventory) -> TPortCommand.executeTPortCommand((CommandSender)whoClicked, "world")),
        SETTINGS((whoClicked, clickType, pdc, fancyInventory) -> TPortCommand.executeTPortCommand((CommandSender)whoClicked, "settings")),
        COLOR_THEME((whoClicked, clickType, pdc, fancyInventory) -> TPortCommand.executeTPortCommand((CommandSender)whoClicked, "colorTheme")),
        HOME_SET((whoClicked, clickType, pdc, fancyInventory) -> TPortCommand.executeTPortCommand((CommandSender)whoClicked, "home set")),
        BACKUP((whoClicked, clickType, pdc, fancyInventory) -> TPortCommand.executeTPortCommand((CommandSender)whoClicked, "backup")),
        QUICK_EDIT((whoClicked, clickType, pdc, fancyInventory) -> QuickEditInventories.openQuickEditSelection(whoClicked, 0, fancyInventory.getData(TPort.tportUUIDDataName))),
        TPORT_LOG((whoClicked, clickType, pdc, fancyInventory) -> QuickEditInventories.openTPortLogGUI(whoClicked, fancyInventory.getData(TPort.tportDataName))),
        PUBLIC_TP_SETTINGS((whoClicked, clickType, pdc, fancyInventory) -> SettingsInventories.openPublicTPSettings(whoClicked)),
        LOG_SETTINGS((whoClicked, clickType, pdc, fancyInventory) -> SettingsInventories.openLogGUI(whoClicked)),
        LOG_SETTINGS_READ((whoClicked, clickType, pdc, fancyInventory) -> QuickEditInventories.openTPortLogReadGUI(whoClicked, fancyInventory.getData(TPort.tportDataName), fancyInventory.getData("filterUUID", UUID.class))),
        SEARCH((whoClicked, clickType, pdc, fancyInventory) -> SettingsInventories.openMainSearchGUI(whoClicked, 0)),
        HISTORY((whoClicked, clickType, pdc, fancyInventory) -> TPortInventories.openHistory(whoClicked, fancyInventory.getData(TPortInventories.historyFilterDataName))),
        LANGUAGE((whoClicked, clickType, pdc, fancyInventory) -> SettingsInventories.openLanguageGUI(whoClicked)),
        PLTP((whoClicked, clickType, pdc, fancyInventory) -> SettingsInventories.openPLTPGUI(whoClicked));

        private final FancyClickEvent.FancyClickRunnable onClick;

        private BackType(FancyClickEvent.FancyClickRunnable onClick) {
            this.onClick = onClick;
        }

        public Message getName() {
            return ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfoColor, "tport.tportInventories.backType." + this.name() + ".description", new Object[0]);
        }

        public FancyClickEvent.FancyClickRunnable getFunction() {
            return this.onClick;
        }
    }
}

