/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.history.locationSource;

import com.spaceman.tport.commands.tport.Open;
import com.spaceman.tport.commands.tport.SafetyCheck;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.fancyMessage.inventories.InventoryModel;
import com.spaceman.tport.history.locationSource.LocationSource;
import com.spaceman.tport.inventories.TPortInventories;
import com.spaceman.tport.tport.TPort;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class TPortLocationSource
extends TPortEncapsulation
implements LocationSource {
    public TPortLocationSource(TPort tport) {
        super(tport);
    }

    @Override
    @Nullable
    public Location getLocation(Player player) {
        if (this.tport.canTeleport(player, false, false, false)) {
            return this.tport.getLocation();
        }
        return null;
    }

    @Override
    public void setLocation(Location location) {
    }

    @Override
    public void teleportToLocation(Player player) {
        if (!Open.getInstance().emptyOpenPlayerTPort.hasPermissionToRun(player, true)) {
            return;
        }
        this.tport.teleport(player, false, false, null, "tport.history.locationSource.TPortLocationSource.teleportToLocation.succeeded", "tport.history.locationSource.TPortLocationSource.teleportToLocation.tpRequested");
    }

    @Override
    public void notSafeToTeleport(Player player) {
        ColorTheme.sendErrorTranslation(player, "tport.history.locationSource.TPortLocationSource.notSafeToTeleport", this.tport);
    }

    @Override
    public InventoryModel getInventoryModel() {
        return TPortInventories.history_element_tport_model;
    }

    @Override
    @Nullable
    public String getType() {
        return "TPort";
    }

    @Override
    public boolean getSafetyCheckState(Player player) {
        if (this.tport.getOwner().equals(player.getUniqueId())) {
            return SafetyCheck.SafetyCheckSource.TPORT_OWN.getState(player);
        }
        return SafetyCheck.SafetyCheckSource.TPORT_OPEN.getState(player);
    }
}

