/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.history.locationSource;

import com.spaceman.tport.commands.tport.SafetyCheck;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.fancyMessage.inventories.InventoryModel;
import com.spaceman.tport.fancyMessage.language.Language;
import com.spaceman.tport.history.locationSource.LocationSource;
import com.spaceman.tport.inventories.TPortInventories;
import com.spaceman.tport.tpEvents.TPEManager;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class DeathLocationSource
implements LocationSource {
    private final Location location;

    public DeathLocationSource(Location location) {
        this.location = location;
    }

    @Override
    public String asString() {
        return null;
    }

    @Override
    @Nonnull
    public Message toMessage(String color, String varColor) {
        return new Message(new TextComponent("death", varColor));
    }

    @Override
    @Nullable
    public HoverEvent getHoverEvent() {
        return null;
    }

    @Override
    @Nullable
    public ClickEvent getClickEvent() {
        return null;
    }

    @Override
    @Nullable
    public String getInsertion() {
        return null;
    }

    @Override
    @Nullable
    public Location getLocation(Player player) {
        return this.location;
    }

    @Override
    public void setLocation(Location location) {
    }

    @Override
    public void teleportToLocation(Player player) {
        Message death = ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfoColor, "tport.history.locationSource.DeathLocationSource.teleportToLocation.death", new Object[0]).translateMessage(Language.getPlayerLang(player));
        TPEManager.requestTeleportPlayer(player, this.location, () -> ColorTheme.sendSuccessTranslation(Bukkit.getPlayer((UUID)player.getUniqueId()), "tport.history.locationSource.DeathLocationSource.teleportToLocation.succeeded", death), (p, delay, tickMessage, seconds, secondMessage) -> ColorTheme.sendSuccessTranslation(p, "tport.history.locationSource.DeathLocationSource.teleportToLocation.tpRequested", death, delay, tickMessage, seconds, secondMessage));
    }

    @Override
    public void notSafeToTeleport(Player player) {
        ColorTheme.sendErrorTranslation(player, "tport.history.locationSource.DeathLocationSource.notSafeToTeleport", new Object[0]);
    }

    @Override
    public InventoryModel getInventoryModel() {
        return TPortInventories.history_element_death_model;
    }

    @Override
    @Nullable
    public String getType() {
        return "DeathTP";
    }

    @Override
    public boolean getSafetyCheckState(Player player) {
        return SafetyCheck.SafetyCheckSource.TPORT_BACK.getState(player);
    }
}

