/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.history.locationSource;

import com.spaceman.tport.commands.tport.SafetyCheck;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.fancyMessage.inventories.InventoryModel;
import com.spaceman.tport.history.locationSource.LocationSource;
import com.spaceman.tport.tpEvents.TPEManager;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class CraftLocationSource
implements LocationSource {
    private Location location;
    private String type = null;

    public CraftLocationSource() {
    }

    public CraftLocationSource(Location location) {
        this.setLocation(location);
    }

    public CraftLocationSource(Location location, @Nullable String type) {
        this.setLocation(location);
        this.type = type;
    }

    @Override
    @Nonnull
    public Message toMessage(String color, String varColor) {
        return ColorTheme.formatTranslation(color, varColor, "tport.history.craftLocationSource.getName", this.location.getWorld().getName(), this.location.getBlockX(), this.location.getBlockY(), this.location.getBlockZ(), (double)Math.round(this.location.getX() * 10.0) / 10.0, (double)Math.round(this.location.getY() * 10.0) / 10.0, (double)Math.round(this.location.getZ() * 10.0) / 10.0);
    }

    @Override
    @Nullable
    public HoverEvent getHoverEvent() {
        return null;
    }

    @Override
    @Nullable
    public ClickEvent getClickEvent() {
        return null;
    }

    @Override
    @Nullable
    public String getInsertion() {
        return null;
    }

    @Override
    public String asString() {
        return null;
    }

    @Override
    @Nullable
    public Location getLocation(Player player) {
        return this.location;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public void teleportToLocation(Player player) {
        TPEManager.requestTeleportPlayer(player, this.location, () -> ColorTheme.sendSuccessTranslation(Bukkit.getPlayer((UUID)player.getUniqueId()), "tport.history.locationSource.CraftLocationSource.teleportToLocation.succeeded", new Object[0]), (p, delay, tickMessage, seconds, secondMessage) -> ColorTheme.sendSuccessTranslation(p, "tport.history.locationSource.CraftLocationSource.teleportToLocation.tpRequested", "null", delay, tickMessage, seconds, secondMessage));
    }

    @Override
    public void notSafeToTeleport(Player player) {
        ColorTheme.sendErrorTranslation(player, "tport.history.locationSource.CraftLocationSource.notSafeToTeleport", new Object[0]);
    }

    @Override
    public InventoryModel getInventoryModel() {
        return null;
    }

    @Override
    @Nullable
    public String getType() {
        return this.type;
    }

    @Override
    public boolean getSafetyCheckState(Player player) {
        return SafetyCheck.SafetyCheckSource.TPORT_BACK.getState(player);
    }
}

