/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.fancyMessage.language.subCommands;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.language.Language;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.entity.Player;

public class Set
extends SubCommand {
    public Set() {
        EmptyCommand emptySetCustom = new EmptyCommand();
        emptySetCustom.setCommandName("custom", ArgumentType.FIXED);
        emptySetCustom.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.language.set.custom.commandDescription", new Object[0]));
        EmptyCommand emptySetServer = new EmptyCommand();
        emptySetServer.setCommandName("server", ArgumentType.FIXED);
        emptySetServer.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.language.set.server.commandDescription", new Object[0]));
        EmptyCommand emptySetServerLanguage = new EmptyCommand();
        emptySetServerLanguage.setCommandName("language", ArgumentType.REQUIRED);
        emptySetServerLanguage.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.language.set.language.commandDescription", new Object[0]));
        this.addAction(emptySetCustom);
        this.addAction(emptySetServer);
        this.addAction(emptySetServerLanguage);
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        ArrayList<String> list = new ArrayList<String>(Language.getAvailableLang());
        list.add("custom");
        list.add("server");
        return list;
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 3) {
            if (args[2].equalsIgnoreCase("custom")) {
                ColorTheme.sendSuccessTranslation(player, "tport.command.language.set.custom.succeeded", "custom", "/tport help language");
                Language.setPlayerLang(player.getUniqueId(), "custom");
            } else if (args[2].equalsIgnoreCase("server")) {
                Language.setPlayerLang(player.getUniqueId(), "server");
                ColorTheme.sendSuccessTranslation(player, "tport.command.language.set.server.succeeded", "server");
            } else {
                String currentLang = Language.getPlayerLangName(player.getUniqueId());
                if (currentLang.equals(args[2])) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.language.set.language.alreadySet", currentLang);
                    return;
                }
                if (Language.getAvailableLang().stream().noneMatch(args[2]::equals)) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.language.set.language.languageNotExist", args[2]);
                    return;
                }
                if (Language.setPlayerLang(player.getUniqueId(), args[2])) {
                    ColorTheme.sendSuccessTranslation(player, "tport.command.language.set.language.succeeded", args[2]);
                } else {
                    ColorTheme.sendErrorTranslation(player, "tport.command.language.set.language.languageNotExist", args[2]);
                }
            }
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport language set <custom|server|<language>>");
        }
    }
}

