/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.fancyMessage.language;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.spaceman.tport.Main;
import com.spaceman.tport.Pair;
import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commandHandler.CommandTemplate;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.language.subCommands.Get;
import com.spaceman.tport.fancyMessage.language.subCommands.Repair;
import com.spaceman.tport.fancyMessage.language.subCommands.Server;
import com.spaceman.tport.fancyMessage.language.subCommands.Set;
import com.spaceman.tport.fancyMessage.language.subCommands.Test;
import com.spaceman.tport.fileHander.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FilenameUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Language
extends SubCommand {
    private static HashMap<String, JsonObject> languages = new HashMap();

    public static boolean setServerLang(String lang) {
        if (languages.containsKey(lang)) {
            Files.tportConfig.getConfig().set("language.server", (Object)lang);
            Files.tportConfig.saveConfig();
            return true;
        }
        return false;
    }

    public static String getServerLangName() {
        String name = Files.tportConfig.getConfig().getString("language.server", "en_us.json");
        if (!languages.containsKey(name)) {
            name = "en_us.json";
        }
        return name;
    }

    public static JsonObject getServerLang() {
        return languages.get(Language.getServerLangName());
    }

    public static boolean setPlayerLang(UUID uuid, @Nonnull String lang) {
        if (!(lang.equalsIgnoreCase("custom") || lang.equalsIgnoreCase("server") || languages.containsKey(lang))) {
            return false;
        }
        Files.tportConfig.getConfig().set("language.players." + uuid.toString(), (Object)lang);
        Files.tportConfig.saveConfig();
        TPortAdvancement.Advancement_Que.grant(Bukkit.getPlayer((UUID)uuid));
        return true;
    }

    public static String getPlayerLangName(UUID uuid) {
        String lang = Files.tportConfig.getConfig().getString("language.players." + uuid.toString(), "server");
        if (!languages.containsKey(lang)) {
            if (lang.equals("custom") || lang.equals("server")) {
                return lang;
            }
            Language.setPlayerLang(uuid, "en_us.json");
            return "en_us.json";
        }
        return lang;
    }

    @Nullable
    public static JsonObject getPlayerLang(Player player) {
        return Language.getPlayerLang(player.getUniqueId());
    }

    @Nullable
    public static JsonObject getPlayerLang(UUID uuid) {
        String playerLang = Language.getPlayerLangName(uuid);
        if (playerLang.equals("server")) {
            return Language.getServerLang();
        }
        if (playerLang.equals("custom")) {
            return null;
        }
        return languages.get(playerLang);
    }

    @Nullable
    public static JsonObject getLang(String langName) {
        return languages.get(langName);
    }

    public static void loadLanguages() {
        languages = new HashMap();
        InputStream en_us_resource = Main.getInstance().getResource("lang/en_us.json");
        JsonObject defaultEN_US = (JsonObject)JsonParser.parseReader((Reader)new InputStreamReader(en_us_resource, StandardCharsets.UTF_8));
        languages.put("en_us.json", defaultEN_US);
        File langDir = Language.getLangDir();
        try {
            File langFile = new File(langDir, "en_us.json");
            langDir.mkdir();
            langFile.createNewFile();
            Language.saveLanguage(defaultEN_US, langFile);
        }
        catch (IOException ignore) {
            Main.getInstance().getLogger().log(Level.WARNING, "Could not update 'lang/en_us.json'");
        }
        File[] files = langDir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isFile() && !f.getName().contains(" ")) {
                    try {
                        String fileType = FilenameUtils.getExtension((String)f.getName());
                        if (fileType.equalsIgnoreCase("json")) {
                            Main.getInstance().getLogger().log(Level.INFO, "Loading language " + f.getName());
                            Pair<JsonObject, Integer> json = Language.loadLanguage(f);
                            if (json != null) {
                                languages.putIfAbsent(f.getName(), json.getLeft());
                                if (json.getRight() == 1) {
                                    Main.getInstance().getLogger().log(Level.INFO, String.format("Repaired language %s internally, missing %s item", f.getName(), 1));
                                }
                                if (json.getRight() <= 1) continue;
                                Main.getInstance().getLogger().log(Level.INFO, String.format("Repaired language %s internally, missing %s items", f.getName(), json.getRight()));
                                continue;
                            }
                            Main.getInstance().getLogger().log(Level.WARNING, "Could not load language " + f.getName());
                            continue;
                        }
                        Main.getInstance().getLogger().log(Level.WARNING, "Language files must be a JSON file type, found '" + fileType + "' in file " + f.getName());
                    }
                    catch (IllegalArgumentException ignore) {
                        Main.getInstance().getLogger().log(Level.WARNING, "Could not load language " + f.getName());
                    }
                    continue;
                }
                Main.getInstance().getLogger().log(Level.WARNING, "Language files can not contain any spaces, error in file " + f.getName());
            }
        } else {
            Main.getInstance().getLogger().log(Level.WARNING, "Could not read files in the 'lang' directory");
        }
    }

    public static File getLangDir() {
        return new File(Main.getInstance().getDataFolder(), "lang");
    }

    public static void saveLanguage(JsonObject json, File langFile) {
        try {
            FileWriter fileWriter = new FileWriter(langFile);
            try {
                fileWriter.write(json.toString());
            }
            finally {
                fileWriter.flush();
                fileWriter.close();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static Pair<JsonObject, Integer> repairLanguage(JsonObject language, @Nullable JsonObject repairWith) {
        return Language.repairLanguage(language, repairWith, false);
    }

    public static Pair<JsonObject, Integer> repairLanguage(JsonObject language, @Nullable JsonObject repairWith, boolean dump) {
        if (repairWith == null) {
            return null;
        }
        if (dump) {
            Main.getInstance().getLogger().log(Level.INFO, "Repairing language, missing ID's:");
        }
        var ref = new Object(){
            int amountRepaired = 0;
        };
        repairWith.keySet().forEach(id -> {
            if (!language.has(id)) {
                language.add(id, repairWith.get(id));
                ++ref.amountRepaired;
                if (dump) {
                    Main.getInstance().getLogger().log(Level.INFO, (String)id);
                }
            }
        });
        if (dump && ref.amountRepaired == 0) {
            Main.getInstance().getLogger().log(Level.INFO, "No missing ID's");
        }
        return new Pair<JsonObject, Integer>(language, ref.amountRepaired);
    }

    public static Pair<JsonObject, Integer> loadLanguage(File langFile) {
        try {
            JsonObject oldJSON = (JsonObject)JsonParser.parseReader((Reader)new FileReader(langFile));
            return Language.repairLanguage(oldJSON, languages.get("en_us.json"));
        }
        catch (JsonParseException | FileNotFoundException throwable) {
            return null;
        }
    }

    public static Collection<String> getAvailableLang() {
        return languages.keySet();
    }

    public Language() {
        this.addAction(new Server());
        this.addAction(new Get());
        this.addAction(new Set());
        this.addAction(new Test());
        this.addAction(new Repair());
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length > 1 && CommandTemplate.runCommands(this.getActions(), args[1], args, player)) {
            return;
        }
        ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport language " + CommandTemplate.convertToArgs(this.getActions(), false));
    }
}

