/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.fancyMessage.inventories;

import com.spaceman.tport.commands.tport.ResourcePack;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class InventoryModel {
    private final Material material;
    private String subDir = "";
    private final int customModelData;
    private NamespacedKey namespacedKey;

    public InventoryModel(Material material, int customModelData, String nameSpace, String key) {
        this.material = material;
        this.customModelData = customModelData;
        this.createNameSpaceKey(nameSpace, key);
    }

    public InventoryModel(Material material, InventoryModel previousModel, String nameSpace, String key) {
        this.material = material;
        this.customModelData = previousModel.getCustomModelData() + 1;
        this.createNameSpaceKey(nameSpace, key);
    }

    public InventoryModel(Material material, int customModelData, String nameSpace, String key, String subDir) {
        this.material = material;
        this.customModelData = customModelData;
        this.createNameSpaceKey(nameSpace, key);
        this.subDir = subDir;
    }

    public InventoryModel(Material material, InventoryModel previousModel, String nameSpace, String key, String subDir) {
        this.material = material;
        this.customModelData = previousModel.getCustomModelData() + 1;
        this.createNameSpaceKey(nameSpace, key);
        this.subDir = subDir;
    }

    private void createNameSpaceKey(String nameSpace, String key) {
        this.namespacedKey = NamespacedKey.fromString((String)(nameSpace + ":" + key).toLowerCase());
    }

    public ItemStack getItem(Player player) {
        return this.getItem(player.getUniqueId());
    }

    public ItemStack getItem(UUID playerUUID) {
        ItemStack item = new ItemStack(this.material);
        this.applyModelData(item, this, playerUUID);
        return item;
    }

    public ItemStack setItem(Player player, ItemStack is) {
        this.applyModelData(is, this, player);
        return is;
    }

    public NamespacedKey getNamespacedKey() {
        return this.namespacedKey;
    }

    public Material getMaterial() {
        return this.material;
    }

    public int getCustomModelData() {
        return this.customModelData;
    }

    public boolean hasSubDir() {
        return !this.subDir.isEmpty();
    }

    public String getSubDir() {
        return this.subDir;
    }

    public String getName() {
        return this.namespacedKey.getKey();
    }

    private ItemStack applyModelData(ItemStack is, InventoryModel modelData, Player player) {
        return this.applyModelData(is, modelData, player.getUniqueId());
    }

    private ItemStack applyModelData(ItemStack is, InventoryModel modelData, UUID uuid) {
        if (!ResourcePack.getResourcePackState(uuid)) {
            return is;
        }
        if (!is.getType().equals((Object)modelData.getMaterial())) {
            throw new IllegalArgumentException("Type of item stack is not the same as the model data: " + is.getType().name() + ", {" + String.valueOf(modelData.getMaterial()) + "}");
        }
        ItemMeta im = is.getItemMeta();
        if (im == null) {
            return is;
        }
        try {
            im.setCustomModelData(Integer.valueOf(modelData.getCustomModelData()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            im.setItemModel(this.namespacedKey);
        }
        catch (Exception exception) {
            // empty catch block
        }
        is.setItemMeta(im);
        return is;
    }
}

