/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.fancyMessage.inventories;

import com.google.gson.JsonObject;
import com.spaceman.tport.Main;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.MessageUtils;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.inventories.FancyClickEvent;
import com.spaceman.tport.fancyMessage.inventories.InventoryModel;
import com.spaceman.tport.fancyMessage.language.Language;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class FancyInventory
implements InventoryHolder {
    public static final InventoryModel next_model = new InventoryModel(Material.HOPPER, 5145462, "tport", "next", "navigation");
    public static final InventoryModel previous_model = new InventoryModel(Material.FERN, 5145463, "tport", "previous", "navigation");
    public static final DataName<Integer> pageDataName = new DataName<Integer>("page", Integer.class, 0);
    public static final DataName<Integer> totalPagesDataName = new DataName<Integer>("totalPages", Integer.class, 0);
    public static final DataName<Integer> rowsDataName = new DataName<Integer>("rows", Integer.class, 3);
    public static final DataName<InventoryCreator> invCreatorDataName = new DataName<InventoryCreator>("invCreator", InventoryCreator.class);
    private final HashMap<String, Object> holderData;
    private Inventory inventory;
    private Message title;

    public FancyInventory(int size, Message title) {
        if (size > 0 && size < 7) {
            size *= 9;
        } else if (9 > size || size > 54 || size % 9 != 0) {
            size = 54;
        }
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)size, (String)title.toString());
        this.title = title;
        this.holderData = new HashMap();
    }

    public void setData(String dataName, Object data) {
        this.holderData.put(dataName, data);
    }

    public Object getData(String dataName) {
        return this.holderData.getOrDefault(dataName, null);
    }

    public <T> T getData(String dataName, Class<T> clazz) {
        return this.getData(dataName, clazz, null);
    }

    public <T> T getData(String dataName, Class<T> clazz, T def) {
        if (this.holderData.containsKey(dataName)) {
            Object data = this.holderData.get(dataName);
            return (T)(clazz.isInstance(data) ? data : null);
        }
        return def;
    }

    public boolean hasData(String dataName) {
        return this.holderData.containsKey(dataName);
    }

    public boolean isDataType(String dataName, Class<?> classType) {
        return this.holderData.get(dataName).getClass().equals(classType);
    }

    public Object getRawData(String dataName) {
        return this.holderData.get(dataName);
    }

    public <C> void setData(DataName<C> dataName, C data) {
        if (dataName.getClazz().isInstance(data) || data == null) {
            this.setData(dataName.getDataName(), data);
        }
    }

    public <C> C getData(DataName<C> dataName) {
        return this.getData(dataName, dataName.getDefault());
    }

    public <C> C getData(DataName<C> dataName, C def) {
        return this.getData(dataName.getDataName(), dataName.getClazz(), def);
    }

    public <C> boolean hasData(DataName<C> dataName) {
        Object o = this.holderData.getOrDefault(dataName.getDataName(), null);
        return dataName.getClazz().isInstance(o);
    }

    public void transferData(FancyInventory prevWindow) {
        this.holderData.putAll(prevWindow.holderData);
    }

    public void transferData(FancyInventory prevWindow, boolean overwrite) {
        if (overwrite) {
            this.transferData(prevWindow);
        } else {
            for (Map.Entry<String, Object> s : prevWindow.holderData.entrySet()) {
                if (this.hasData(s.getKey())) continue;
                this.setData(s.getKey(), s.getValue());
            }
        }
    }

    public <C> Object removeData(DataName<C> dataName) {
        return this.holderData.remove(dataName.getDataName());
    }

    public Object removeData(String dataName) {
        return this.holderData.remove(dataName);
    }

    public void removeData(FancyInventory inventory) {
        for (Map.Entry<String, Object> entry : inventory.holderData.entrySet()) {
            this.removeData(entry.getKey());
        }
    }

    public int getSize() {
        return this.inventory.getSize();
    }

    public void setItem(int index, @Nullable ItemStack item) {
        this.inventory.setItem(index, item);
    }

    public ItemStack getItem(int index) {
        return this.inventory.getItem(index);
    }

    public HashMap<Integer, ItemStack> addItem(ItemStack ... itemStack) {
        return this.inventory.addItem(itemStack);
    }

    public void setOriginalContent() {
        this.setData("originalContent", this.inventory.getContents());
    }

    public static void ensureOriginalContent(Player player) {
        FancyInventory.ensureOriginalContent(player, player.getOpenInventory().getTopInventory());
    }

    public static void ensureOriginalContent(Player player, Inventory inv) {
        InventoryHolder inventoryHolder = inv.getHolder();
        if (inventoryHolder instanceof FancyInventory) {
            FancyInventory fancyInventory = (FancyInventory)inventoryHolder;
            List<ItemStack> originalContent = Arrays.asList(fancyInventory.getData("originalContent", ItemStack[].class, new ItemStack[0]));
            for (ItemStack item : inv.getContents()) {
                if (originalContent.contains(item)) continue;
                Main.giveItems(player, item);
            }
        }
    }

    public void open(Player player) {
        this.setOriginalContent();
        FancyInventory.ensureOriginalContent(player);
        ColorTheme theme = ColorTheme.getTheme(player);
        try {
            this.title = MessageUtils.translateMessage(this.title, Language.getPlayerLang(player.getUniqueId()));
            Main.getInstance().adapter.sendInventory(player, this.title.translateJSON(theme), this.inventory);
        }
        catch (Throwable ex) {
            Features.Feature.printSmallNMSErrorInConsole("Fancy inventory titles", true);
            if (Features.Feature.PrintErrorsInConsole.isEnabled()) {
                ex.printStackTrace();
            }
            JsonObject serverLang = Language.getServerLang();
            Inventory placeholder = Bukkit.createInventory((InventoryHolder)this, (int)this.inventory.getSize(), (String)this.title.translateMessage(serverLang).toColoredString(theme));
            placeholder.setStorageContents(this.inventory.getStorageContents());
            player.openInventory(placeholder);
        }
    }

    public void setTitle(Message title) {
        this.title = title;
    }

    public Message getTitle() {
        return this.title;
    }

    public FancyInventory setInventory(Inventory inventory) {
        this.inventory = inventory;
        return this;
    }

    @Nonnull
    public Inventory getInventory() {
        return this.inventory;
    }

    public static void openDynamicScrollableInventory(Player player, int page, InventoryCreator invCreator, String titleID, List<ItemStack> items, @Nullable ItemStack backButton) {
        FancyInventory.getDynamicScrollableInventory(player, page, invCreator, titleID, items, backButton).open(player);
    }

    public static FancyInventory getDynamicScrollableInventory(Player player, int page, InventoryCreator invCreator, String titleID, List<ItemStack> items, @Nullable ItemStack backButton) {
        return FancyInventory.getDynamicScrollableInventory(player, page, invCreator, titleID, items, backButton, 27);
    }

    public static FancyInventory getDynamicScrollableInventory(Player player, int page, InventoryCreator invCreator, Message title, List<ItemStack> items, @Nullable ItemStack backButton) {
        return FancyInventory.getDynamicScrollableInventory(player, page, invCreator, title, items, backButton, 27);
    }

    public static FancyInventory getDynamicScrollableInventory(Player player, int page, InventoryCreator invCreator, String titleID, List<ItemStack> items, @Nullable ItemStack backButton, int minSize) {
        return FancyInventory.getDynamicScrollableInventory(player, page, invCreator, ColorTheme.formatInfoTranslation(titleID, new Object[0]), items, backButton, minSize);
    }

    public static FancyInventory getDynamicScrollableInventory(Player player, int page, InventoryCreator invCreator, Message title, List<ItemStack> items, @Nullable ItemStack backButton, int minSize) {
        ItemMeta im;
        ColorTheme theme = ColorTheme.getTheme(player);
        JsonObject playerLang = Language.getPlayerLang(player.getUniqueId());
        int rows = 3;
        int width = 7;
        int skipPerPage = 7;
        int maxPages = 1;
        int size = items.size();
        if (size > rows * width) {
            maxPages = size / width - rows + (size % width == 0 ? 0 : 1) + 1;
            page = Math.min(maxPages - 1, page);
        } else {
            page = 0;
        }
        page = Math.max(0, page);
        size += width - (size - 1) % width;
        if ((size /= width) > rows) {
            size -= size - rows;
        }
        size *= 9;
        size += 18;
        size = Math.max(size, minSize);
        if (maxPages != 1) {
            Message m = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.fancyInventory.getDynamicScrollableInventory.page", page + 1, maxPages);
            title.addMessage(m);
        }
        FancyInventory inv = new FancyInventory(size, title);
        inv.setData(pageDataName, page);
        inv.setData(totalPagesDataName, items.size() / width - rows + (items.size() % width == 0 ? 0 : 1));
        inv.setData(rowsDataName, rows);
        inv.setData(invCreatorDataName, invCreator);
        int startIndex = page * skipPerPage;
        int slot = 9 + (9 - width) / 2;
        for (int index = startIndex; index < startIndex + width * rows && index < items.size(); ++index) {
            if ((slot + 1) % 9 == 0) {
                slot += 9 - width;
            }
            if (slot >= size - 9) break;
            inv.setItem(slot, items.get(index));
            ++slot;
        }
        if (backButton != null) {
            inv.setItem(size / 18 * 9 + 8, backButton);
        }
        if ((page + rows) * width < items.size()) {
            ItemStack is = next_model.getItem(player);
            Message nextTitle = ColorTheme.formatTranslation(ColorTheme.ColorType.titleColor, ColorTheme.ColorType.titleColor, "tport.fancyMessage.inventories.fancyInventory.getDynamicScrollableInventory.next.title", new Object[0]).translateMessage(playerLang);
            Message next1 = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.fancyInventory.getDynamicScrollableInventory.next.+1", ClickType.LEFT, "+1");
            Message nextRow = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.fancyInventory.getDynamicScrollableInventory.next.+row", ClickType.RIGHT, "+" + rows);
            Message nextEnd = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.fancyInventory.getDynamicScrollableInventory.next.end", ClickType.SHIFT_RIGHT);
            MessageUtils.setCustomItemData(is, theme, nextTitle, Arrays.asList(next1, nextRow, nextEnd));
            im = is.getItemMeta();
            FancyClickEvent.addFunction(im, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> fancyInventory.getData(invCreatorDataName).openInventory(whoClicked, fancyInventory.getData(pageDataName) + 1, fancyInventory));
            FancyClickEvent.addFunction(im, ClickType.RIGHT, (whoClicked, clickType, pdc, fancyInventory) -> fancyInventory.getData(invCreatorDataName).openInventory(whoClicked, fancyInventory.getData(pageDataName) + fancyInventory.getData(rowsDataName), fancyInventory));
            FancyClickEvent.addFunction(im, ClickType.SHIFT_RIGHT, (whoClicked, clickType, pdc, fancyInventory) -> fancyInventory.getData(invCreatorDataName).openInventory(whoClicked, fancyInventory.getData(totalPagesDataName), fancyInventory));
            is.setItemMeta(im);
            inv.setItem(size - 1, is);
        }
        if (page != 0) {
            ItemStack is = previous_model.getItem(player);
            Message previousTitle = ColorTheme.formatTranslation(ColorTheme.ColorType.titleColor, ColorTheme.ColorType.titleColor, "tport.fancyMessage.inventories.fancyInventory.getDynamicScrollableInventory.previous.title", new Object[0]).translateMessage(playerLang);
            Message previous1 = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.fancyInventory.getDynamicScrollableInventory.previous.-1", ClickType.LEFT, "-1");
            Message previousRow = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.fancyInventory.getDynamicScrollableInventory.previous.-row", ClickType.RIGHT, "-" + rows);
            Message previousBegin = ColorTheme.formatInfoTranslation(playerLang, "tport.fancyMessage.inventories.fancyInventory.getDynamicScrollableInventory.previous.begin", ClickType.SHIFT_RIGHT);
            MessageUtils.setCustomItemData(is, theme, previousTitle, Arrays.asList(previous1, previousRow, previousBegin));
            im = is.getItemMeta();
            FancyClickEvent.addFunction(im, ClickType.LEFT, (whoClicked, clickType, pdc, fancyInventory) -> fancyInventory.getData(invCreatorDataName).openInventory(whoClicked, fancyInventory.getData(pageDataName) - 1, fancyInventory));
            FancyClickEvent.addFunction(im, ClickType.RIGHT, (whoClicked, clickType, pdc, fancyInventory) -> fancyInventory.getData(invCreatorDataName).openInventory(whoClicked, fancyInventory.getData(pageDataName) - fancyInventory.getData(rowsDataName), fancyInventory));
            FancyClickEvent.addFunction(im, ClickType.SHIFT_RIGHT, (whoClicked, clickType, pdc, fancyInventory) -> fancyInventory.getData(invCreatorDataName).openInventory(whoClicked, 0, fancyInventory));
            is.setItemMeta(im);
            inv.setItem(8, is);
        }
        return inv;
    }

    public static class DataName<C> {
        private final String dataName;
        private final Class<C> clazz;
        private final C def;

        public DataName(String dataName, Class<C> clazz) {
            this.dataName = dataName;
            this.clazz = clazz;
            this.def = null;
        }

        public DataName(String dataName, Class<C> clazz, @Nullable C def) {
            this.dataName = dataName;
            this.clazz = clazz;
            this.def = def;
        }

        public String getDataName() {
            return this.dataName;
        }

        public Class<C> getClazz() {
            return this.clazz;
        }

        public C getDefault() {
            return this.def;
        }
    }

    @FunctionalInterface
    public static interface InventoryCreator {
        public void openInventory(Player var1, int var2, FancyInventory var3);
    }
}

