/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.fancyMessage.encapsulation;

import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.Encapsulation;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;

public class PluginEncapsulation
implements Encapsulation {
    private final String plugin;

    public PluginEncapsulation(String plugin) {
        if (plugin == null) {
            plugin = "null";
        }
        this.plugin = plugin;
    }

    @Override
    public String asString() {
        return this.plugin;
    }

    @Override
    @Nonnull
    public Message toMessage(String color, String varColor) {
        return new Message(new TextComponent(this.asString(), varColor));
    }

    @Override
    public HoverEvent getHoverEvent() {
        Message hoverMessage = new Message();
        if (this.plugin.equals("null")) {
            return null;
        }
        Plugin p = Bukkit.getPluginManager().getPlugin(this.plugin);
        if (p == null) {
            return null;
        }
        PluginDescriptionFile descriptionFile = p.getDescription();
        hoverMessage.addMessage(ColorTheme.formatInfoTranslation("tport.fancyMessage.encapsulation.pluginEncapsulation.name", descriptionFile.getName()));
        hoverMessage.addMessage(new Message("\n"));
        hoverMessage.addMessage(ColorTheme.formatInfoTranslation("tport.fancyMessage.encapsulation.pluginEncapsulation.version", descriptionFile.getVersion()));
        List authors = descriptionFile.getAuthors();
        if (authors.size() == 1) {
            hoverMessage.addMessage(new Message("\n"));
            hoverMessage.addMessage(ColorTheme.formatInfoTranslation("tport.fancyMessage.encapsulation.pluginEncapsulation.author", descriptionFile.getAuthors().get(0)));
        } else {
            hoverMessage.addMessage(new Message("\n"));
            hoverMessage.addMessage(ColorTheme.formatInfoTranslation("tport.fancyMessage.encapsulation.pluginEncapsulation.authors", String.join((CharSequence)", ", descriptionFile.getAuthors())));
        }
        if (descriptionFile.getWebsite() != null) {
            hoverMessage.addMessage(new Message("\n"));
            hoverMessage.addMessage(ColorTheme.formatInfoTranslation("tport.fancyMessage.encapsulation.pluginEncapsulation.website", descriptionFile.getWebsite()));
        }
        if (descriptionFile.getDescription() != null) {
            hoverMessage.addMessage(new Message("\n"));
            hoverMessage.addMessage(ColorTheme.formatInfoTranslation("tport.fancyMessage.encapsulation.pluginEncapsulation.description", descriptionFile.getDescription()));
        }
        return new HoverEvent(hoverMessage);
    }

    @Override
    @Nullable
    public ClickEvent getClickEvent() {
        return null;
    }

    @Override
    @Nullable
    public String getInsertion() {
        return this.asString();
    }
}

