/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.fancyMessage.encapsulation;

import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.TextType;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.Encapsulation;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import javax.annotation.Nonnull;

public class BiomeEncapsulation
implements Encapsulation {
    protected final String biome;

    public BiomeEncapsulation(String biome) {
        this.biome = biome.toLowerCase();
    }

    @Override
    public String asString() {
        return this.biome;
    }

    @Override
    @Nonnull
    public Message toMessage(String color, String varColor) {
        if (this.biome.equals("random")) {
            return new Message(new TextComponent("biome.minecraft.random", varColor).setType(TextType.TRANSLATE));
        }
        return new Message(new TextComponent("biome.minecraft." + this.biome, varColor).setType(TextType.TRANSLATE).ignoreTranslator(true));
    }

    @Override
    public HoverEvent getHoverEvent() {
        if (this.biome.equals("random")) {
            return HoverEvent.hoverEvent("/tport biomeTP random", ColorTheme.ColorType.infoColor);
        }
        return HoverEvent.hoverEvent("/tport biomeTP whitelist " + this.biome, ColorTheme.ColorType.infoColor);
    }

    @Override
    public ClickEvent getClickEvent() {
        if (this.biome.equals("random")) {
            return ClickEvent.runCommand("/tport biomeTP random");
        }
        return ClickEvent.runCommand("/tport biomeTP whitelist " + this.biome);
    }

    @Override
    public String getInsertion() {
        return this.biome;
    }
}

