/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.fancyMessage.colorTheme;

import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.CommandTemplate;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.colorTheme.MultiColor;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.inventories.SettingsInventories;
import com.spaceman.tport.playerUUID.PlayerUUID;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class ColorThemeCommand
extends SubCommand {
    public ColorThemeCommand() {
        EmptyCommand empty = new EmptyCommand(){

            @Override
            public String getName(String argument) {
                return "";
            }
        };
        empty.setCommandName("");
        empty.setCommandDescription(ColorTheme.formatInfoTranslation("tport.colorTheme.commandDescription", new Object[0]));
        EmptyCommand emptySetTypeChat = new EmptyCommand();
        emptySetTypeChat.setCommandName("chat color", ArgumentType.REQUIRED);
        emptySetTypeChat.setCommandDescription(ColorTheme.formatInfoTranslation("tport.colorTheme.set.type.chat.commandDescription", new Object[0]));
        EmptyCommand emptySetTypeHex = new EmptyCommand();
        emptySetTypeHex.setCommandName("hex color", ArgumentType.REQUIRED);
        emptySetTypeHex.setCommandDescription(ColorTheme.formatInfoTranslation("tport.colorTheme.set.type.hex.commandDescription", new Object[0]));
        EmptyCommand emptySetType = new EmptyCommand(){

            @Override
            public String getName(String argument) {
                if (Arrays.stream(ColorTheme.ColorType.values()).anyMatch(type -> type.name().equalsIgnoreCase(argument))) {
                    return argument;
                }
                return "";
            }
        };
        emptySetType.setCommandName("type", ArgumentType.REQUIRED);
        emptySetType.setTabRunnable((args, player) -> {
            if (args[3].startsWith("#")) {
                return args[3].length() < 8 ? Collections.singletonList(args[3] + "#ffffff".substring(args[3].length(), 7)) : Collections.singletonList(args[3].substring(0, 7));
            }
            List list = Arrays.stream(ChatColor.values()).map(Enum::name).collect(Collectors.toList());
            list.add("#ffffff");
            list.add("#000000");
            list.add("#");
            return list;
        });
        emptySetType.setRunnable((args, player) -> {
            if (args.length != 4) {
                ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport colorTheme set <type> <chat color|hex color>");
                return;
            }
            if (!ColorTheme.ColorType.getTypes().contains(args[2])) {
                ColorTheme.sendErrorTranslation(player, "tport.colorTheme.set.type.colorTypeNotFound", args[2]);
                return;
            }
            if (Arrays.stream(ChatColor.values()).map(Enum::name).anyMatch(c -> c.equalsIgnoreCase(args[3]))) {
                ColorTheme.ColorType.valueOf(args[2]).setColor(player, new MultiColor(ChatColor.valueOf((String)args[3].toUpperCase())));
                Message message = ColorTheme.formatTranslation(ColorTheme.ColorType.valueOf(args[2]), ColorTheme.ColorType.varInfo2Color, "tport.colorTheme.this", new Object[0]);
                message.getText().forEach(t -> t.setInsertion(ColorTheme.ColorType.valueOf(args[2]).getColor(player).getColorAsValue()));
                ColorTheme.sendSuccessTranslation(player, "tport.colorTheme.set.type.chat.succeeded", ColorTheme.ColorType.valueOf(args[2]).name(), message);
                TPortAdvancement.Advancement_PrettyColors.grant(player);
            } else if (args[3].matches("#[0-9a-fA-F]{6}")) {
                ColorTheme.ColorType.valueOf(args[2]).setColor(player, new MultiColor(args[3]));
                Message message = ColorTheme.formatTranslation(ColorTheme.ColorType.valueOf(args[2]), ColorTheme.ColorType.varInfo2Color, "tport.colorTheme.this", new Object[0]);
                message.getText().forEach(t -> t.setInsertion(ColorTheme.ColorType.valueOf(args[2]).getColor(player).getColorAsValue()));
                ColorTheme.sendSuccessTranslation(player, "tport.colorTheme.set.type.hex.succeeded", ColorTheme.ColorType.valueOf(args[2]).name(), message);
                TPortAdvancement.Advancement_PrettyColors.grant(player);
            } else {
                ColorTheme.sendErrorTranslation(player, "tport.colorTheme.set.type.colorNotFound", args[3]);
            }
        });
        emptySetType.addAction(emptySetTypeChat);
        emptySetType.addAction(emptySetTypeHex);
        EmptyCommand emptySetTheme = new EmptyCommand(){

            @Override
            public String getName(String argument) {
                if (ColorTheme.getDefaultThemes().contains(argument)) {
                    return argument;
                }
                return "";
            }
        };
        emptySetTheme.setCommandName("theme", ArgumentType.REQUIRED);
        emptySetTheme.setCommandDescription(ColorTheme.formatInfoTranslation("tport.colorTheme.set.theme.commandDescription", new Object[0]));
        emptySetTheme.setRunnable((args, player) -> {
            if (args.length == 3) {
                ColorTheme.setDefaultTheme(player, args[2]);
                ColorTheme.sendSuccessTranslation(player, "tport.colorTheme.set.theme.succeeded", args[2]);
                TPortAdvancement.Advancement_PrettyColors.grant(player);
            } else {
                ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport colorTheme set <theme>");
            }
        });
        EmptyCommand emptySet = new EmptyCommand(){

            @Override
            public String getName(String argument) {
                return this.getCommandName();
            }
        };
        emptySet.setCommandName("set", ArgumentType.FIXED);
        emptySet.setTabRunnable((args, player) -> Stream.concat(ColorTheme.getDefaultThemes().stream(), ColorTheme.ColorType.getTypes().stream()).collect(Collectors.toList()));
        emptySet.setRunnable((args, player) -> {
            if (args.length > 2 && CommandTemplate.runCommands(emptySet.getActions(), args[2], args, player)) {
                return;
            }
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport colorTheme set " + CommandTemplate.convertToArgs(emptySet.getActions(), false));
        });
        emptySet.addAction(emptySetTheme);
        emptySet.addAction(emptySetType);
        EmptyCommand emptyGetType = new EmptyCommand();
        emptyGetType.setCommandName("type", ArgumentType.REQUIRED);
        emptyGetType.setCommandDescription(ColorTheme.formatInfoTranslation("tport.colorTheme.get.commandDescription", new Object[0]));
        EmptyCommand emptyGet = new EmptyCommand(){

            @Override
            public String getName(String argument) {
                return this.getCommandName();
            }
        };
        emptyGet.setCommandName("get", ArgumentType.FIXED);
        emptyGet.setTabRunnable((args, player) -> Arrays.stream(ColorTheme.ColorType.values()).map(Enum::name).collect(Collectors.toList()));
        emptyGet.setRunnable((args, player) -> {
            if (args.length != 3) {
                ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport colorTheme get <type>");
                return;
            }
            if (!ColorTheme.ColorType.getTypes().contains(args[2])) {
                ColorTheme.sendErrorTranslation(player, "tport.colorTheme.get.colorNotFound", args[2]);
                return;
            }
            Message message = ColorTheme.formatTranslation(ColorTheme.ColorType.valueOf(args[2]), ColorTheme.ColorType.varInfo2Color, "tport.colorTheme.this", new Object[0]);
            message.getText().forEach(t -> t.setInsertion(ColorTheme.ColorType.valueOf(args[2]).getColor(player).getColorAsValue()));
            ColorTheme.sendInfoTranslation(player, "tport.colorTheme.get.succeeded", ColorTheme.ColorType.valueOf(args[2]).name(), message);
        });
        emptyGet.addAction(emptyGetType);
        EmptyCommand emptyCopyPlayer = new EmptyCommand();
        emptyCopyPlayer.setCommandName("player", ArgumentType.REQUIRED);
        emptyCopyPlayer.setCommandDescription(ColorTheme.formatInfoTranslation("tport.colorTheme.copy.player.commandDescription", new Object[0]));
        EmptyCommand emptyCopy = new EmptyCommand(){

            @Override
            public String getName(String argument) {
                return this.getCommandName();
            }
        };
        emptyCopy.setCommandName("copy", ArgumentType.FIXED);
        emptyCopy.setTabRunnable((args, player) -> PlayerUUID.getPlayerNames());
        emptyCopy.setRunnable((args, player) -> {
            if (args.length != 3) {
                ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport colorTheme copy <player>");
                return;
            }
            String newPlayerName = args[2];
            UUID newPlayerUUID = PlayerUUID.getPlayerUUID(newPlayerName, player);
            if (newPlayerUUID == null) {
                return;
            }
            ColorTheme theme = ColorTheme.getTheme(newPlayerUUID);
            ColorTheme.setTheme(player, theme);
            ColorTheme.sendInfoTranslation(player, "tport.colorTheme.copy.player.succeeded", PlayerEncapsulation.asPlayer(newPlayerUUID));
        });
        emptyCopy.addAction(emptyCopyPlayer);
        this.addAction(empty);
        this.addAction(emptySet);
        this.addAction(emptyGet);
        this.addAction(emptyCopy);
    }

    @Override
    public String getName(String arg) {
        return "colorTheme";
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 1) {
            SettingsInventories.openTPortColorThemeGUI(player);
        } else if (!CommandTemplate.runCommands(this.getActions(), args[1], args, player)) {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport colorTheme " + CommandTemplate.convertToArgs(this.getActions(), true));
        }
    }
}

