/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.fancyMessage;

import com.google.common.base.CharMatcher;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.spaceman.tport.Main;
import com.spaceman.tport.Pair;
import com.spaceman.tport.adapters.TPortAdapter;
import com.spaceman.tport.commandHandler.CommandTemplate;
import com.spaceman.tport.commands.tport.Features;
import com.spaceman.tport.commands.tport.resourcePack.ResolutionCommand;
import com.spaceman.tport.fancyMessage.Attribute;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.TextType;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.colorTheme.MultiColor;
import com.spaceman.tport.fancyMessage.encapsulation.Encapsulation;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import com.spaceman.tport.fancyMessage.language.Language;
import com.spaceman.tport.fancyMessage.markdown.FancyNodeRenderer;
import com.spaceman.tport.tpEvents.ParticleAnimation;
import com.spaceman.tport.tpEvents.TPRestriction;
import com.spaceman.tport.tport.TPort;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.Repairable;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;

public class MessageUtils {
    public static HashMap<String, ArgumentTranslator> argumentTranslator = new HashMap();

    public static JsonObject toString(ItemStack is) {
        JsonObject item = new JsonObject();
        item.addProperty("id", is.getType().name().toLowerCase());
        item.addProperty("Count", (Number)is.getAmount());
        if (is.hasItemMeta()) {
            ItemMeta im = is.getItemMeta();
            item.add("tag", (JsonElement)MessageUtils.toString(im));
        }
        return item;
    }

    public static JsonObject toString(ItemMeta im) {
        CrossbowMeta crossbowMeta;
        JsonObject tags = new JsonObject();
        if (im instanceof Damageable) {
            tags.addProperty("Damage", (Number)((Damageable)im).getDamage());
        }
        if (im instanceof Repairable) {
            tags.addProperty("repairCost", (Number)((Repairable)im).getRepairCost());
        }
        if (im instanceof CrossbowMeta && (crossbowMeta = (CrossbowMeta)im).hasChargedProjectiles()) {
            tags.addProperty("Charged", (Number)1);
        }
        if (im.isUnbreakable()) {
            tags.addProperty("Unbreakable", (Number)1);
        }
        if (im.hasDisplayName() || im.hasLore() || im instanceof LeatherArmorMeta) {
            JsonObject display = new JsonObject();
            if (im.hasDisplayName()) {
                JsonObject displayName = new JsonObject();
                displayName.addProperty("text", im.getDisplayName());
                display.addProperty("Name", displayName.toString());
            }
            if (im.hasLore()) {
                JsonArray JsonArray2 = new JsonArray();
                im.getLore().forEach(lore -> {
                    JsonObject lorePiece = new JsonObject();
                    lorePiece.addProperty("text", lore);
                    JsonArray2.add(lorePiece.toString());
                });
                display.add("Lore", (JsonElement)JsonArray2);
            }
            if (im instanceof LeatherArmorMeta) {
                display.addProperty("color", (Number)((LeatherArmorMeta)im).getColor().asRGB());
            }
            tags.add("display", (JsonElement)display);
        }
        if (im.hasEnchants()) {
            JsonArray JsonArray3 = new JsonArray();
            for (Enchantment enchantment : im.getEnchants().keySet()) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("id", enchantment.getKey().toString());
                jsonObject.addProperty("lvl", (Number)im.getEnchantLevel(enchantment));
                JsonArray3.add((JsonElement)jsonObject);
            }
            tags.add("Enchantments", (JsonElement)JsonArray3);
        }
        if (im.hasCustomModelData()) {
            tags.addProperty("CustomModelData", (Number)im.getCustomModelData());
        }
        byte flag = 0;
        for (ItemFlag itemFlag : ItemFlag.values()) {
            if (!im.hasItemFlag(itemFlag)) continue;
            flag = (byte)(flag + (1 << itemFlag.ordinal()));
        }
        if (flag != 0) {
            tags.addProperty("HideFlags", (Number)flag);
        }
        return tags;
    }

    public static Message createColorGradient(String text, List<MultiColor> colorList) {
        Message message = new Message();
        char[] chars = text.toCharArray();
        List<MultiColor> gradient = MessageUtils.createGradient(chars.length, colorList);
        for (int i = 0; i < chars.length; ++i) {
            message.addText(TextComponent.textComponent(String.valueOf(chars[i]), gradient.get(i)));
        }
        return message;
    }

    private static List<MultiColor> createGradient(int size, List<MultiColor> colorList) {
        if (colorList.size() == 2) {
            ArrayList<MultiColor> newColorList = new ArrayList<MultiColor>();
            Color c1 = colorList.get(0).getColor();
            Color c2 = colorList.get(1).getColor();
            for (int i2 = 0; i2 < size; ++i2) {
                float ratio = (float)i2 / (float)size;
                int red = (int)((float)c2.getRed() * ratio + (float)c1.getRed() * (1.0f - ratio));
                int green = (int)((float)c2.getGreen() * ratio + (float)c1.getGreen() * (1.0f - ratio));
                int blue = (int)((float)c2.getBlue() * ratio + (float)c1.getBlue() * (1.0f - ratio));
                Color c = new Color(red, green, blue);
                newColorList.add(new MultiColor(c));
            }
            return newColorList;
        }
        if (colorList.size() > 2) {
            float[] fractions = new float[colorList.size()];
            double fractionSize = (double)size / (double)(colorList.size() - 1);
            for (int i3 = 1; i3 < colorList.size() - 1; ++i3) {
                fractions[i3] = (float)(fractionSize * (double)i3 / (double)size);
            }
            fractions[0] = 0.0f;
            fractions[fractions.length - 1] = 1.0f;
            LinearGradientPaint linearGradientPaint = new LinearGradientPaint(0.0f, 0.0f, size, 0.0f, fractions, (Color[])colorList.stream().map(MultiColor::getColor).toArray(Color[]::new));
            BufferedImage image = new BufferedImage(size, 1, 1);
            Graphics2D g = image.createGraphics();
            Rectangle2D.Double rectangle2D = new Rectangle2D.Double(0.0, 0.0, size, 1.0);
            g.setPaint(linearGradientPaint);
            g.fill(rectangle2D);
            g.dispose();
            ArrayList<MultiColor> newColorList = new ArrayList<MultiColor>();
            for (int x = 0; x < image.getWidth(); ++x) {
                newColorList.add(new MultiColor(new Color(image.getRGB(x, 0))));
            }
            return newColorList;
        }
        if (colorList.size() == 1) {
            return IntStream.range(0, size).mapToObj(i -> (MultiColor)colorList.get(0)).collect(Collectors.toList());
        }
        return IntStream.range(0, size).mapToObj(i -> new MultiColor(ChatColor.WHITE)).collect(Collectors.toList());
    }

    public static Message toMessage(BufferedImage image) {
        Message message = new Message();
        if (image.getWidth() > 34) {
            image = MessageUtils.getScaledImage(image, 34, image.getHeight());
        }
        if (image.getHeight() > 20) {
            image = MessageUtils.getScaledImage(image, image.getWidth(), 20);
        }
        for (int height = 0; height < image.getHeight(); ++height) {
            for (int width = 0; width < image.getWidth(); ++width) {
                message.addText(TextComponent.textComponent("\u2588", new MultiColor(new Color(image.getRGB(width, height)))));
            }
            message.addText(TextComponent.textComponent("\n"));
        }
        message.removeLast();
        return message;
    }

    private static BufferedImage getScaledImage(BufferedImage src, int w, int h) {
        int original_width = src.getWidth();
        int original_height = src.getHeight();
        int bound_width = w;
        int bound_height = h;
        int new_width = original_width;
        int new_height = original_height;
        if (original_width > bound_width) {
            new_width = bound_width;
            new_height = new_width * original_height / original_width;
        }
        if (new_height > bound_height) {
            new_height = bound_height;
            new_width = new_height * original_width / original_height;
        }
        BufferedImage resizedImg = new BufferedImage(new_width, new_height, 1);
        Graphics2D g2 = resizedImg.createGraphics();
        g2.setBackground(Color.WHITE);
        g2.clearRect(0, 0, new_width, new_height);
        g2.drawImage(src, 0, 0, new_width, new_height, null);
        g2.dispose();
        return resizedImg;
    }

    public static ItemStack getSign(@Nullable ItemStack signItem, Player player, List<Message> lines) {
        return MessageUtils.getSign(signItem, player, lines, null);
    }

    public static ItemStack getSign(@Nullable ItemStack signItem, ColorTheme theme, List<Message> lines) {
        return MessageUtils.getSign(signItem, theme, lines, null);
    }

    public static ItemStack getSign(@Nullable ItemStack signItem, Player player, List<Message> lines, @Nullable DyeColor glow) {
        return MessageUtils.getSign(signItem, ColorTheme.getTheme(player), lines, glow);
    }

    public static ItemStack getSign(@Nullable ItemStack signItem, ColorTheme theme, List<Message> lines, @Nullable DyeColor glow) {
        ItemStack itemStack = Main.getOrDefault(signItem, new ItemStack(Material.OAK_SIGN));
        return itemStack;
    }

    public static Message setIgnoreTranslator(Message message, boolean ignore) {
        message.getText().forEach(t -> t.ignoreTranslator(ignore));
        return message;
    }

    public static String getOrDefaultCaseInsensitive(JsonObject json, String toFind, String defaultValue) {
        for (String s : json.keySet()) {
            if (s == null || !toFind.equalsIgnoreCase(s)) continue;
            return json.get(s).getAsString();
        }
        return defaultValue;
    }

    public static HoverEvent translateHoverEvent(HoverEvent message, JsonObject translateFile) {
        HoverEvent hEvent = new HoverEvent();
        message.getText().stream().map(t -> MessageUtils.translateTextComponent(t, translateFile)).forEach(hEvent::addMessage);
        return hEvent;
    }

    public static Message translateTextComponent(TextComponent textComponent, JsonObject translateFile) {
        return MessageUtils.translateMessage(new Message(textComponent), translateFile);
    }

    public static List<Message> translateMessage(List<Message> toTranslate, JsonObject translateFile) {
        if (translateFile == null) {
            return toTranslate;
        }
        ArrayList<Message> returnCollection = new ArrayList<Message>();
        for (Message message : toTranslate) {
            returnCollection.add(MessageUtils.translateMessage(message, translateFile));
        }
        return returnCollection;
    }

    public static Message translateMessage(@Nullable Message toTranslate, @Nullable JsonObject translateFile) {
        if (translateFile == null) {
            return toTranslate;
        }
        if (toTranslate == null) {
            return null;
        }
        if (toTranslate.isTranslated()) {
            return toTranslate;
        }
        Message message = new Message();
        for (TextComponent textComponent : toTranslate.getText()) {
            if (textComponent.hasHoverEvent()) {
                textComponent.addTextEvent(MessageUtils.translateHoverEvent(textComponent.getHoverEvent(), translateFile));
            }
            if (TextType.TRANSLATE.equals(textComponent.getType()) && !textComponent.ignoreTranslator()) {
                String text = MessageUtils.getOrDefaultCaseInsensitive(translateFile, textComponent.getText(), textComponent.getText());
                ArrayList<Message> translateWith = textComponent.getTranslateWith();
                String delimiter = "((%\\p{Digit}\\$s)|(%s))";
                int withIndex = 0;
                for (String textPiece : text.split(String.format("((?<=%1$s)|(?=%1$s))", delimiter))) {
                    if (textPiece.equals("%s")) {
                        if (withIndex >= translateWith.size()) continue;
                        Message withMessage = translateWith.get(withIndex);
                        for (TextComponent withMessageComponent : withMessage.getText()) {
                            if (withMessageComponent.hasHoverEvent()) {
                                withMessageComponent.addTextEvent(MessageUtils.translateHoverEvent(withMessageComponent.getHoverEvent(), translateFile));
                            } else if (textComponent.hasHoverEvent()) {
                                withMessageComponent.addTextEvent(textComponent.getHoverEvent());
                            }
                            if (!withMessageComponent.hasClickEvent() && textComponent.hasClickEvent()) {
                                withMessageComponent.addTextEvent(textComponent.getClickEvent());
                            }
                            if (TextType.TRANSLATE.equals(withMessageComponent.getType())) {
                                message.addMessage(MessageUtils.translateTextComponent(withMessageComponent, translateFile));
                                continue;
                            }
                            message.addText(withMessageComponent);
                        }
                        ++withIndex;
                        continue;
                    }
                    if (textPiece.matches("%\\d++\\$s")) {
                        int index = Integer.parseInt(CharMatcher.inRange((char)'0', (char)'9').retainFrom((CharSequence)textPiece)) - 1;
                        if (index >= translateWith.size()) continue;
                        Message withMessage = translateWith.get(index);
                        for (TextComponent withMessageComponent : withMessage.getText()) {
                            if (withMessageComponent.hasHoverEvent()) {
                                withMessageComponent.addTextEvent(MessageUtils.translateHoverEvent(withMessageComponent.getHoverEvent(), translateFile));
                            } else if (textComponent.hasHoverEvent()) {
                                withMessageComponent.addTextEvent(textComponent.getHoverEvent());
                            }
                            if (!withMessageComponent.hasClickEvent() && textComponent.hasClickEvent()) {
                                withMessageComponent.addTextEvent(textComponent.getClickEvent());
                            }
                            for (Attribute attribute : textComponent.getAttributes()) {
                                withMessageComponent.addAttribute(attribute);
                            }
                            if (TextType.TRANSLATE.equals(withMessageComponent.getType())) {
                                message.addMessage(MessageUtils.translateTextComponent(withMessageComponent, translateFile));
                                continue;
                            }
                            message.addText(withMessageComponent);
                        }
                        continue;
                    }
                    TextComponent newComponent = ((TextComponent)textComponent.clone()).setText(textPiece).setType(TextType.TEXT);
                    newComponent.resetTranslateWith();
                    message.addText(newComponent);
                }
                continue;
            }
            message.addText(textComponent);
        }
        message.setTranslated(true);
        return message;
    }

    public static ItemStack setCustomName(ItemStack is, Player player, Message displayName) {
        return MessageUtils.setCustomItemData(is, ColorTheme.getTheme(player), displayName, null);
    }

    public static ItemStack setCustomName(ItemStack is, ColorTheme theme, Message displayName) {
        return MessageUtils.setCustomItemData(is, theme, displayName, null);
    }

    public static ItemStack setCustomLore(ItemStack is, Player player, Message ... lore) {
        return MessageUtils.setCustomItemData(is, ColorTheme.getTheme(player), null, Arrays.asList(lore));
    }

    public static ItemStack setCustomLore(ItemStack is, Player player, Collection<Message> lore) {
        return MessageUtils.setCustomItemData(is, ColorTheme.getTheme(player), null, lore);
    }

    public static ItemStack setCustomLore(ItemStack is, ColorTheme theme, Message ... lore) {
        return MessageUtils.setCustomItemData(is, theme, null, Arrays.asList(lore));
    }

    public static ItemStack setCustomLore(ItemStack is, ColorTheme theme, Collection<Message> lore) {
        return MessageUtils.setCustomItemData(is, theme, null, lore);
    }

    public static ItemStack setCustomItemData(ItemStack is, ColorTheme theme, @Nullable Message displayName, @Nullable Collection<Message> lore) {
        try {
            TPortAdapter adapter = Main.getInstance().adapter;
            if (displayName != null) {
                adapter.setDisplayName(is, displayName, theme);
            }
            if (lore != null) {
                adapter.setLore(is, lore, theme);
            }
            return is;
        }
        catch (Throwable ex) {
            ItemMeta im;
            Features.Feature.printSmallNMSErrorInConsole("Fancy item stacks", true);
            if (Features.Feature.PrintErrorsInConsole.isEnabled()) {
                ex.printStackTrace();
            }
            if ((im = is.getItemMeta()) != null) {
                JsonObject serverLang = Language.getServerLang();
                if (displayName != null) {
                    im.setDisplayName(displayName.translateMessage(serverLang).toColoredString(theme));
                }
                if (lore != null) {
                    ArrayList<String> lorePlaceholder = new ArrayList<String>();
                    for (Message line : lore) {
                        if (line == null) continue;
                        lorePlaceholder.add(line.translateMessage(serverLang).toColoredString(theme));
                    }
                    im.setLore(lorePlaceholder);
                }
                is.setItemMeta(im);
            }
            return is;
        }
    }

    public static boolean hasCustomName(ItemStack is) {
        return MessageUtils.hasCustomName(is.getItemMeta());
    }

    public static boolean hasCustomName(ItemMeta im) {
        return im.hasDisplayName();
    }

    public static ArrayList<Message> transformColoredTextToMessage(String coloredText, @Nullable String defaultColor) {
        ArrayList<Message> messages = new ArrayList<Message>();
        String lastHexColor = Main.getOrDefault(defaultColor, "");
        Message lastMessage = new Message();
        for (String element : MessageUtils.transformColoredTextToArray(coloredText)) {
            if (MultiColor.isColor(element)) {
                lastHexColor = new MultiColor(element).getColorAsValue();
                continue;
            }
            if (element.equals("\n") || element.equals("\\n")) {
                messages.add(lastMessage);
                lastMessage = new Message();
                lastHexColor = Main.getOrDefault(defaultColor, "");
                continue;
            }
            lastMessage.addText(new TextComponent(element, lastHexColor));
        }
        if (!lastMessage.isEmpty()) {
            messages.add(lastMessage);
        }
        return messages;
    }

    public static ArrayList<String> transformColoredTextToArray(String coloredText) {
        ArrayList<String> textElements = new ArrayList<String>();
        textElements.add("");
        char[] charArray = coloredText.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            String lastElement = textElements.get(textElements.size() - 1);
            if (c == '\n') {
                if (lastElement.isEmpty()) {
                    textElements.remove(textElements.size() - 1);
                }
                textElements.add("\n");
                textElements.add("");
                continue;
            }
            if (c == '\\' && i + 1 < charArray.length && coloredText.startsWith("\\n", i)) {
                if (lastElement.isEmpty()) {
                    textElements.remove(textElements.size() - 1);
                }
                textElements.add("\\n");
                textElements.add("");
                ++i;
                continue;
            }
            if (c == '#') {
                String possibleHexNotation;
                if (i + 6 < charArray.length && MultiColor.isHexColor(possibleHexNotation = coloredText.substring(i, i + 7))) {
                    if (lastElement.isEmpty()) {
                        textElements.remove(textElements.size() - 1);
                    }
                    textElements.add(possibleHexNotation);
                    textElements.add("");
                    i += 6;
                    continue;
                }
            } else if (c == '&') {
                String possibleChatColor;
                if (i + 1 < charArray.length && MultiColor.isColorCode(possibleChatColor = coloredText.substring(i, i + 2))) {
                    if (lastElement.isEmpty()) {
                        textElements.remove(textElements.size() - 1);
                    }
                    textElements.add(possibleChatColor);
                    textElements.add("");
                    ++i;
                    continue;
                }
            } else if (c == '$') {
                try {
                    int j;
                    int redIndex = i;
                    int greenIndex = -1;
                    int blueIndex = -1;
                    int endIndex = -1;
                    for (j = 1; j < 5 && redIndex + j < charArray.length; ++j) {
                        char greenDollar = charArray[redIndex + j];
                        if (greenDollar != '$') continue;
                        greenIndex = redIndex + j;
                        break;
                    }
                    if (greenIndex == -1) {
                        throw new IllegalArgumentException();
                    }
                    for (j = 1; j < 5 && greenIndex + j < charArray.length; ++j) {
                        char blueDollar = charArray[greenIndex + j];
                        if (blueDollar != '$') continue;
                        blueIndex = greenIndex + j;
                        break;
                    }
                    if (blueIndex == -1) {
                        throw new IllegalArgumentException();
                    }
                    for (j = 1; j < 5; ++j) {
                        if (blueIndex + j >= charArray.length) {
                            endIndex = blueIndex + j;
                            break;
                        }
                        char end = charArray[blueIndex + j];
                        if (String.valueOf(end).matches("\\d")) continue;
                        endIndex = blueIndex + j;
                        break;
                    }
                    if (endIndex == -1) {
                        throw new IllegalArgumentException();
                    }
                    String redString = coloredText.substring(redIndex, greenIndex);
                    String greenString = coloredText.substring(greenIndex, blueIndex);
                    String blueString = coloredText.substring(blueIndex, endIndex);
                    for (String colorString : List.of(redString, greenString, blueString)) {
                        try {
                            int color = Integer.parseInt(colorString.substring(1));
                            if (color <= 255) continue;
                            throw new IllegalArgumentException();
                        }
                        catch (NumberFormatException nfe) {
                            throw new IllegalArgumentException();
                        }
                    }
                    if (lastElement.isEmpty()) {
                        textElements.remove(textElements.size() - 1);
                    }
                    textElements.add(redString + greenString + blueString);
                    textElements.add("");
                    i = endIndex - 1;
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            textElements.set(textElements.size() - 1, lastElement + c);
        }
        return textElements;
    }

    public static Message fromMarkdown(String markdown) {
        Parser markdownParser = Parser.builder().build();
        Node node = markdownParser.parse(markdown);
        Message message = new Message();
        FancyNodeRenderer fancyRenderer = new FancyNodeRenderer(message);
        fancyRenderer.render(node);
        return message;
    }

    public static Pair<ArrayList<String>, ArrayList<Message>> fromSplitMarkdown(String markdown, CommandTemplate ... templates) {
        Parser markdownParser = Parser.builder().build();
        Node node = markdownParser.parse(markdown);
        ArrayList<String> chapterTitles = new ArrayList<String>();
        ArrayList<Message> chapters = new ArrayList<Message>();
        FancyNodeRenderer fancyRenderer = new FancyNodeRenderer(chapterTitles, chapters);
        Stream.of(templates).forEach(fancyRenderer::addCommandLookup);
        fancyRenderer.render(node);
        return new Pair<ArrayList<String>, ArrayList<Message>>(chapterTitles, chapters);
    }

    static {
        argumentTranslator.put("null", (text, object, color, varColor) -> {
            if (object == null) {
                text.addTranslateWith(TextComponent.textComponent("null", varColor));
                return true;
            }
            return false;
        });
        argumentTranslator.put("message", (text, object, color, varColor) -> {
            if (object instanceof Message) {
                text.addTranslateWith((Message)object);
                return true;
            }
            return false;
        });
        argumentTranslator.put("textComponent", (text, object, color, varColor) -> {
            if (object instanceof TextComponent) {
                text.addTranslateWith((TextComponent)object);
                return true;
            }
            return false;
        });
        argumentTranslator.put("tport", (text, object, color, varColor) -> {
            if (object instanceof TPort) {
                TPort tport = (TPort)object;
                TPortEncapsulation encapsulation = TPortEncapsulation.asTPort(tport);
                Message component = encapsulation.toMessage(color, varColor);
                component.addTextEvent(encapsulation.getHoverEvent());
                component.addTextEvent(encapsulation.getClickEvent());
                component.setInsertion(encapsulation.getInsertion());
                text.addTranslateWith(component);
                return true;
            }
            return false;
        });
        argumentTranslator.put("player", (text, object, color, varColor) -> {
            if (object instanceof Player) {
                Player player = (Player)object;
                PlayerEncapsulation encapsulation = PlayerEncapsulation.asPlayer(player);
                Message component = encapsulation.toMessage(color, varColor);
                component.addTextEvent(encapsulation.getHoverEvent());
                component.addTextEvent(encapsulation.getClickEvent());
                component.setInsertion(encapsulation.getInsertion());
                text.addTranslateWith(component);
                return true;
            }
            return false;
        });
        argumentTranslator.put("encapsulation", (text, object, color, varColor) -> {
            if (object instanceof Encapsulation) {
                Encapsulation encapsulation = (Encapsulation)object;
                Message component = encapsulation.toMessage(color, varColor);
                component.addTextEvent(encapsulation.getHoverEvent());
                component.addTextEvent(encapsulation.getClickEvent());
                component.setInsertion(encapsulation.getInsertion());
                text.addTranslateWith(component);
                return true;
            }
            return false;
        });
        argumentTranslator.put("messageDescription", (text, object, color, varColor) -> {
            if (object instanceof MessageDescription) {
                MessageDescription messageDescription = (MessageDescription)object;
                Message component = messageDescription.getName(color, varColor);
                Message description = messageDescription.getDescription();
                if (description != null && !description.isEmpty()) {
                    component.addTextEvent(new HoverEvent(description));
                }
                component.setInsertion(messageDescription.getInsertion());
                text.addTranslateWith(component);
                return true;
            }
            return false;
        });
        argumentTranslator.put("restriction", (text, object, color, varColor) -> {
            if (object instanceof TPRestriction) {
                TPRestriction restriction = (TPRestriction)object;
                TextComponent component = new TextComponent(restriction.getRestrictionName(), varColor);
                component.addTextEvent(new HoverEvent(restriction.getDescription()));
                component.setInsertion(restriction.getRestrictionName());
                text.addTranslateWith(component);
                return true;
            }
            return false;
        });
        argumentTranslator.put("clickType", (text, object, color, varColor) -> {
            if (object instanceof ClickType) {
                ClickType clickType = (ClickType)object;
                TextComponent component = clickType == ClickType.CONTROL_DROP || clickType == ClickType.DROP ? TextComponent.textComponent("tport.fancyMessage.MessageUtils.clickType." + clickType.name(), varColor).addTranslateWith(TextComponent.textComponent("key.drop", varColor).setType(TextType.KEYBIND)).setType(TextType.TRANSLATE) : TextComponent.textComponent("tport.fancyMessage.MessageUtils.clickType." + clickType.name(), varColor).setType(TextType.TRANSLATE);
                component.setInsertion(clickType.name());
                text.addTranslateWith(component);
                return true;
            }
            return false;
        });
        argumentTranslator.put("world", (text, object, color, varColor) -> {
            if (object instanceof World) {
                World world = (World)object;
                TextComponent component = new TextComponent(world.getName(), varColor);
                String command = "/tport world " + world.getName();
                component.addTextEvent(HoverEvent.hoverEvent(command, ColorTheme.ColorType.infoColor));
                component.addTextEvent(ClickEvent.runCommand(command));
                component.setInsertion(world.getName());
                text.addTranslateWith(component);
                return true;
            }
            return false;
        });
        argumentTranslator.put("particleAnimation", (text, object, color, varColor) -> {
            if (object instanceof ParticleAnimation) {
                ParticleAnimation particleAnimation = (ParticleAnimation)object;
                TextComponent component = new TextComponent(particleAnimation.getAnimationName(), varColor);
                component.addTextEvent(new HoverEvent(particleAnimation.getDescription()));
                component.setInsertion(particleAnimation.getAnimationName());
                text.addTranslateWith(component);
                return true;
            }
            return false;
        });
        argumentTranslator.put("itemStack", (text, object, color, varColor) -> {
            if (object instanceof ItemStack) {
                ItemStack item = (ItemStack)object;
                TextComponent component = new TextComponent(item.getType().name(), varColor);
                component.addTextEvent(new HoverEvent(TextComponent.textComponent(item.toString(), color)));
                component.setInsertion(component.getText());
                text.addTranslateWith(component);
                return true;
            }
            return false;
        });
        argumentTranslator.put("resourcePackResolution", (text, object, color, varColor) -> {
            if (object instanceof ResolutionCommand.Resolution) {
                ResolutionCommand.Resolution resolution = (ResolutionCommand.Resolution)object;
                TextComponent component = new TextComponent(resolution.getName(), varColor);
                component.setInsertion(resolution.getName());
                component.addTextEvent(new HoverEvent(resolution.getDescription()));
                if (resolution.getUrl() != null) {
                    component.addTextEvent(new ClickEvent("open_url", resolution.getUrl()));
                }
                text.addTranslateWith(component);
                return true;
            }
            return false;
        });
        argumentTranslator.put("default", (text, object, color, varColor) -> {
            String textPiece = object.toString();
            TextComponent component = TextComponent.textComponent(textPiece, varColor);
            if (textPiece.startsWith("/") && !Pattern.compile("[\\[\\]<>]").matcher(textPiece).find()) {
                component.addTextEvent(HoverEvent.hoverEvent(textPiece, ColorTheme.ColorType.infoColor));
                component.addTextEvent(ClickEvent.runCommand(textPiece));
            }
            try {
                new URL(textPiece);
                component.addTextEvent(HoverEvent.hoverEvent(textPiece, ColorTheme.ColorType.infoColor));
                component.addTextEvent(ClickEvent.openUrl(textPiece));
            }
            catch (Exception exception) {
                // empty catch block
            }
            component.setTextAsInsertion();
            text.addTranslateWith(component);
            return true;
        });
    }

    public static interface MessageDescription {
        @Nullable
        public Message getDescription();

        public Message getName(String var1, String var2);

        public String getInsertion();
    }

    @FunctionalInterface
    public static interface ArgumentTranslator {
        public boolean format(TextComponent var1, Object var2, String var3, String var4);
    }
}

