/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.events;

import com.spaceman.tport.Main;
import com.spaceman.tport.commands.TPortCommand;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.permissions.PermissionHandler;
import com.spaceman.tport.playerUUID.PlayerUUID;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class TeleporterEvents
implements Listener {
    public static boolean isTeleporter(ItemStack is) {
        ItemMeta im = is.getItemMeta();
        if (im != null) {
            PersistentDataContainer dataContainer = im.getPersistentDataContainer();
            NamespacedKey keyCommand = new NamespacedKey((Plugin)Main.getInstance(), "teleporterCommand");
            return dataContainer.has(keyCommand, PersistentDataType.STRING);
        }
        return false;
    }

    private boolean useTeleporter(Player player, ItemStack is) {
        ItemMeta im;
        if (TeleporterEvents.isTeleporter(is) && PermissionHandler.hasPermission(player, true, true, "TPort.teleporter.use") && (im = is.getItemMeta()) != null) {
            PersistentDataContainer dataContainer = im.getPersistentDataContainer();
            NamespacedKey keyCommand = new NamespacedKey((Plugin)Main.getInstance(), "teleporterCommand");
            NamespacedKey keyTPortUUID = new NamespacedKey((Plugin)Main.getInstance(), "teleporterTPortUUID");
            NamespacedKey keyPlayerUUID = new NamespacedKey((Plugin)Main.getInstance(), "teleporterPlayerUUID");
            if (dataContainer.has(keyCommand, PersistentDataType.STRING)) {
                if (dataContainer.has(keyTPortUUID, PersistentDataType.STRING)) {
                    String uuid = (String)dataContainer.get(keyTPortUUID, PersistentDataType.STRING);
                    assert (uuid != null);
                    TPort tport = TPortManager.getTPort(UUID.fromString(uuid));
                    if (tport != null) {
                        Object command = (String)dataContainer.get(keyCommand, PersistentDataType.STRING);
                        assert (command != null);
                        if (((String)command).contains(" ")) {
                            command = "open";
                        }
                        command = (String)command + " " + PlayerUUID.getPlayerName(tport.getOwner());
                        TPortCommand.executeTPortCommand((CommandSender)player, (String)command + " " + tport.getName());
                    } else {
                        ColorTheme.sendErrorTranslation(player, "tport.events.teleporterEvents.TPortNotExistAnymore", uuid);
                    }
                } else if (dataContainer.has(keyPlayerUUID, PersistentDataType.STRING)) {
                    Object command = (String)dataContainer.get(keyCommand, PersistentDataType.STRING);
                    command = (String)command + " " + PlayerUUID.getPlayerName((String)dataContainer.get(keyPlayerUUID, PersistentDataType.STRING));
                    TPortCommand.executeTPortCommand((CommandSender)player, (String)command);
                } else {
                    TPortCommand.executeTPortCommand((CommandSender)player, (String)dataContainer.get(keyCommand, PersistentDataType.STRING));
                }
                return true;
            }
        }
        return false;
    }

    @EventHandler
    public void interactEvent(PlayerInteractEntityEvent e) {
        Entity entity = e.getRightClicked();
        if (entity instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)entity;
            ItemStack is = itemFrame.getItem();
            if (!e.getPlayer().isSneaking() && this.useTeleporter(e.getPlayer(), is)) {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void click(PlayerInteractEvent e) {
        if ((e.getAction().equals((Object)Action.RIGHT_CLICK_AIR) || e.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && (e.getPlayer().isSneaking() || !this.isSpecialBlock(e.getClickedBlock()))) && EquipmentSlot.HAND.equals((Object)e.getHand())) {
            ItemStack is = e.getPlayer().getInventory().getItemInMainHand();
            if (this.useTeleporter(e.getPlayer(), is)) {
                e.setCancelled(true);
            }
        }
    }

    private boolean isSpecialBlock(Block block) {
        if (block == null) {
            return false;
        }
        if (block.getState() instanceof InventoryHolder) {
            return true;
        }
        return switch (block.getType()) {
            case Material.ENCHANTING_TABLE, Material.CRAFTING_TABLE, Material.ENDER_CHEST, Material.ANVIL, Material.DAMAGED_ANVIL, Material.CHIPPED_ANVIL, Material.BEACON, Material.BREWING_STAND, Material.COMMAND_BLOCK, Material.CHAIN_COMMAND_BLOCK, Material.REPEATING_COMMAND_BLOCK, Material.FURNACE, Material.HOPPER, Material.CHEST, Material.TRAPPED_CHEST, Material.NOTE_BLOCK, Material.STRUCTURE_BLOCK, Material.COMPARATOR, Material.REPEATER, Material.LEVER, Material.DISPENSER, Material.DROPPER, Material.JUKEBOX, Material.DAYLIGHT_DETECTOR, Material.BLAST_FURNACE, Material.LOOM, Material.SMOKER, Material.CARTOGRAPHY_TABLE, Material.STONECUTTER, Material.GRINDSTONE, Material.BARREL, Material.JIGSAW, Material.LECTERN, Material.SMITHING_TABLE, Material.FLETCHING_TABLE -> true;
            default -> block.getType().toString().endsWith("DOOR") || block.getType().toString().endsWith("BED") || block.getType().toString().endsWith("TRAPDOOR") || block.getType().toString().endsWith("BUTTON") || block.getType().toString().endsWith("SHULKER_BOX");
        };
    }
}

