/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.events;

import com.spaceman.tport.Main;
import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.advancements.TPortAdvancementManager;
import com.spaceman.tport.commands.tport.ResourcePack;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.inventories.keyboard.QuickType;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.tpEvents.TPRequest;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.plugin.Plugin;

public class JoinEvent
implements Listener {
    public static ArrayList<UUID> playerResourceList = new ArrayList();

    public static void setData(Player player) {
        String playerUUID = player.getUniqueId().toString();
        if (!Files.tportData.getConfig().contains("tport." + playerUUID)) {
            Files.tportData.getConfig().set("tport." + playerUUID + ".tports.0", (Object)"welcome");
            Files.tportData.getConfig().set("tport." + playerUUID + ".tports.0", null);
            Files.tportData.saveConfig();
        }
        QuickType.setQuickTypeSignHandler(player);
        if (TPortAdvancement.isActive()) {
            Bukkit.getScheduler().runTaskLater((Plugin)Main.getInstance(), () -> TPortAdvancementManager.getOrCreateManager(player), 40L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void join(PlayerJoinEvent e) {
        JoinEvent.setData(e.getPlayer());
        ResourcePack.updateResourcePack(e.getPlayer(), true);
    }

    @EventHandler
    public void leave(PlayerQuitEvent e) {
        TPRequest.playerLeft(e.getPlayer());
        QuickType.removeQuickTypeSignHandler(e.getPlayer());
        if (TPortAdvancement.isActive()) {
            TPortAdvancementManager.removeAdvancementManager(e.getPlayer());
        }
    }

    @EventHandler
    public void playerResourcePackStatusEvent(PlayerResourcePackStatusEvent e) {
        if (!playerResourceList.contains(e.getPlayer().getUniqueId())) {
            return;
        }
        switch (e.getStatus()) {
            case SUCCESSFULLY_LOADED: {
                ColorTheme.sendSuccessTranslation(e.getPlayer(), "tport.events.JoinEvent.playerResourcePackStatusEvent.succeeded", new Object[0]);
                playerResourceList.remove(e.getPlayer().getUniqueId());
                break;
            }
            case DECLINED: 
            case DISCARDED: {
                ColorTheme.sendErrorTranslation(e.getPlayer(), "tport.events.JoinEvent.playerResourcePackStatusEvent.denied", new Object[0]);
                playerResourceList.remove(e.getPlayer().getUniqueId());
                ResourcePack.setResourcePackState(e.getPlayer().getUniqueId(), false);
                break;
            }
            case FAILED_DOWNLOAD: 
            case FAILED_RELOAD: 
            case INVALID_URL: {
                ColorTheme.sendErrorTranslation(e.getPlayer(), "tport.events.JoinEvent.playerResourcePackStatusEvent.error", new Object[0]);
                playerResourceList.remove(e.getPlayer().getUniqueId());
                ResourcePack.setResourcePackState(e.getPlayer().getUniqueId(), false);
                break;
            }
        }
    }
}

