/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.cooldown;

import com.spaceman.tport.Main;
import com.spaceman.tport.advancements.TPortAdvancement;
import com.spaceman.tport.cooldown.CooldownCommand;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.inventories.InventoryModel;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.inventories.SettingsInventories;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.PluginManager;

public enum CooldownManager {
    TPortTP("3000", SettingsInventories.settings_cooldown_tport_tp_model),
    PlayerTP("3000", SettingsInventories.settings_cooldown_player_tp_model),
    FeatureTP("3000", SettingsInventories.settings_cooldown_feature_tp_model),
    BiomeTP("3000", SettingsInventories.settings_cooldown_biome_tp_model),
    Search("10000", SettingsInventories.settings_cooldown_search_model),
    Back("TPortTP", SettingsInventories.settings_cooldown_back_model),
    LookTP("3000", SettingsInventories.settings_cooldown_look_tp_model);

    public static boolean loopCooldown;
    private static String errorOccurredWith;
    private static final HashMap<UUID, HashMap<CooldownManager, Long>> cooldownTime;
    private final String defaultValue;
    private final InventoryModel inventoryModel;

    private CooldownManager(String defValue, InventoryModel inventoryModel) {
        this.defaultValue = defValue;
        this.inventoryModel = inventoryModel;
    }

    public InventoryModel getInventoryModel() {
        return this.inventoryModel;
    }

    public static void setDefaultValues() {
        loopCooldown = false;
        PluginManager pm = Bukkit.getPluginManager();
        for (CooldownManager cooldown : CooldownManager.values()) {
            if (!Files.tportConfig.getConfig().contains("cooldown." + cooldown.name())) {
                cooldown.edit(cooldown.defaultValue);
            }
            for (CooldownManager innerCooldown : CooldownManager.values()) {
                if (cooldown == innerCooldown) continue;
                try {
                    pm.addPermission(new Permission("TPort.cooldown." + cooldown.name() + "." + innerCooldown.name()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public String value() {
        return Files.tportConfig.getConfig().getString("cooldown." + this.name());
    }

    public void edit(String value) {
        Files.tportConfig.getConfig().set("cooldown." + this.name(), (Object)value);
        Files.tportConfig.saveConfig();
    }

    public void edit(long value) {
        Files.tportConfig.getConfig().set("cooldown." + this.name(), (Object)String.valueOf(value));
        Files.tportConfig.saveConfig();
    }

    public static boolean contains(String name) {
        return CooldownManager.get(name) != null;
    }

    public static CooldownManager get(@Nullable String name) {
        for (CooldownManager cooldown : CooldownManager.values()) {
            if (!cooldown.name().equalsIgnoreCase(name)) continue;
            return cooldown;
        }
        return null;
    }

    public void printValue(Player player) {
        this.printValue(player, null);
    }

    private void printValue(Player player, CooldownManager start) {
        if (this.name().equals(start == null ? "" : start.name()) || loopCooldown) {
            Main.getInstance().getLogger().log(Level.WARNING, "There is a loop in the cooldown configuration. This was triggered with player " + errorOccurredWith + ". Check their permissions when using permissions, and check the Cooldown configuration in 'TPortConfig.yml'. Cooldown now disabled");
            loopCooldown = true;
            ColorTheme.sendErrorTranslation(player, "tport.cooldown.cooldownManager.cooldownLoopError.user", new Object[0]);
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (!CooldownCommand.getInstance().emptyCooldownCooldownValue.hasPermissionToRun(player, false)) continue;
                ColorTheme.sendErrorTranslation(onlinePlayer, "tport.cooldown.cooldownManager.cooldownLoopError.admin", errorOccurredWith);
            }
            return;
        }
        ColorTheme.sendInfoTranslation(player, "tport.cooldown.cooldownManager.printValue", this.name(), this.value());
        CooldownManager linkingTo = CooldownManager.get(this.value());
        if (linkingTo != null) {
            if (start == null) {
                start = this;
                errorOccurredWith = player.getName();
            }
            linkingTo.printValue(player, start);
        }
        if (this.value().equalsIgnoreCase("permission")) {
            for (PermissionAttachmentInfo permissionInfo : player.getEffectivePermissions()) {
                String valueFromPermission;
                String permissionString = "TPort.cooldown." + this.name() + ".";
                if (!permissionInfo.getPermission().toLowerCase().startsWith(permissionString.toLowerCase()) || (linkingTo = CooldownManager.get(valueFromPermission = permissionInfo.getPermission().substring(permissionString.length()))) == null) continue;
                if (start == null) {
                    start = this;
                    errorOccurredWith = player.getName();
                }
                ColorTheme.sendInfoTranslation(player, "tport.cooldown.cooldownManager.printPermissionValue", valueFromPermission);
                linkingTo.printValue(player, start);
                return;
            }
        }
    }

    public void update(Player player) {
        if (loopCooldown) {
            return;
        }
        if (this.value().equalsIgnoreCase("permission")) {
            for (PermissionAttachmentInfo permissionInfo : player.getEffectivePermissions()) {
                String valueFromPermission;
                String permissionString = "TPort.cooldown." + this.name() + ".";
                if (!permissionInfo.getPermission().toLowerCase().startsWith(permissionString.toLowerCase()) || !CooldownManager.contains(valueFromPermission = permissionInfo.getPermission().substring(permissionString.length()))) continue;
                CooldownManager.get(valueFromPermission).update(player);
                return;
            }
        }
        if (CooldownManager.contains(this.value())) {
            CooldownManager.get(this.value()).update(player);
            return;
        }
        HashMap<CooldownManager, Long> timeMap = cooldownTime.getOrDefault(player.getUniqueId(), new HashMap());
        timeMap.put(this, System.currentTimeMillis());
        cooldownTime.put(player.getUniqueId(), timeMap);
    }

    public long getTime(Player player) {
        return this.getTime(player, null);
    }

    private long getTime(Player player, CooldownManager start) {
        if (this.name().equals(start == null ? "" : start.name()) || loopCooldown) {
            Main.getInstance().getLogger().log(Level.WARNING, "There is a loop in the cooldown configuration. This was triggered with player " + errorOccurredWith + ". Check their permissions when using permissions, and check the Cooldown configuration in 'TPortConfig.yml'. Cooldown now disabled");
            loopCooldown = true;
            return 0L;
        }
        if (!Files.tportConfig.getConfig().contains("cooldown." + this.name())) {
            return 0L;
        }
        CooldownManager linkingTo = CooldownManager.get(this.value());
        if (linkingTo != null) {
            if (start == null) {
                start = this;
                errorOccurredWith = player.getName();
            }
            return linkingTo.getTime(player, start);
        }
        if (this.value().equals("permission")) {
            for (PermissionAttachmentInfo permissionInfo : player.getEffectivePermissions()) {
                String permissionString = "TPort.cooldown." + this.name() + ".";
                if (!permissionInfo.getPermission().toLowerCase().startsWith(permissionString.toLowerCase())) continue;
                String valueFromPermission = permissionInfo.getPermission().substring(permissionString.length());
                linkingTo = CooldownManager.get(valueFromPermission);
                if (linkingTo != null) {
                    if (start == null) {
                        start = this;
                        errorOccurredWith = player.getName();
                    }
                    return linkingTo.getTime(player, start);
                }
                try {
                    long longValue = Long.parseLong(valueFromPermission);
                    return cooldownTime.getOrDefault(player.getUniqueId(), new HashMap()).getOrDefault((Object)this, 0L) + longValue - System.currentTimeMillis();
                }
                catch (NumberFormatException nfe) {
                    Main.getInstance().getLogger().log(Level.WARNING, "Permission TPort.cooldown." + this.name() + ".X is not a valid Long value/other cooldown. This was triggered with player " + player.getName() + ". Check their permissions");
                    return 0L;
                }
            }
            return 0L;
        }
        try {
            long value = Long.parseLong(this.value());
            return cooldownTime.getOrDefault(player.getUniqueId(), new HashMap()).getOrDefault((Object)this, 0L) + value - System.currentTimeMillis();
        }
        catch (NumberFormatException nfe) {
            Main.getInstance().getLogger().log(Level.WARNING, "Value set from '" + this.name() + "' is not valid. This was triggered with player " + player.getName() + ". Check the Cooldown configuration in 'TPortConfig.yml'");
            return 0L;
        }
    }

    public boolean hasCooled(Player player) {
        return this.hasCooled(player, true);
    }

    public boolean hasCooled(Player player, boolean sendMessage) {
        long cooldownInSeconds = this.getTime(player) / 1000L;
        if (cooldownInSeconds > 0L) {
            if (sendMessage) {
                ColorTheme.sendErrorTranslation(player, "tport.cooldown.cooldownManager.delayTime", cooldownInSeconds, cooldownInSeconds == 1L ? ColorTheme.formatTranslation(ColorTheme.ColorType.varErrorColor, ColorTheme.ColorType.varError2Color, "tport.command.second", new Object[0]) : ColorTheme.formatTranslation(ColorTheme.ColorType.varErrorColor, ColorTheme.ColorType.varError2Color, "tport.command.seconds", new Object[0]));
                TPortAdvancement.Advancement_TooFast.grant(player);
            }
            return false;
        }
        return true;
    }

    static {
        loopCooldown = false;
        errorOccurredWith = "null";
        cooldownTime = new HashMap();
    }
}

