/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.transfer;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Revoke
extends SubCommand {
    public Revoke() {
        EmptyCommand emptyTPort = new EmptyCommand();
        emptyTPort.setCommandName("TPort name", ArgumentType.REQUIRED);
        emptyTPort.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.transfer.revoke.tportName.commandDescription", new Object[0]));
        this.addAction(emptyTPort);
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        return TPortManager.getTPortList(player.getUniqueId()).stream().filter(TPort::isOffered).map(TPort::getName).collect(Collectors.toList());
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 3) {
            TPort tport = TPortManager.getTPort(player.getUniqueId(), args[2]);
            if (tport == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[2]);
                return;
            }
            if (!tport.isOffered()) {
                ColorTheme.sendErrorTranslation(player, "tport.command.transfer.revoke.tportName.notOffered", TPortEncapsulation.asTPort(tport));
                return;
            }
            UUID toPlayerUUID = tport.getOfferedTo();
            tport.setOfferedTo(null);
            tport.save();
            ColorTheme.sendSuccessTranslation(player, "tport.command.transfer.revoke.tportName.succeeded", TPortEncapsulation.asTPort(tport), PlayerEncapsulation.asPlayer(toPlayerUUID));
            Player toPlayer = Bukkit.getPlayer((UUID)toPlayerUUID);
            ColorTheme.sendInfoTranslation(toPlayer, "tport.command.transfer.revoke.tportName.succeededOtherPlayer", PlayerEncapsulation.asPlayer(player), TPortEncapsulation.asTPort(tport));
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport transfer revoke <TPort name>");
        }
    }
}

