/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.transfer;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.fancyMessage.encapsulation.TPortEncapsulation;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.playerUUID.PlayerUUID;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Accept
extends SubCommand {
    private static final Accept instance = new Accept();
    public final EmptyCommand emptyPlayerTPort = new EmptyCommand();

    public static Accept getInstance() {
        return instance;
    }

    public Accept() {
        this.emptyPlayerTPort.setCommandName("TPort name", ArgumentType.REQUIRED);
        this.emptyPlayerTPort.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.transfer.accept.player.tportName.commandDescription", new Object[0]));
        this.emptyPlayerTPort.setPermissions("TPort.transfer.accept", "TPort.basic");
        EmptyCommand emptyPlayer = new EmptyCommand();
        emptyPlayer.setCommandName("player", ArgumentType.REQUIRED);
        emptyPlayer.setTabRunnable((args, player) -> {
            if (!this.emptyPlayerTPort.hasPermissionToRun(player, false)) {
                return Collections.emptyList();
            }
            UUID newUUID = PlayerUUID.getPlayerUUID(args[2]);
            if (newUUID == null) {
                return Collections.emptyList();
            }
            return TPortManager.getTPortList(newUUID).stream().filter(tport -> player.getUniqueId().equals(tport.getOfferedTo())).map(TPort::getName).collect(Collectors.toList());
        });
        emptyPlayer.addAction(this.emptyPlayerTPort);
        this.addAction(emptyPlayer);
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (!this.emptyPlayerTPort.hasPermissionToRun(player, false)) {
            return list;
        }
        for (String uuidString : Files.tportData.getKeys("tport")) {
            UUID uuid = UUID.fromString(uuidString);
            for (TPort tport : TPortManager.getTPortList(uuid)) {
                if (!player.getUniqueId().equals(tport.getOfferedTo())) continue;
                list.add(PlayerUUID.getPlayerName(uuid));
            }
        }
        return list;
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length != 4) {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport transfer accept <player> <TPort name>");
            return;
        }
        if (!this.emptyPlayerTPort.hasPermissionToRun(player, true)) {
            return;
        }
        UUID newPlayerUUID = PlayerUUID.getPlayerUUID(args[2], player);
        if (newPlayerUUID == null) {
            return;
        }
        TPort tport = TPortManager.getTPort(newPlayerUUID, args[3]);
        if (tport == null) {
            ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[3]);
            return;
        }
        if (!player.getUniqueId().equals(tport.getOfferedTo())) {
            ColorTheme.sendErrorTranslation(player, "tport.command.transfer.accept.player.tportName.notOffered", TPortEncapsulation.asTPort(tport));
            return;
        }
        if (TPortManager.getTPort(player.getUniqueId(), tport.getName()) != null) {
            ColorTheme.sendErrorTranslation(player, "tport.command.transfer.accept.player.tportName.alreadyHasName", TPortEncapsulation.asTPort(tport));
            return;
        }
        UUID oldOwner = tport.getOwner();
        if (TPortManager.addTPort(player, tport, true) != null) {
            tport.getWhitelist().remove(player.getUniqueId());
            if (!tport.getWhitelist().contains(oldOwner)) {
                tport.getWhitelist().add(oldOwner);
            }
            tport.save();
            Player oldPlayer = Bukkit.getPlayer((UUID)oldOwner);
            ColorTheme.sendSuccessTranslation(player, "tport.command.transfer.accept.player.tportName.succeeded", TPortEncapsulation.asTPort(tport), PlayerEncapsulation.asPlayer(oldPlayer, oldOwner));
            ColorTheme.sendInfoTranslation(oldPlayer, "tport.command.transfer.accept.player.tportName.succeededOtherPlayer", PlayerEncapsulation.asPlayer(player), TPortEncapsulation.asTPort(tport));
        } else {
            Player oldPlayer = Bukkit.getPlayer((UUID)oldOwner);
            ColorTheme.sendInfoTranslation(oldPlayer, "tport.command.transfer.accept.player.tportName.couldNotAccept", PlayerEncapsulation.asPlayer(player), TPortEncapsulation.asTPort(tport));
        }
    }
}

