/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.teleporter.create;

import com.spaceman.tport.Pair;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.teleporter.Create;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.playerUUID.PlayerUUID;
import com.spaceman.tport.tport.TPortManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class TPort
extends SubCommand {
    public TPort() {
        EmptyCommand emptyTPortPlayerTPort = new EmptyCommand();
        emptyTPortPlayerTPort.setCommandName("TPort name", ArgumentType.OPTIONAL);
        emptyTPortPlayerTPort.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.tport.player.tportName.commandDescription", new Object[0]));
        emptyTPortPlayerTPort.setPermissions("TPort.teleporter.create");
        EmptyCommand emptyTPortPlayer = new EmptyCommand();
        emptyTPortPlayer.setCommandName("player", ArgumentType.OPTIONAL);
        emptyTPortPlayer.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.tport.player.commandDescription", new Object[0]));
        emptyTPortPlayer.setTabRunnable((args, player) -> {
            UUID otherUUID = PlayerUUID.getPlayerUUID(args[3]);
            if (otherUUID == null) {
                return Collections.emptyList();
            }
            return TPortManager.getTPortList(otherUUID).stream().map(com.spaceman.tport.tport.TPort::getName).collect(Collectors.toList());
        });
        emptyTPortPlayer.addAction(emptyTPortPlayerTPort);
        emptyTPortPlayer.setPermissions("TPort.teleporter.create");
        this.addAction(emptyTPortPlayer);
        this.setPermissions("TPort.teleporter.create");
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.tport.commandDescription", new Object[0]));
    }

    @Override
    public String getName(String arg) {
        return this.getClass().getSimpleName();
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        return PlayerUUID.getPlayerNames();
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length > 2 && args.length < 6) {
            if (!this.hasPermissionToRun(player, true)) {
                return;
            }
            ArrayList<Message> addedLore = new ArrayList<Message>();
            String newPlayerName = null;
            UUID newPlayerUUID = null;
            String tportUUID = null;
            if (args.length > 3) {
                Pair<String, UUID> profile = PlayerUUID.getProfile(args[3], player);
                newPlayerName = profile.getLeft();
                newPlayerUUID = profile.getRight();
                if (newPlayerUUID == null) {
                    return;
                }
                addedLore.add(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.format.data.tport.player", newPlayerName));
            }
            if (args.length > 4) {
                com.spaceman.tport.tport.TPort tport = TPortManager.getTPort(newPlayerUUID, args[4]);
                if (tport == null) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.noTPortFound", args[4]);
                    return;
                }
                String tportName = tport.getName();
                tportUUID = tport.getTportID().toString();
                addedLore.add(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.format.data.tport.player", tportName));
            }
            String newPlayerUUIDString = newPlayerUUID == null ? null : newPlayerUUID.toString();
            Create.createTeleporter(player, "TPort", newPlayerName == null ? "" : "open", List.of(new Pair<String, String>("teleporterTPortUUID", tportUUID), new Pair<String, String>("teleporterPlayerUUID", newPlayerUUIDString)), addedLore);
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport teleporter create TPort [player] [TPort name]");
        }
    }
}

