/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.teleporter.create;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.publc.Open;
import com.spaceman.tport.commands.tport.teleporter.Create;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fileHander.Files;
import com.spaceman.tport.tport.TPort;
import com.spaceman.tport.tport.TPortManager;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class Public
extends SubCommand {
    public Public() {
        EmptyCommand emptyPublicTPort = new EmptyCommand();
        emptyPublicTPort.setCommandName("TPort name", ArgumentType.OPTIONAL);
        emptyPublicTPort.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.public.player.commandDescription", new Object[0]));
        emptyPublicTPort.setPermissions("TPort.teleporter.create");
        this.addAction(emptyPublicTPort);
        this.setPermissions("TPort.teleporter.create");
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.public.commandDescription", new Object[0]));
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        return Files.tportData.getKeys("public.tports").stream().map(publicTPortSlot -> Files.tportData.getConfig().getString("public.tports." + publicTPortSlot, TPortManager.defUUID.toString())).map(tportID -> TPortManager.getTPort(UUID.fromString(tportID))).filter(Objects::nonNull).map(TPort::getName).collect(Collectors.toList());
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 3) {
            if (this.hasPermissionToRun(player, true)) {
                Create.createTeleporter(player, "Public", "public");
            }
        } else if (args.length == 4) {
            if (this.hasPermissionToRun(player, true)) {
                TPort tport = Open.getPublicTPort(args[3]);
                if (tport == null) {
                    ColorTheme.sendErrorTranslation(player, "tport.command.teleporter.create.public.player.TPortNotFound", args[3]);
                    return;
                }
                String tportName = tport.getName();
                Create.createTeleporter(player, "Public", "public open " + tportName, List.of(ColorTheme.formatInfoTranslation("tport.command.teleporter.create.format.data.public.tport", tport)));
            }
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport teleporter create public [TPort name]");
        }
    }
}

