/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.teleporter;

import com.google.gson.JsonObject;
import com.spaceman.tport.Main;
import com.spaceman.tport.Pair;
import com.spaceman.tport.commandHandler.CommandTemplate;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Teleporter;
import com.spaceman.tport.commands.tport.teleporter.create.Back;
import com.spaceman.tport.commands.tport.teleporter.create.BiomeTP;
import com.spaceman.tport.commands.tport.teleporter.create.FeatureTP;
import com.spaceman.tport.commands.tport.teleporter.create.Home;
import com.spaceman.tport.commands.tport.teleporter.create.PLTP;
import com.spaceman.tport.commands.tport.teleporter.create.Public;
import com.spaceman.tport.commands.tport.teleporter.create.TPort;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.MessageUtils;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.language.Language;
import com.spaceman.tport.permissions.PermissionHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class Create
extends SubCommand {
    public Create() {
        this.addAction(new Back());
        this.addAction(new BiomeTP());
        this.addAction(new FeatureTP());
        this.addAction(new PLTP());
        this.addAction(new Public());
        this.addAction(new Home());
        this.addAction(new TPort());
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length > 2) {
            if (!PermissionHandler.hasPermission(player, true, true, "TPort.teleporter.create")) {
                return;
            }
            ItemStack is = player.getInventory().getItemInMainHand();
            if (is.getType().isAir()) {
                ColorTheme.sendErrorTranslation(player, "tport.command.teleporter.create.noItem", new Object[0]);
                return;
            }
            if (is.getType().isEdible()) {
                ColorTheme.sendErrorTranslation(player, "tport.command.teleporter.create.noEdible", new Object[0]);
                return;
            }
            if (!CommandTemplate.runCommands(this.getActions(), args[2], args, player)) {
                ColorTheme.sendErrorTranslation(player, "tport.command.teleporter.create.noValidType", args[2]);
            }
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport teleporter create <type> [data...]");
        }
    }

    public static void createTeleporter(Player player, String type, String command) {
        Create.createTeleporter(player, type, command, null, Collections.emptyList());
    }

    public static void createTeleporter(Player player, String type, String command, List<Message> addedLore) {
        Create.createTeleporter(player, type, command, null, addedLore);
    }

    public static void createTeleporter(Player player, String type, String command, Collection<Pair<String, String>> addedData, List<Message> addedLore) {
        ItemStack is = player.getInventory().getItemInMainHand();
        Teleporter.removeTeleporter(is);
        int size = 3;
        ArrayList<Message> fancyLore = new ArrayList<Message>();
        JsonObject playerLang = Language.getPlayerLang(player.getUniqueId());
        if (playerLang != null) {
            fancyLore.add(MessageUtils.translateMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.titleColor, ColorTheme.ColorType.titleColor, "tport.command.teleporter.create.format.title", new Object[0]), playerLang));
            fancyLore.add(new Message());
            fancyLore.add(MessageUtils.translateMessage(ColorTheme.formatTranslation(ColorTheme.ColorType.infoColor, ColorTheme.ColorType.varInfoColor, "tport.command.teleporter.create.format.type", type), playerLang));
            addedLore = MessageUtils.translateMessage(addedLore, playerLang);
        } else {
            fancyLore.add(ColorTheme.formatTranslation(ColorTheme.ColorType.titleColor, ColorTheme.ColorType.titleColor, "tport.command.teleporter.create.format.title", new Object[0]));
            fancyLore.add(new Message());
            fancyLore.add(ColorTheme.formatTranslation(ColorTheme.ColorType.infoColor, ColorTheme.ColorType.varInfoColor, "tport.command.teleporter.create.format.type", type));
        }
        for (Message m : addedLore) {
            fancyLore.add(m);
            ++size;
        }
        ColorTheme theme = ColorTheme.getTheme(player);
        MessageUtils.setCustomItemData(is, theme, null, fancyLore);
        ItemMeta im = is.getItemMeta();
        if (im == null) {
            ColorTheme.sendErrorTranslation(player, "tport.command.teleporter.create.error", new Object[0]);
            return;
        }
        im.getPersistentDataContainer().set(new NamespacedKey((Plugin)Main.getInstance(), "teleporterVersion"), PersistentDataType.INTEGER, (Object)2);
        im.getPersistentDataContainer().set(new NamespacedKey((Plugin)Main.getInstance(), "teleporterCommand"), PersistentDataType.STRING, (Object)StringUtils.normalizeSpace((String)command));
        im.getPersistentDataContainer().set(new NamespacedKey((Plugin)Main.getInstance(), "teleporterSize"), PersistentDataType.INTEGER, (Object)size);
        if (addedData != null) {
            for (Pair<String, String> addedDatum : addedData) {
                if (addedDatum.getRight() == null) continue;
                im.getPersistentDataContainer().set(new NamespacedKey((Plugin)Main.getInstance(), addedDatum.getLeft()), PersistentDataType.STRING, (Object)addedDatum.getRight());
            }
        }
        is.setItemMeta(im);
    }
}

