/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.tag;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Tag;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import java.util.Collection;
import java.util.Collections;
import org.bukkit.entity.Player;

public class Delete
extends SubCommand {
    private final EmptyCommand emptyTag = new EmptyCommand();

    public Delete() {
        this.emptyTag.setCommandName("tag", ArgumentType.REQUIRED);
        this.emptyTag.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.tag.delete.tag.commandDescription", new Object[0]));
        this.emptyTag.setPermissions("TPort.tag.delete", "TPort.admin.tag");
        this.addAction(this.emptyTag);
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        if (!this.emptyTag.hasPermissionToRun(player, false)) {
            return Collections.emptyList();
        }
        return Tag.getTags();
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 3) {
            if (!this.emptyTag.hasPermissionToRun(player, true)) {
                return;
            }
            String tag = Tag.getTag(args[2]);
            if (tag == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.tag.delete.tag.notExist", args[2]);
                return;
            }
            Tag.deleteTag(tag);
            ColorTheme.sendSuccessTranslation(player, "tport.command.tag.delete.tag.succeeded", tag);
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport tag delete <tag>");
        }
    }
}

