/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.restriction;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Restriction;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.playerUUID.PlayerUUID;
import com.spaceman.tport.tpEvents.TPEManager;
import com.spaceman.tport.tpEvents.TPRestriction;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Set
extends SubCommand {
    private final EmptyCommand emptySetPlayerType = new EmptyCommand();

    public Set() {
        this.emptySetPlayerType.setCommandName("type", ArgumentType.REQUIRED);
        this.emptySetPlayerType.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.restriction.set.player.type.commandDescription", new Object[0]));
        this.emptySetPlayerType.setPermissions("TPort.restriction.set", "TPort.admin.restriction");
        EmptyCommand emptySetPlayer = new EmptyCommand();
        emptySetPlayer.setCommandName("player", ArgumentType.REQUIRED);
        emptySetPlayer.setTabRunnable((args, player) -> TPRestriction.getRestrictions());
        emptySetPlayer.addAction(this.emptySetPlayerType);
        this.addAction(emptySetPlayer);
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        if (!this.emptySetPlayerType.hasPermissionToRun(player, false)) {
            return Collections.emptyList();
        }
        if (!Restriction.isPermissionBased()) {
            return PlayerUUID.getPlayerNames();
        }
        return Collections.emptyList();
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length != 4) {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport restriction set <player> <type>");
            return;
        }
        if (!this.emptySetPlayerType.hasPermissionToRun(player, true)) {
            return;
        }
        if (Restriction.isPermissionBased()) {
            ColorTheme.sendErrorTranslation(player, "tport.command.restriction.set.player.type.managedByPermissions", ColorTheme.formatTranslation(ColorTheme.ColorType.varErrorColor, ColorTheme.ColorType.varError2Color, "tport.command.restriction.type.permission", new Object[0]), "/tport restriction handler command");
            return;
        }
        UUID newUUID = PlayerUUID.getPlayerUUID(args[2], player);
        if (newUUID == null) {
            return;
        }
        if (TPEManager.hasTPRequest(newUUID)) {
            ColorTheme.sendErrorTranslation(player, "tport.command.restriction.set.player.type.isRequesting", PlayerEncapsulation.asPlayer(newUUID));
            return;
        }
        TPRestriction type = TPRestriction.getNewRestriction(args[3]);
        if (type == null) {
            ColorTheme.sendErrorTranslation(player, "tport.command.restriction.set.player.type.tpRestrictionNotExist", args[3]);
            return;
        }
        TPEManager.setTPRestriction(newUUID, type);
        if (player.getUniqueId().equals(newUUID)) {
            ColorTheme.sendInfoTranslation(player, "tport.command.restriction.set.player.type.succeededOwn", type);
        } else {
            Player otherPlayer = Bukkit.getPlayer((UUID)newUUID);
            ColorTheme.sendInfoTranslation(player, "tport.command.restriction.set.player.type.succeeded", PlayerEncapsulation.asPlayer(otherPlayer, newUUID), type);
            ColorTheme.sendInfoTranslation(otherPlayer, "tport.command.restriction.set.player.type.succeededOtherPlayer", PlayerEncapsulation.asPlayer(player), type);
        }
    }
}

