/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.restriction;

import com.spaceman.tport.Main;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Restriction;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.bukkit.entity.Player;

public class Handler
extends SubCommand {
    private final EmptyCommand emptyHandlerState = new EmptyCommand();

    public Handler() {
        this.emptyHandlerState.setCommandName("state", ArgumentType.OPTIONAL);
        this.emptyHandlerState.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.restriction.handler.state.commandDescription", "true", "TPort.restriction.type.<restriction name>"));
        this.emptyHandlerState.setPermissions("TPort.restriction.handler.set", "TPort.admin.restriction");
        this.addAction(this.emptyHandlerState);
        this.setPermissions("TPort.restriction.handler.get", "TPort.admin.restriction");
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.restriction.handler.commandDescription", new Object[0]));
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        if (this.emptyHandlerState.hasPermissionToRun(player, false)) {
            return Arrays.asList("permissions", "command");
        }
        return Collections.emptyList();
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            if (!this.hasPermissionToRun(player, true)) {
                return;
            }
            if (Restriction.isPermissionBased()) {
                Message stateMessage = ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.restriction.type.permission", new Object[0]);
                ColorTheme.sendInfoTranslation(player, "tport.command.restriction.handler.succeeded", stateMessage);
                ColorTheme.sendInfoTranslation(player, "tport.command.restriction.handler.permission", "TPort.restriction.type.<restriction name>");
            } else {
                Message stateMessage = ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.restriction.type.command", new Object[0]);
                ColorTheme.sendInfoTranslation(player, "tport.command.restriction.handler.succeeded", stateMessage);
            }
        } else if (args.length == 3) {
            boolean state;
            if (!this.emptyHandlerState.hasPermissionToRun(player, true)) {
                return;
            }
            if (args[2].equalsIgnoreCase("permissions")) {
                state = true;
            } else if (args[2].equalsIgnoreCase("command")) {
                state = false;
            } else {
                ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport delay handler [permissions|command]");
                return;
            }
            Restriction.setPermissionBased(state);
            Message stateMessage = Main.isTrue(args[2]) ? ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.restriction.type.permission", new Object[0]) : ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.restriction.type.command", new Object[0]);
            ColorTheme.sendInfoTranslation(player, "tport.command.restriction.handler.state.succeeded", stateMessage);
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport restriction handler [state]");
        }
    }
}

