/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.restriction;

import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.Delay;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.encapsulation.PlayerEncapsulation;
import com.spaceman.tport.playerUUID.PlayerUUID;
import com.spaceman.tport.tpEvents.TPEManager;
import com.spaceman.tport.tpEvents.TPRestriction;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Get
extends SubCommand {
    private final EmptyCommand emptyGetPlayer = new EmptyCommand();

    public Get() {
        this.emptyGetPlayer.setCommandName("player", ArgumentType.OPTIONAL);
        this.emptyGetPlayer.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.restriction.get.player.commandDescription", new Object[0]));
        this.emptyGetPlayer.setPermissions("TPort.restriction.get.all", "TPort.admin.restriction");
        this.addAction(this.emptyGetPlayer);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.restriction.get.commandDescription", new Object[0]));
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        if (!this.emptyGetPlayer.hasPermissionToRun(player, false)) {
            return Collections.emptyList();
        }
        return Delay.isPermissionBased() ? (Collection)Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList()) : PlayerUUID.getPlayerNames();
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            ColorTheme.sendInfoTranslation(player, "tport.command.restriction.get.succeeded", TPEManager.getTPRestriction(player.getUniqueId()));
        } else if (args.length == 3) {
            if (!this.emptyGetPlayer.hasPermissionToRun(player, true)) {
                return;
            }
            UUID newPlayerUUID = PlayerUUID.getPlayerUUID(args[2], player);
            if (newPlayerUUID == null) {
                return;
            }
            if (Delay.isPermissionBased() && Bukkit.getPlayer((UUID)newPlayerUUID) == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.playerNotOnline", PlayerEncapsulation.asPlayer(newPlayerUUID));
                return;
            }
            TPRestriction restriction = TPEManager.getTPRestriction(newPlayerUUID);
            ColorTheme.sendInfoTranslation(player, "tport.command.restriction.get.player.succeeded", PlayerEncapsulation.asPlayer(newPlayerUUID), restriction);
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport restriction get [player]");
        }
    }
}

