/*
 * Decompiled with CFR 0.152.
 */
package com.spaceman.tport.commands.tport.resourcePack;

import com.spaceman.tport.Main;
import com.spaceman.tport.commandHandler.ArgumentType;
import com.spaceman.tport.commandHandler.EmptyCommand;
import com.spaceman.tport.commandHandler.SubCommand;
import com.spaceman.tport.commands.tport.ResourcePack;
import com.spaceman.tport.fancyMessage.Message;
import com.spaceman.tport.fancyMessage.TextComponent;
import com.spaceman.tport.fancyMessage.colorTheme.ColorTheme;
import com.spaceman.tport.fancyMessage.events.ClickEvent;
import com.spaceman.tport.fancyMessage.events.HoverEvent;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.entity.Player;

public class State
extends SubCommand {
    public State() {
        EmptyCommand emptyStateState = new EmptyCommand();
        emptyStateState.setCommandName("state", ArgumentType.OPTIONAL);
        emptyStateState.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.resourcePack.state.state.commandDescription", new Object[0]));
        this.addAction(emptyStateState);
        this.setCommandDescription(ColorTheme.formatInfoTranslation("tport.command.resourcePack.state.commandDescription", new Object[0]));
    }

    @Override
    public Collection<String> tabList(Player player, String[] args) {
        return Arrays.asList("true", "false");
    }

    @Override
    public void run(String[] args, Player player) {
        if (args.length == 2) {
            boolean state = ResourcePack.getResourcePackState(player.getUniqueId());
            Message stateMessage = ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.resourcePack.state." + (state ? "enabled" : "disabled"), new Object[0]);
            String releasePath = "https://github.com/JasperBouwman/TPort/releases/tag/TPort%20" + Main.getInstance().getDescription().getVersion();
            Message hereMessage = ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.resourcePack.state.here", new Object[0]);
            hereMessage.getText().forEach(t -> t.setInsertion(releasePath).addTextEvent(HoverEvent.hoverEvent(TextComponent.textComponent(releasePath, ColorTheme.ColorType.infoColor))).addTextEvent(ClickEvent.openUrl(releasePath)));
            ColorTheme.sendInfoTranslation(player, "tport.command.resourcePack.state.succeeded", stateMessage, hereMessage);
        } else if (args.length == 3) {
            Boolean newState = Main.toBoolean(args[2]);
            if (newState == null) {
                ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport resourcePack state [true|false]");
                return;
            }
            boolean currentState = ResourcePack.getResourcePackState(player.getUniqueId());
            if (newState == currentState) {
                Message stateMessage = ColorTheme.formatTranslation(ColorTheme.ColorType.varErrorColor, ColorTheme.ColorType.varError2Color, "tport.command.resourcePack.state.state." + (newState != false ? "enabled" : "disabled"), new Object[0]);
                ColorTheme.sendErrorTranslation(player, "tport.command.resourcePack.state.state.alreadyInState", stateMessage);
                return;
            }
            ResourcePack.setResourcePackState(player.getUniqueId(), newState);
            ResourcePack.updateResourcePack(player, false);
            if (newState.booleanValue()) {
                Message stateMessage = ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.resourcePack.state.state.enabled", new Object[0]);
                ColorTheme.sendInfoTranslation(player, "tport.command.resourcePack.state.state.succeeded.enabled", stateMessage);
            } else {
                Message stateMessage = ColorTheme.formatTranslation(ColorTheme.ColorType.varInfoColor, ColorTheme.ColorType.varInfo2Color, "tport.command.resourcePack.state.state.disabled", new Object[0]);
                ColorTheme.sendInfoTranslation(player, "tport.command.resourcePack.state.state.succeeded.disabled", stateMessage);
            }
        } else {
            ColorTheme.sendErrorTranslation(player, "tport.command.wrongUsage", "/tport resourcePack state [state]");
        }
    }
}

